/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BoundedPriorityBlockingQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBoundedPriorityBlockingQueue {
    private static final int CAPACITY = 16;
    private BoundedPriorityBlockingQueue<TestObject> queue;

    @Before
    public void setUp() throws Exception {
        this.queue = new BoundedPriorityBlockingQueue<TestObject>(16, new TestObjectComparator());
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void tesAppend() throws Exception {
        int i;
        for (i = 1; i <= 16; ++i) {
            Assert.assertTrue((boolean)this.queue.offer(new TestObject(i, i)));
            Assert.assertEquals((long)i, (long)this.queue.size());
            Assert.assertEquals((long)(16 - i), (long)this.queue.remainingCapacity());
        }
        Assert.assertFalse((boolean)this.queue.offer(new TestObject(0, -1), 5L, TimeUnit.MILLISECONDS));
        for (i = 1; i <= 16; ++i) {
            TestObject obj = this.queue.poll();
            Assert.assertEquals((long)i, (long)obj.getSeqId());
            Assert.assertEquals((long)(16 - i), (long)this.queue.size());
            Assert.assertEquals((long)i, (long)this.queue.remainingCapacity());
        }
        Assert.assertEquals(null, (Object)this.queue.poll());
    }

    @Test
    public void tesAppendSamePriority() throws Exception {
        int i;
        for (i = 1; i <= 16; ++i) {
            Assert.assertTrue((boolean)this.queue.offer(new TestObject(0, i)));
            Assert.assertEquals((long)i, (long)this.queue.size());
            Assert.assertEquals((long)(16 - i), (long)this.queue.remainingCapacity());
        }
        Assert.assertFalse((boolean)this.queue.offer(new TestObject(0, -1), 5L, TimeUnit.MILLISECONDS));
        for (i = 1; i <= 16; ++i) {
            TestObject obj = this.queue.poll();
            Assert.assertEquals((long)i, (long)obj.getSeqId());
            Assert.assertEquals((long)(16 - i), (long)this.queue.size());
            Assert.assertEquals((long)i, (long)this.queue.remainingCapacity());
        }
        Assert.assertEquals(null, (Object)this.queue.poll());
    }

    @Test
    public void testPrepend() throws Exception {
        int i;
        for (i = 1; i <= 16; ++i) {
            Assert.assertTrue((boolean)this.queue.offer(new TestObject(16 - i, i)));
            Assert.assertEquals((long)i, (long)this.queue.size());
            Assert.assertEquals((long)(16 - i), (long)this.queue.remainingCapacity());
        }
        for (i = 1; i <= 16; ++i) {
            TestObject obj = this.queue.poll();
            Assert.assertEquals((long)(16 - (i - 1)), (long)obj.getSeqId());
            Assert.assertEquals((long)(16 - i), (long)this.queue.size());
            Assert.assertEquals((long)i, (long)this.queue.remainingCapacity());
        }
        Assert.assertEquals(null, (Object)this.queue.poll());
    }

    @Test
    public void testInsert() throws Exception {
        int i;
        for (i = 1; i <= 16; i += 2) {
            Assert.assertTrue((boolean)this.queue.offer(new TestObject(i, i)));
            Assert.assertEquals((long)((1 + i) / 2), (long)this.queue.size());
        }
        for (i = 2; i <= 16; i += 2) {
            Assert.assertTrue((boolean)this.queue.offer(new TestObject(i, i)));
            Assert.assertEquals((long)(8 + i / 2), (long)this.queue.size());
        }
        Assert.assertFalse((boolean)this.queue.offer(new TestObject(0, -1), 5L, TimeUnit.MILLISECONDS));
        for (i = 1; i <= 16; ++i) {
            TestObject obj = this.queue.poll();
            Assert.assertEquals((long)i, (long)obj.getSeqId());
            Assert.assertEquals((long)(16 - i), (long)this.queue.size());
            Assert.assertEquals((long)i, (long)this.queue.remainingCapacity());
        }
        Assert.assertEquals(null, (Object)this.queue.poll());
    }

    @Test
    public void testFifoSamePriority() throws Exception {
        TestObject obj;
        int i;
        Assert.assertTrue((boolean)true);
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)this.queue.offer(new TestObject((1 + i % 2) * 10, i)));
        }
        for (i = 0; i < 6; i += 2) {
            obj = this.queue.poll();
            Assert.assertEquals((long)10L, (long)obj.getPriority());
            Assert.assertEquals((long)i, (long)obj.getSeqId());
        }
        for (i = 1; i < 6; i += 2) {
            obj = this.queue.poll();
            Assert.assertEquals((long)20L, (long)obj.getPriority());
            Assert.assertEquals((long)i, (long)obj.getSeqId());
        }
        Assert.assertEquals(null, (Object)this.queue.poll());
    }

    @Test
    public void testPoll() {
        int i;
        Assert.assertNull((Object)this.queue.poll());
        PriorityQueue<TestObject> testList = new PriorityQueue<TestObject>(16, new TestObjectComparator());
        for (i = 0; i < 16; ++i) {
            TestObject obj = new TestObject(i, i);
            testList.add(obj);
            this.queue.offer(obj);
        }
        for (i = 0; i < 16; ++i) {
            Assert.assertEquals((Object)testList.poll(), (Object)this.queue.poll());
        }
        Assert.assertNull(null, (Object)this.queue.poll());
    }

    @Test(timeout=10000L)
    public void testPollInExecutor() throws InterruptedException {
        final TestObject testObj = new TestObject(0, 0);
        final CyclicBarrier threadsStarted = new CyclicBarrier(2);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Assert.assertNull(TestBoundedPriorityBlockingQueue.this.queue.poll(1000L, TimeUnit.MILLISECONDS));
                    threadsStarted.await();
                    Assert.assertSame((Object)testObj, TestBoundedPriorityBlockingQueue.this.queue.poll(1000L, TimeUnit.MILLISECONDS));
                    Assert.assertTrue((boolean)TestBoundedPriorityBlockingQueue.this.queue.isEmpty());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    threadsStarted.await();
                    TestBoundedPriorityBlockingQueue.this.queue.offer(testObj);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        executor.shutdown();
        Assert.assertTrue((boolean)executor.awaitTermination(8000L, TimeUnit.MILLISECONDS));
    }

    class TestObjectComparator
    implements Comparator<TestObject> {
        @Override
        public int compare(TestObject a, TestObject b) {
            return a.getPriority() - b.getPriority();
        }
    }

    class TestObject {
        private final int priority;
        private final int seqId;

        public TestObject(int priority, int seqId) {
            this.priority = priority;
            this.seqId = seqId;
        }

        public int getSeqId() {
            return this.seqId;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

