/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class User {
    public static final String HBASE_SECURITY_CONF_KEY = "hbase.security.authentication";
    public static final String HBASE_SECURITY_AUTHORIZATION_CONF_KEY = "hbase.security.authorization";
    public static final String MAPR_SASL = "maprsasl";
    public static final String KERBEROS = "kerberos";
    protected UserGroupInformation ugi;

    public UserGroupInformation getUGI() {
        return this.ugi;
    }

    public String getName() {
        return this.ugi.getUserName();
    }

    public String[] getGroupNames() {
        return this.ugi.getGroupNames();
    }

    public abstract String getShortName();

    public abstract <T> T runAs(PrivilegedAction<T> var1);

    public abstract <T> T runAs(PrivilegedExceptionAction<T> var1) throws IOException, InterruptedException;

    @Deprecated
    public abstract void obtainAuthTokenForJob(Configuration var1, Job var2) throws IOException, InterruptedException;

    @Deprecated
    public abstract void obtainAuthTokenForJob(JobConf var1) throws IOException, InterruptedException;

    public Token<?> getToken(String kind, String service) throws IOException {
        for (Token token : this.ugi.getTokens()) {
            if (!token.getKind().toString().equals(kind) || service == null || !token.getService().toString().equals(service)) continue;
            return token;
        }
        return null;
    }

    public Collection<Token<? extends TokenIdentifier>> getTokens() {
        return this.ugi.getTokens();
    }

    public void addToken(Token<? extends TokenIdentifier> token) {
        this.ugi.addToken(token);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.ugi.equals((Object)((User)o).ugi);
    }

    public int hashCode() {
        return this.ugi.hashCode();
    }

    public String toString() {
        return this.ugi.toString();
    }

    public static User getCurrent() throws IOException {
        SecureHadoopUser user = new SecureHadoopUser();
        if (user.getUGI() == null) {
            return null;
        }
        return user;
    }

    public static <T> T runAsLoginUser(PrivilegedExceptionAction<T> action) throws IOException {
        try {
            Class<?> c = Class.forName("org.apache.hadoop.security.SecurityUtil");
            Class[] types = new Class[]{PrivilegedExceptionAction.class};
            Object[] args = new Object[]{action};
            return (T)Methods.call(c, null, "doAsLoginUser", types, args);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static User create(UserGroupInformation ugi) {
        if (ugi == null) {
            return null;
        }
        return new SecureHadoopUser(ugi);
    }

    public static User createUserForTesting(Configuration conf, String name, String[] groups) {
        User userForTesting = SecureHadoopUser.createUserForTesting(conf, name, groups);
        return userForTesting;
    }

    public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
        SecureHadoopUser.login(conf, fileConfKey, principalConfKey, localhost);
    }

    public static boolean isSecurityEnabled() {
        return SecureHadoopUser.isSecurityEnabled();
    }

    public static boolean isHBaseSecurityEnabled(Configuration conf) {
        String hbaseConfSecurityValue = conf.get(HBASE_SECURITY_CONF_KEY);
        return KERBEROS.equalsIgnoreCase(hbaseConfSecurityValue) || MAPR_SASL.equalsIgnoreCase(hbaseConfSecurityValue);
    }

    private static class SecureHadoopUser
    extends User {
        private String shortName;

        private SecureHadoopUser() throws IOException {
            this.ugi = UserGroupInformation.getCurrentUser();
        }

        private SecureHadoopUser(UserGroupInformation ugi) {
            this.ugi = ugi;
        }

        @Override
        public String getShortName() {
            if (this.shortName != null) {
                return this.shortName;
            }
            try {
                this.shortName = this.ugi.getShortUserName();
                return this.shortName;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error getting user short name", e);
            }
        }

        @Override
        public <T> T runAs(PrivilegedAction<T> action) {
            return (T)this.ugi.doAs(action);
        }

        @Override
        public <T> T runAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
            return (T)this.ugi.doAs(action);
        }

        @Override
        public void obtainAuthTokenForJob(Configuration conf, Job job) throws IOException, InterruptedException {
            try {
                Class<?> c = Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil");
                Methods.call(c, null, "obtainTokenForJob", new Class[]{Configuration.class, UserGroupInformation.class, Job.class}, new Object[]{conf, this.ugi, job});
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failure loading TokenUtil class, is secure RPC available?", cnfe);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error calling TokenUtil.obtainAndCacheToken()");
            }
        }

        @Override
        public void obtainAuthTokenForJob(JobConf job) throws IOException, InterruptedException {
            try {
                Class<?> c = Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil");
                Methods.call(c, null, "obtainTokenForJob", new Class[]{JobConf.class, UserGroupInformation.class}, new Object[]{job, this.ugi});
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failure loading TokenUtil class, is secure RPC available?", cnfe);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error calling TokenUtil.obtainAndCacheToken()");
            }
        }

        public static User createUserForTesting(Configuration conf, String name, String[] groups) {
            return new SecureHadoopUser(UserGroupInformation.createUserForTesting((String)name, (String[])groups));
        }

        public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
            if (SecureHadoopUser.isSecurityEnabled()) {
                SecurityUtil.login((Configuration)conf, (String)fileConfKey, (String)principalConfKey, (String)localhost);
            }
        }

        public static boolean isSecurityEnabled() {
            return UserGroupInformation.isSecurityEnabled();
        }
    }
}

