/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.util.VersionInfo;

@InterfaceAudience.Private
public abstract class StateDumpServlet
extends HttpServlet {
    static final long DEFAULT_TAIL_KB = 100L;
    private static final long serialVersionUID = 1L;

    protected void dumpVersionInfo(PrintWriter out) {
        VersionInfo.writeTo(out);
        out.println("Hadoop " + org.apache.hadoop.util.VersionInfo.getVersion());
        out.println("Source code repository " + org.apache.hadoop.util.VersionInfo.getUrl() + " revision=" + org.apache.hadoop.util.VersionInfo.getRevision());
        out.println("Compiled by " + org.apache.hadoop.util.VersionInfo.getUser() + " on " + org.apache.hadoop.util.VersionInfo.getDate());
    }

    protected boolean isShowQueueDump(Configuration conf) {
        return conf.getBoolean("hbase.regionserver.servlet.show.queuedump", true);
    }

    protected long getTailKbParam(HttpServletRequest request) {
        String param = request.getParameter("tailkb");
        if (param == null) {
            return 100L;
        }
        return Long.parseLong(param);
    }

    protected void dumpExecutors(ExecutorService service, PrintWriter out) throws IOException {
        if (service == null) {
            out.println("ExecutorService is not initialized");
            return;
        }
        Map<String, ExecutorService.ExecutorStatus> statuses = service.getAllExecutorStatuses();
        for (ExecutorService.ExecutorStatus status : statuses.values()) {
            status.dumpTo(out, "  ");
        }
    }
}

