/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.master.snapshot.TestSnapshotFileCache;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSnapshotHFileCleaner {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFileCache.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TABLE_NAME_STR = "testSnapshotManifest";
    private static final String SNAPSHOT_NAME_STR = "testSnapshotManifest-snapshot";
    private static Path rootDir;
    private static FileSystem fs;

    @BeforeClass
    public static void setup() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        rootDir = FSUtils.getRootDir(conf);
        fs = FileSystem.get((Configuration)conf);
    }

    @AfterClass
    public static void cleanup() throws IOException {
        fs.delete(rootDir, true);
    }

    @Test
    public void testFindsSnapshotFilesWhenCleaning() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        FSUtils.setRootDir(conf, TEST_UTIL.getDataTestDir());
        Path rootDir = FSUtils.getRootDir(conf);
        Path archivedHfileDir = new Path(TEST_UTIL.getDataTestDir(), "archive");
        FileSystem fs = FileSystem.get((Configuration)conf);
        SnapshotHFileCleaner cleaner = new SnapshotHFileCleaner();
        cleaner.setConf(conf);
        String snapshotName = "snapshot";
        byte[] snapshot = Bytes.toBytes(snapshotName);
        TableName tableName = TableName.valueOf("table");
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir);
        HRegionInfo mockRegion = new HRegionInfo(tableName);
        Path regionSnapshotDir = new Path(snapshotDir, mockRegion.getEncodedName());
        Path familyDir = new Path(regionSnapshotDir, "family");
        String hfile = "fd1e73e8a96c486090c5cec07b4894c4";
        Path refFile = new Path(familyDir, hfile);
        fs.create(refFile);
        fs.mkdirs(archivedHfileDir);
        fs.createNewFile(new Path(archivedHfileDir, hfile));
        Assert.assertFalse((boolean)cleaner.isFileDeletable(fs.getFileStatus(refFile)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedRegionManifest() throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(SNAPSHOT_NAME_STR, TABLE_NAME_STR);
        builder.addRegionV2();
        builder.corruptOneRegionManifest();
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", new SnapshotFiles());
        try {
            cache.getSnapshotsInProgress();
        }
        catch (CorruptedSnapshotException cse) {
            LOG.info((Object)("Expected exception " + cse));
        }
        finally {
            fs.delete(SnapshotDescriptionUtils.getWorkingSnapshotDir(rootDir), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedDataManifest() throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(SNAPSHOT_NAME_STR, TABLE_NAME_STR);
        builder.addRegionV2();
        builder.consolidate();
        builder.corruptDataManifest();
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", new SnapshotFiles());
        try {
            cache.getSnapshotsInProgress();
        }
        catch (CorruptedSnapshotException cse) {
            LOG.info((Object)("Expected exception " + cse));
        }
        finally {
            fs.delete(SnapshotDescriptionUtils.getWorkingSnapshotDir(rootDir), true);
        }
    }

    @Test
    public void testMissedTmpSnapshot() throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(SNAPSHOT_NAME_STR, TABLE_NAME_STR);
        builder.addRegionV2();
        builder.missOneRegionSnapshotFile();
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, period, 10000000L, "test-snapshot-file-cache-refresh", new SnapshotFiles());
        cache.getSnapshotsInProgress();
        Assert.assertFalse((boolean)fs.exists(builder.getSnapshotsDir()));
    }

    class SnapshotFiles
    implements SnapshotFileCache.SnapshotFileInspector {
        SnapshotFiles() {
        }

        @Override
        public Collection<String> filesUnderSnapshot(Path snapshotDir) throws IOException {
            HashSet<String> files = new HashSet<String>();
            files.addAll(SnapshotReferenceUtil.getHFileNames(TEST_UTIL.getConfiguration(), fs, snapshotDir));
            return files;
        }
    }
}

