/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSafemodeBringsDownMaster {
    private static final Log LOG = LogFactory.getLog(TestSafemodeBringsDownMaster.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSafemodeBringsDownMaster.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        this.resetProcExecutorTestingKillFlag();
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private void resetProcExecutorTestingKillFlag() {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)procExec.isRunning());
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test(timeout=60000L)
    public void testSafemodeBringsDownMaster() throws Exception {
        TableName tableName = TableName.valueOf("testSafemodeBringsDownMaster");
        byte[][] splitKeys = new byte[][]{Bytes.toBytes("a"), Bytes.toBytes("b"), Bytes.toBytes("c")};
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        MiniDFSCluster dfsCluster = UTIL.getDFSCluster();
        DistributedFileSystem dfs = dfsCluster.getFileSystem();
        dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        long timeOut = 180000L;
        long startTime = System.currentTimeMillis();
        int index = -1;
        while ((index = UTIL.getMiniHBaseCluster().getServerWithMeta()) == -1 && startTime + 180000L < System.currentTimeMillis()) {
        }
        if (index != -1) {
            UTIL.getMiniHBaseCluster().abortRegionServer(index);
            UTIL.getMiniHBaseCluster().waitOnRegionServer(index);
        }
        UTIL.waitFor(180000L, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                List<JVMClusterUtil.MasterThread> threads = UTIL.getMiniHBaseCluster().getLiveMasterThreads();
                return threads == null || threads.isEmpty();
            }
        });
        dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
    }
}

