/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestLogsCleaner {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testLogCleaning() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        long ttl = 10000L;
        conf.setLong("hbase.master.logcleaner.ttl", ttl);
        conf.setBoolean("hbase.replication", true);
        Replication.decorateMasterConfiguration(conf);
        DummyServer server = new DummyServer();
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues(server.getZooKeeper(), conf, server);
        repQueues.init(server.getServerName().toString());
        final Path oldLogDir = new Path(TEST_UTIL.getDataTestDir(), "oldWALs");
        String fakeMachineName = URLEncoder.encode(server.getServerName().toString(), "UTF8");
        final FileSystem fs = FileSystem.get((Configuration)conf);
        long now = System.currentTimeMillis();
        fs.delete(oldLogDir, true);
        fs.mkdirs(oldLogDir);
        fs.createNewFile(new Path(oldLogDir, "a"));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + ".a"));
        System.out.println("Now is: " + now);
        for (int i = 1; i < 31; ++i) {
            Path fileName = new Path(oldLogDir, fakeMachineName + "." + (now - (long)i));
            fs.createNewFile(fileName);
            if (i % 10 != 1) continue;
            repQueues.addLog(fakeMachineName, fileName.getName());
            System.out.println("Replication log file: " + fileName);
        }
        Thread.sleep(ttl);
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + now));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + (now + 10000L)));
        for (FileStatus stat : fs.listStatus(oldLogDir)) {
            System.out.println(stat.getPath().toString());
        }
        Assert.assertEquals((long)34L, (long)fs.listStatus(oldLogDir).length);
        LogCleaner cleaner = new LogCleaner(1000, (Stoppable)server, conf, fs, oldLogDir);
        cleaner.chore();
        TEST_UTIL.waitFor(1000L, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                return 5 == fs.listStatus(oldLogDir).length;
            }
        });
        for (FileStatus file : fs.listStatus(oldLogDir)) {
            System.out.println("Kept log files: " + file.getPath().getName());
        }
    }

    @Test(timeout=5000L)
    public void testZnodeCversionChange() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        cleaner.setConf(conf);
        ReplicationQueuesClient rqcMock = (ReplicationQueuesClient)Mockito.mock(ReplicationQueuesClient.class);
        Mockito.when((Object)rqcMock.getQueuesZNodeCversion()).thenReturn((Object)1, (Object[])new Integer[]{2, 3, 4});
        Field rqc = ReplicationLogCleaner.class.getDeclaredField("replicationQueues");
        rqc.setAccessible(true);
        rqc.set(cleaner, rqcMock);
        cleaner.getDeletableFiles(new LinkedList<FileStatus>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZooKeeperAbort() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        ArrayList<FileStatus> dummyFiles = Lists.newArrayList(new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log1")), new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log2")));
        try (FaultyZooKeeperWatcher faultyZK = new FaultyZooKeeperWatcher(conf, "testZooKeeperAbort-faulty", null);){
            faultyZK.init();
            cleaner.setConf(conf, faultyZK);
            Iterable<FileStatus> toDelete = cleaner.getDeletableFiles(dummyFiles);
            Assert.assertFalse((boolean)toDelete.iterator().hasNext());
            Assert.assertFalse((boolean)cleaner.isStopped());
        }
        cleaner = new ReplicationLogCleaner();
        try (ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "testZooKeeperAbort-normal", null);){
            cleaner.setConf(conf, zkw);
            Iterable<FileStatus> filesToDelete = cleaner.getDeletableFiles(dummyFiles);
            Iterator<FileStatus> iter = filesToDelete.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log1"), (Object)iter.next().getPath());
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log2"), (Object)iter.next().getPath());
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }

    static class FaultyZooKeeperWatcher
    extends ZooKeeperWatcher {
        private RecoverableZooKeeper zk;

        public FaultyZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
            super(conf, identifier, abortable);
        }

        public void init() throws Exception {
            this.zk = (RecoverableZooKeeper)Mockito.spy((Object)super.getRecoverableZooKeeper());
            ((RecoverableZooKeeper)Mockito.doThrow((Throwable)new KeeperException.ConnectionLossException()).when((Object)this.zk)).getData("/hbase/replication/rs", null, new Stat());
        }

        @Override
        public RecoverableZooKeeper getRecoverableZooKeeper() {
            return this.zk;
        }
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        @Override
        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            try {
                return new ZooKeeperWatcher(this.getConfiguration(), "dummy server", this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf("regionserver,60020,000000");
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public void stop(String why) {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }
    }
}

