/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.TimeToLiveHFileCleaner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHFileCleaner {
    private static final Log LOG = LogFactory.getLog(TestHFileCleaner.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.startMiniDFSCluster(1);
    }

    @AfterClass
    public static void shutdownCluster() throws IOException {
        UTIL.shutdownMiniDFSCluster();
    }

    @Test
    public void testTTLCleaner() throws IOException, InterruptedException {
        DistributedFileSystem fs = UTIL.getDFSCluster().getFileSystem();
        Path root = UTIL.getDataTestDirOnTestFS();
        Path file = new Path(root, "file");
        fs.createNewFile(file);
        long createTime = System.currentTimeMillis();
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(file));
        TimeToLiveHFileCleaner cleaner = new TimeToLiveHFileCleaner();
        fs.setTimes(file, createTime - 100L, -1L);
        Configuration conf = UTIL.getConfiguration();
        conf.setLong("hbase.master.hfilecleaner.ttl", 100L);
        cleaner.setConf(conf);
        Assert.assertTrue((String)("File not set deletable - check mod time:" + this.getFileStats(file, (FileSystem)fs) + " with create time:" + createTime), (boolean)cleaner.isFileDeletable(fs.getFileStatus(file)));
    }

    private String getFileStats(Path file, FileSystem fs) throws IOException {
        FileStatus status = fs.getFileStatus(file);
        return "File" + file + ", mtime:" + status.getModificationTime() + ", atime:" + status.getAccessTime();
    }

    @Test(timeout=60000L)
    public void testHFileCleaning() throws Exception {
        EnvironmentEdge originalEdge = EnvironmentEdgeManager.getDelegate();
        String prefix = "someHFileThatWouldBeAUUID";
        Configuration conf = UTIL.getConfiguration();
        long ttl = 2000L;
        conf.set("hbase.master.hfilecleaner.plugins", "org.apache.hadoop.hbase.master.cleaner.TimeToLiveHFileCleaner");
        conf.setLong("hbase.master.hfilecleaner.ttl", ttl);
        DummyServer server = new DummyServer();
        Path archivedHfileDir = new Path(UTIL.getDataTestDirOnTestFS(), "archive");
        FileSystem fs = FileSystem.get((Configuration)conf);
        HFileCleaner cleaner = new HFileCleaner(1000, (Stoppable)server, conf, fs, archivedHfileDir);
        final long createTime = System.currentTimeMillis();
        fs.delete(archivedHfileDir, true);
        fs.mkdirs(archivedHfileDir);
        fs.createNewFile(new Path(archivedHfileDir, "dfd-dfd"));
        LOG.debug((Object)("Now is: " + createTime));
        for (int i = 1; i < 32; ++i) {
            FileStatus[] fileName = new Path(archivedHfileDir, prefix + "." + (createTime + (long)i));
            fs.createNewFile((Path)fileName);
            fs.setTimes((Path)fileName, createTime - ttl - 1L, -1L);
            LOG.debug((Object)("Creating " + this.getFileStats((Path)fileName, fs)));
        }
        Path saved = new Path(archivedHfileDir, prefix + ".00000000000");
        fs.createNewFile(saved);
        fs.setTimes(saved, createTime - ttl / 2L, -1L);
        LOG.debug((Object)("Creating " + this.getFileStats(saved, fs)));
        for (FileStatus stat : fs.listStatus(archivedHfileDir)) {
            LOG.debug((Object)stat.getPath().toString());
        }
        Assert.assertEquals((long)33L, (long)fs.listStatus(archivedHfileDir).length);
        EnvironmentEdge setTime = new EnvironmentEdge(){

            @Override
            public long currentTime() {
                return createTime;
            }
        };
        EnvironmentEdgeManager.injectEdge(setTime);
        cleaner.chore();
        Assert.assertEquals((long)1L, (long)fs.listStatus(archivedHfileDir).length);
        for (FileStatus file : fs.listStatus(archivedHfileDir)) {
            LOG.debug((Object)("Kept hfiles: " + file.getPath().getName()));
        }
        EnvironmentEdgeManager.injectEdge(originalEdge);
    }

    @Test
    public void testRemovesEmptyDirectories() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{""});
        DummyServer server = new DummyServer();
        Path archivedHfileDir = new Path(UTIL.getDataTestDirOnTestFS(), "archive");
        DistributedFileSystem fs = UTIL.getDFSCluster().getFileSystem();
        HFileCleaner cleaner = new HFileCleaner(1000, (Stoppable)server, conf, (FileSystem)fs, archivedHfileDir);
        Path table = new Path(archivedHfileDir, "table");
        Path region = new Path(table, "regionsomthing");
        Path family = new Path(region, "fam");
        Path file = new Path(family, "file12345");
        fs.mkdirs(family);
        if (!fs.exists(family)) {
            throw new RuntimeException("Couldn't create test family:" + family);
        }
        fs.create(file).close();
        if (!fs.exists(file)) {
            throw new RuntimeException("Test file didn't get created:" + file);
        }
        cleaner.chore();
        Assert.assertFalse((String)"family directory not removed for empty directory", (boolean)fs.exists(family));
        Assert.assertFalse((String)"region directory not removed for empty directory", (boolean)fs.exists(region));
        Assert.assertFalse((String)"table directory not removed for empty directory", (boolean)fs.exists(table));
        Assert.assertTrue((String)"archive directory", (boolean)fs.exists(archivedHfileDir));
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        @Override
        public Configuration getConfiguration() {
            return UTIL.getConfiguration();
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            try {
                return new ZooKeeperWatcher(this.getConfiguration(), "dummy server", this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf("regionserver,60020,000000");
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public void stop(String why) {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }
    }
}

