/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.mapreduce.TextSortReducer;
import org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestImportTsv
implements Configurable {
    protected static final Log LOG = LogFactory.getLog(TestImportTsv.class);
    protected static final String NAME = TestImportTsv.class.getSimpleName();
    protected static HBaseTestingUtility util = new HBaseTestingUtility();
    protected static final String DELETE_AFTER_LOAD_CONF = NAME + ".deleteAfterLoad";
    protected static final String FORCE_COMBINER_CONF = NAME + ".forceCombiner";
    private final String FAMILY = "FAM";

    public Configuration getConf() {
        return util.getConfiguration();
    }

    public void setConf(Configuration conf) {
        throw new IllegalArgumentException("setConf not supported");
    }

    @BeforeClass
    public static void provisionCluster() throws Exception {
        util.startMiniCluster();
        util.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void releaseCluster() throws Exception {
        util.shutdownMiniMapReduceCluster();
        util.shutdownMiniCluster();
    }

    @Test
    public void testMROnTable() throws Exception {
        String table = "test-" + UUID.randomUUID();
        String[] args = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=\u001b", table};
        util.createTable(TableName.valueOf(table), "FAM");
        TestImportTsv.doMROnTableTest(util, "FAM", null, args, 1);
        util.deleteTable(table);
    }

    @Test
    public void testMROnTableWithTimestamp() throws Exception {
        String table = "test-" + UUID.randomUUID();
        String[] args = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,HBASE_TS_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=,", table};
        String data = "KEY,1234,VALUE1,VALUE2\n";
        util.createTable(TableName.valueOf(table), "FAM");
        TestImportTsv.doMROnTableTest(util, "FAM", data, args, 1);
        util.deleteTable(table);
    }

    @Test
    public void testMROnTableWithCustomMapper() throws Exception {
        String table = "test-" + UUID.randomUUID();
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterCustomTestMapper", table};
        util.createTable(TableName.valueOf(table), "FAM");
        TestImportTsv.doMROnTableTest(util, "FAM", null, args, 3);
        util.deleteTable(table);
    }

    @Test
    public void testBulkOutputWithoutAnExistingTable() throws Exception {
        String table = "test-" + UUID.randomUUID();
        Path hfiles = new Path(util.getDataTestDirOnTestFS(table), "hfiles");
        String[] args = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=\u001b", "-Dimporttsv.bulk.output=" + hfiles.toString(), table};
        TestImportTsv.doMROnTableTest(util, "FAM", null, args, 3);
        util.deleteTable(table);
    }

    @Test
    public void testBulkOutputWithAnExistingTable() throws Exception {
        String table = "test-" + UUID.randomUUID();
        Path hfiles = new Path(util.getDataTestDirOnTestFS(table), "hfiles");
        String[] args = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=\u001b", "-Dimporttsv.bulk.output=" + hfiles.toString(), table};
        util.createTable(TableName.valueOf(table), "FAM");
        TestImportTsv.doMROnTableTest(util, "FAM", null, args, 3);
        util.deleteTable(table);
    }

    @Test
    public void testBulkOutputWithAnExistingTableNoStrictTrue() throws Exception {
        String table = "test-" + UUID.randomUUID();
        Path hfiles = new Path(util.getDataTestDirOnTestFS(table), "hfiles");
        String[] args = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=\u001b", "-Dimporttsv.bulk.output=" + hfiles.toString(), "-Dno.strict=true", table};
        util.createTable(TableName.valueOf(table), "FAM");
        TestImportTsv.doMROnTableTest(util, "FAM", null, args, 3);
        util.deleteTable(table);
    }

    @Test
    public void testJobConfigurationsWithTsvImporterTextMapper() throws Exception {
        String table = "test-" + UUID.randomUUID();
        Path bulkOutputPath = new Path(util.getDataTestDirOnTestFS(table), "hfiles");
        String INPUT_FILE = "InputFile1.csv";
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper", "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=,", "-Dimporttsv.bulk.output=" + bulkOutputPath.toString(), table, INPUT_FILE};
        GenericOptionsParser opts = new GenericOptionsParser(util.getConfiguration(), args);
        args = opts.getRemainingArgs();
        Job job = ImportTsv.createSubmittableJob(util.getConfiguration(), args);
        Assert.assertTrue((boolean)job.getMapperClass().equals(TsvImporterTextMapper.class));
        Assert.assertTrue((boolean)job.getReducerClass().equals(TextSortReducer.class));
        Assert.assertTrue((boolean)job.getMapOutputValueClass().equals(Text.class));
    }

    @Test
    public void testBulkOutputWithTsvImporterTextMapper() throws Exception {
        String table = "test-" + UUID.randomUUID();
        String FAMILY = "FAM";
        Path bulkOutputPath = new Path(util.getDataTestDirOnTestFS(table), "hfiles");
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper", "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=\u001b", "-Dimporttsv.bulk.output=" + bulkOutputPath.toString(), table};
        String data = "KEY\u001bVALUE4\u001bVALUE8\n";
        TestImportTsv.doMROnTableTest(util, FAMILY, data, args, 4);
    }

    @Test(expected=TableNotFoundException.class)
    public void testWithoutAnExistingTableAndCreateTableSetToNo() throws Exception {
        String table = "test-" + UUID.randomUUID();
        String[] args = new String[]{table, "/inputFile"};
        Configuration conf = new Configuration(util.getConfiguration());
        conf.set("importtsv.columns", "HBASE_ROW_KEY,FAM:A");
        conf.set("importtsv.bulk.output", "/output");
        conf.set("create.table", "no");
        ImportTsv.createSubmittableJob(conf, args);
    }

    @Test(expected=TableNotFoundException.class)
    public void testMRWithoutAnExistingTable() throws Exception {
        String table = "test-" + UUID.randomUUID();
        String[] args = new String[]{table, "/inputFile"};
        Configuration conf = new Configuration(util.getConfiguration());
        ImportTsv.createSubmittableJob(conf, args);
    }

    @Test
    public void testTsvImporterTextMapperWithInvalidData() throws Exception {
        String table = "test-" + UUID.randomUUID();
        String FAMILY = "FAM";
        Path bulkOutputPath = new Path(util.getDataTestDirOnTestFS(table), "hfiles");
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper", "-Dimporttsv.columns=HBASE_ROW_KEY,HBASE_TS_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=,", "-Dimporttsv.bulk.output=" + bulkOutputPath.toString(), table};
        String data = "KEY,1234,VALUE1,VALUE2\nKEY\nKEY,1235,VALUE1,VALUE2\n";
        TestImportTsv.doMROnTableTest(util, FAMILY, data, args, 1, 4);
        util.deleteTable(table);
    }

    protected static Tool doMROnTableTest(HBaseTestingUtility util, String family, String data, String[] args) throws Exception {
        return TestImportTsv.doMROnTableTest(util, family, data, args, 1);
    }

    protected static Tool doMROnTableTest(HBaseTestingUtility util, String family, String data, String[] args, int valueMultiplier) throws Exception {
        return TestImportTsv.doMROnTableTest(util, family, data, args, valueMultiplier, -1);
    }

    protected static Tool doMROnTableTest(HBaseTestingUtility util, String family, String data, String[] args, int valueMultiplier, int expectedKVCount) throws Exception {
        String table = args[args.length - 1];
        Configuration conf = new Configuration(util.getConfiguration());
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path inputPath = fs.makeQualified(new Path(util.getDataTestDirOnTestFS(table), "input.dat"));
        FSDataOutputStream op = fs.create(inputPath, true);
        if (data == null) {
            data = "KEY\u001bVALUE1\u001bVALUE2\n";
        }
        op.write(Bytes.toBytes(data));
        op.close();
        LOG.debug((Object)String.format("Wrote test data to file: %s", inputPath));
        if (conf.getBoolean(FORCE_COMBINER_CONF, true)) {
            LOG.debug((Object)"Forcing combiner.");
            conf.setInt("mapreduce.map.combine.minspills", 1);
        }
        ArrayList<String> argv = new ArrayList<String>(Arrays.asList(args));
        argv.add(inputPath.toString());
        ImportTsv tool = new ImportTsv();
        LOG.debug((Object)("Running ImportTsv with arguments: " + argv));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)tool, (String[])argv.toArray(args)));
        boolean createdHFiles = false;
        String outputPath = null;
        for (String arg : argv) {
            if (!arg.contains("importtsv.bulk.output")) continue;
            createdHFiles = true;
            outputPath = arg.split("=")[1];
            break;
        }
        if (createdHFiles) {
            TestImportTsv.validateHFiles(fs, outputPath, family, expectedKVCount);
        } else {
            TestImportTsv.validateTable(conf, TableName.valueOf(table), family, valueMultiplier);
        }
        if (conf.getBoolean(DELETE_AFTER_LOAD_CONF, true)) {
            LOG.debug((Object)"Deleting test subdirectory");
            util.cleanupDataTestDirOnTestFS(table);
        }
        return tool;
    }

    private static void validateTable(Configuration conf, TableName tableName, String family, int valueMultiplier) throws IOException {
        LOG.debug((Object)"Validating table.");
        HTable table = new HTable(conf, tableName);
        boolean verified = false;
        long pause = conf.getLong("hbase.client.pause", 5000L);
        int numRetries = conf.getInt("hbase.client.retries.number", 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                Scan scan = new Scan();
                scan.addFamily(Bytes.toBytes(family));
                ResultScanner resScanner = table.getScanner(scan);
                for (Result res : resScanner) {
                    Assert.assertTrue((res.size() == 2 ? 1 : 0) != 0);
                    List<Cell> kvs = res.listCells();
                    Assert.assertTrue((boolean)CellUtil.matchingRow(kvs.get(0), Bytes.toBytes("KEY")));
                    Assert.assertTrue((boolean)CellUtil.matchingRow(kvs.get(1), Bytes.toBytes("KEY")));
                    Assert.assertTrue((boolean)CellUtil.matchingValue(kvs.get(0), Bytes.toBytes("VALUE" + valueMultiplier)));
                    Assert.assertTrue((boolean)CellUtil.matchingValue(kvs.get(1), Bytes.toBytes("VALUE" + 2 * valueMultiplier)));
                }
                verified = true;
                break;
            }
            catch (NullPointerException nullPointerException) {
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        table.close();
        Assert.assertTrue((boolean)verified);
    }

    private static void validateHFiles(FileSystem fs, String outputPath, String family, int expectedKVCount) throws IOException {
        LOG.debug((Object)"Validating HFiles.");
        HashSet<String> configFamilies = new HashSet<String>();
        configFamilies.add(family);
        HashSet<String> foundFamilies = new HashSet<String>();
        int actualKVCount = 0;
        for (FileStatus cfStatus : fs.listStatus(new Path(outputPath), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter())) {
            String[] elements = cfStatus.getPath().toString().split("/");
            String cf = elements[elements.length - 1];
            foundFamilies.add(cf);
            Assert.assertTrue((String)String.format("HFile output contains a column family (%s) not present in input families (%s)", cf, configFamilies), (boolean)configFamilies.contains(cf));
            for (FileStatus hfile : fs.listStatus(cfStatus.getPath())) {
                Assert.assertTrue((String)String.format("HFile %s appears to contain no data.", hfile.getPath()), (hfile.getLen() > 0L ? 1 : 0) != 0);
                if (expectedKVCount <= -1) continue;
                actualKVCount += TestImportTsv.getKVCountFromHfile(fs, hfile.getPath());
            }
        }
        if (expectedKVCount > -1) {
            Assert.assertTrue((String)String.format("KV count in output hfile=<%d> doesn't match with expected KV count=<%d>", actualKVCount, expectedKVCount), (actualKVCount == expectedKVCount ? 1 : 0) != 0);
        }
    }

    private static int getKVCountFromHfile(FileSystem fs, Path p) throws IOException {
        Configuration conf = util.getConfiguration();
        HFile.Reader reader = HFile.createReader(fs, p, new CacheConfig(conf), conf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, false);
        scanner.seekTo();
        int count = 0;
        do {
            ++count;
        } while (scanner.next());
        reader.close();
        return count;
    }
}

