/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MapRSslConfigReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.http.FiltersUtil;
import org.apache.hadoop.hbase.http.HttpConfig;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.mortbay.jetty.servlet.Context;

@InterfaceAudience.Private
public class InfoServer {
    private static final String HBASE_APP_DIR = "hbase-webapps";
    private final HttpServer httpServer;

    public InfoServer(String name, String bindAddress, int port, boolean findPort, Configuration c) throws IOException {
        HttpConfig httpConfig = new HttpConfig(c);
        HttpServer.Builder builder = new HttpServer.Builder();
        builder.setName(name).addEndpoint(URI.create(httpConfig.getSchemePrefix() + bindAddress + ":" + port)).setAppDir(HBASE_APP_DIR).setFindPort(findPort).setConf(c);
        String logDir = System.getProperty("hbase.log.dir");
        if (logDir != null) {
            builder.setLogDir(logDir);
        }
        if (httpConfig.isSecure()) {
            String keyPassword = HBaseConfiguration.getPassword(c, "ssl.server.keystore.keypassword", MapRSslConfigReader.getServerKeyPassword());
            String keystore = c.get("ssl.server.keystore.location", MapRSslConfigReader.getServerKeystoreLocation());
            String keystorePassword = HBaseConfiguration.getPassword(c, "ssl.server.keystore.password", MapRSslConfigReader.getServerKeystorePassword());
            String keystoreType = c.get("ssl.server.keystore.type", MapRSslConfigReader.getServerKeystoreType());
            String truststore = c.get("ssl.server.truststore.location", MapRSslConfigReader.getServerTruststoreLocation());
            String truststorePassword = HBaseConfiguration.getPassword(c, "ssl.server.truststore.password", MapRSslConfigReader.getServerTruststorePassword());
            String truststoreType = c.get("ssl.server.truststore.type", MapRSslConfigReader.getServerTruststoreType());
            builder.keyPassword(keyPassword).keyStore(keystore, keystorePassword, keystoreType).trustStore(truststore, truststorePassword, truststoreType);
        }
        this.httpServer = builder.build();
        FiltersUtil.addCustomHeadersFilterIfPresent((Context)this.httpServer.getWebAppContext(), c);
        if ("maprsasl".equalsIgnoreCase(c.get("hbase.security.authentication")) || "kerberos".equalsIgnoreCase(c.get("hbase.security.authentication"))) {
            this.httpServer.addGlobalFilter(AuthenticationFilter.class.getName(), AuthenticationFilter.class.getName(), this.createAuthParams());
        }
    }

    private Map<String, String> createAuthParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("config.prefix", "hadoop.http.authentication");
        params.put("hadoop.http.authentication.type", "org.apache.hadoop.security.authentication.server.MultiMechsAuthenticationHandler");
        params.put("hadoop.http.authentication.signature.secret", "com.mapr.security.maprauth.MaprSignatureSecretFactory");
        return params;
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.httpServer.addServlet(name, pathSpec, clazz);
    }

    public void setAttribute(String name, Object value) {
        this.httpServer.setAttribute(name, value);
    }

    public void start() throws IOException {
        this.httpServer.start();
    }

    @Deprecated
    public int getPort() {
        return this.httpServer.getPort();
    }

    public void stop() throws Exception {
        this.httpServer.stop();
    }
}

