/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class WhileMatchFilter
extends FilterBase {
    private boolean filterAllRemaining = false;
    private Filter filter;

    public WhileMatchFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void reset() throws IOException {
        this.filter.reset();
    }

    private void changeFAR(boolean value) {
        this.filterAllRemaining = this.filterAllRemaining || value;
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        return this.filterAllRemaining || this.filter.filterAllRemaining();
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
        boolean value = this.filter.filterRowKey(buffer, offset, length);
        this.changeFAR(value);
        return value;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
        Filter.ReturnCode c = this.filter.filterKeyValue(v);
        this.changeFAR(c != Filter.ReturnCode.INCLUDE);
        return c;
    }

    @Override
    public Cell transformCell(Cell v) throws IOException {
        return this.filter.transformCell(v);
    }

    @Override
    public boolean filterRow() throws IOException {
        boolean filterRow = this.filter.filterRow();
        this.changeFAR(filterRow);
        return filterRow;
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        FilterProtos.WhileMatchFilter.Builder builder = FilterProtos.WhileMatchFilter.newBuilder();
        builder.setFilter(ProtobufUtil.toFilter(this.filter));
        return builder.build().toByteArray();
    }

    public static WhileMatchFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.WhileMatchFilter proto;
        try {
            proto = FilterProtos.WhileMatchFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        try {
            return new WhileMatchFilter(ProtobufUtil.toFilter(proto.getFilter()));
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhileMatchFilter)) {
            return false;
        }
        WhileMatchFilter other = (WhileMatchFilter)o;
        return this.getFilter().areSerializedFieldsEqual(other.getFilter());
    }

    @Override
    public boolean isFamilyEssential(byte[] name) throws IOException {
        return this.filter.isFamilyEssential(name);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.filter.toString();
    }
}

