/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFilterWrapper {
    private static final Log LOG = LogFactory.getLog(TestFilterWrapper.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf = null;
    private static HBaseAdmin admin = null;
    private static TableName name = TableName.valueOf("test");

    @Test
    public void testFilterWrapper() {
        int kv_number = 0;
        int row_number = 0;
        try {
            Scan scan = new Scan();
            ArrayList<Filter> fs = new ArrayList<Filter>();
            DependentColumnFilter f1 = new DependentColumnFilter(Bytes.toBytes("f1"), Bytes.toBytes("c5"), true, CompareFilter.CompareOp.EQUAL, new SubstringComparator("c5"));
            PageFilter f2 = new PageFilter(2L);
            fs.add(f1);
            fs.add(f2);
            FilterList filter = new FilterList(fs);
            scan.setFilter(filter);
            HTable table = new HTable(conf, name);
            ResultScanner scanner = table.getScanner(scan);
            for (Result result : scanner) {
                ++row_number;
                for (Cell kv : result.listCells()) {
                    LOG.debug((Object)(kv_number + ". kv: " + kv));
                    ++kv_number;
                    Assert.assertEquals((String)"Returned row is not correct", (Object)new String(CellUtil.cloneRow(kv)), (Object)("row" + (row_number + 1)));
                }
            }
            scanner.close();
            table.close();
        }
        catch (Exception e) {
            Assert.assertNull((String)"Exception happens in scan", (Object)e);
        }
        LOG.debug((Object)"check the fetched kv number");
        Assert.assertEquals((String)"We should get 8 results returned.", (long)8L, (long)kv_number);
        Assert.assertEquals((String)"We should get 2 rows returned", (long)2L, (long)row_number);
    }

    private static void prepareData() {
        try {
            HTable table = new HTable(conf, name);
            Assert.assertTrue((String)"Fail to create the table", (boolean)admin.tableExists(name));
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = 1; i < 4; ++i) {
                Put put = new Put(Bytes.toBytes("row" + i));
                for (int j = 1; j < 6; ++j) {
                    long timestamp = j;
                    if (i != 1) {
                        timestamp = i;
                    }
                    put.add(Bytes.toBytes("f1"), Bytes.toBytes("c" + j), timestamp, Bytes.toBytes(i + "_c" + j));
                }
                puts.add(put);
            }
            table.put(puts);
            table.close();
        }
        catch (IOException e) {
            Assert.assertNull((String)"Exception found while putting data into table", (Object)e);
        }
    }

    private static void createTable() {
        Assert.assertNotNull((String)"HBaseAdmin is not initialized successfully.", (Object)admin);
        if (admin != null) {
            HTableDescriptor desc = new HTableDescriptor(name);
            HColumnDescriptor coldef = new HColumnDescriptor(Bytes.toBytes("f1"));
            desc.addFamily(coldef);
            try {
                admin.createTable(desc);
                Assert.assertTrue((String)"Fail to create the table", (boolean)admin.tableExists(name));
            }
            catch (IOException e) {
                Assert.assertNull((String)"Exception found while creating table", (Object)e);
            }
        }
    }

    private static void deleteTable() {
        if (admin != null) {
            try {
                admin.disableTable(name);
                admin.deleteTable(name);
            }
            catch (IOException e) {
                Assert.assertNull((String)"Exception found deleting the table", (Object)e);
            }
        }
    }

    private static void initialize(Configuration conf) {
        TestFilterWrapper.conf = HBaseConfiguration.create(conf);
        TestFilterWrapper.conf.setInt("hbase.client.retries.number", 1);
        try {
            admin = new HBaseAdmin(conf);
        }
        catch (MasterNotRunningException e) {
            Assert.assertNull((String)"Master is not running", (Object)e);
        }
        catch (ZooKeeperConnectionException e) {
            Assert.assertNull((String)"Cannot connect to Zookeeper", (Object)e);
        }
        catch (IOException e) {
            Assert.assertNull((String)"Caught IOException", (Object)e);
        }
        TestFilterWrapper.createTable();
        TestFilterWrapper.prepareData();
    }

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration config = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(1);
        TestFilterWrapper.initialize(TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestFilterWrapper.deleteTable();
        TEST_UTIL.shutdownMiniCluster();
    }
}

