/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestNegativeMemstoreSizeWithSlowCoprocessor {
    static final Log LOG = LogFactory.getLog(TestNegativeMemstoreSizeWithSlowCoprocessor.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] tableName = Bytes.toBytes("test_table");
    private static final byte[] family = Bytes.toBytes("f");
    private static final byte[] qualifier = Bytes.toBytes("q");

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{FlushingRegionObserver.class.getName()});
        conf.setBoolean("hbase.coprocessor.abortonerror", true);
        conf.setInt("hbase.client.retries.number", 2);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TableName.valueOf(tableName), family);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegativeMemstoreSize() throws IOException, InterruptedException {
        boolean IOEthrown = false;
        Table table = null;
        try {
            table = TEST_UTIL.getConnection().getTable(TableName.valueOf(tableName));
            Put put1 = new Put(Bytes.toBytes("row1"));
            put1.addColumn(family, qualifier, Bytes.toBytes("Value1"));
            table.put(put1);
            Put put2 = new Put(Bytes.toBytes("row2"));
            put2.addColumn(family, qualifier, Bytes.toBytes("Value2"));
            table.put(put2);
            table.put(put2);
        }
        catch (IOException e) {
            IOEthrown = true;
        }
        finally {
            Assert.assertFalse((String)"Shouldn't have thrown an exception", (boolean)IOEthrown);
            if (table != null) {
                table.close();
            }
        }
    }

    public static class FlushingRegionObserver
    extends SimpleRegionObserver {
        @Override
        public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            HRegion region = (HRegion)c.getEnvironment().getRegion();
            super.postPut(c, put, edit, durability);
            if (Bytes.equals(put.getRow(), Bytes.toBytes("row2"))) {
                region.flush(false);
                Assert.assertTrue((region.addAndGetGlobalMemstoreSize(0L) >= 0L ? 1 : 0) != 0);
            }
        }
    }
}

