/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.constraint;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.constraint.BaseConstraint;

public class CheckConfigurationConstraint
extends BaseConstraint {
    private static String key = "testKey";
    private static String value = "testValue";

    public static Configuration getConfiguration() {
        Configuration conf = new Configuration(false);
        conf.set(key, value);
        return conf;
    }

    @Override
    public void check(Put p) {
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null) {
            String val = conf.get(key);
            if (val == null || !val.equals(value)) {
                throw new IllegalArgumentException("Configuration was not passed correctly");
            }
            if (conf.getRaw("fs.file.impl") != null) {
                throw new IllegalArgumentException("Configuration was created using 'new Configuration()', should be done via 'new Configuration(false) to exclude defaut hadoop configurations values.");
            }
        }
    }
}

