/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationAdminWithClusters
extends TestReplicationBase {
    static Connection connection1;
    static Connection connection2;
    static Admin admin1;
    static Admin admin2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestReplicationBase.setUpBeforeClass();
        connection1 = ConnectionFactory.createConnection(conf1);
        connection2 = ConnectionFactory.createConnection(conf2);
        admin1 = connection1.getAdmin();
        admin2 = connection2.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        admin1.close();
        admin2.close();
        connection1.close();
        connection2.close();
        TestReplicationBase.tearDownAfterClass();
    }

    @Test(timeout=300000L)
    public void testEnableReplicationWhenSlaveClusterDoesntHaveTable() throws Exception {
        admin2.disableTable(tableName);
        admin2.deleteTable(tableName);
        Assert.assertFalse((boolean)admin2.tableExists(tableName));
        ReplicationAdmin adminExt = new ReplicationAdmin(conf1);
        adminExt.enableTableRep(tableName);
        Assert.assertTrue((boolean)admin2.tableExists(tableName));
    }

    @Test(timeout=300000L)
    public void testEnableReplicationWhenReplicationNotEnabled() throws Exception {
        HTableDescriptor table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            fam.setScope(0);
        }
        admin1.disableTable(tableName);
        admin1.modifyTable(tableName, table);
        admin1.enableTable(tableName);
        admin2.disableTable(tableName);
        admin2.modifyTable(tableName, table);
        admin2.enableTable(tableName);
        ReplicationAdmin adminExt = new ReplicationAdmin(conf1);
        adminExt.enableTableRep(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)1L);
        }
    }

    @Test(timeout=300000L)
    public void testEnableReplicationWhenTableDescriptorIsNotSameInClusters() throws Exception {
        HTableDescriptor table = admin2.getTableDescriptor(tableName);
        HColumnDescriptor f = new HColumnDescriptor("newFamily");
        table.addFamily(f);
        admin2.disableTable(tableName);
        admin2.modifyTable(tableName, table);
        admin2.enableTable(tableName);
        ReplicationAdmin adminExt = new ReplicationAdmin(conf1);
        try {
            adminExt.enableTableRep(tableName);
            Assert.fail((String)"Exception should be thrown if table descriptors in the clusters are not same.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        admin1.disableTable(tableName);
        admin1.modifyTable(tableName, table);
        admin1.enableTable(tableName);
        adminExt.enableTableRep(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)1L);
        }
    }

    @Test(timeout=300000L)
    public void testDisableAndEnableReplication() throws Exception {
        ReplicationAdmin adminExt = new ReplicationAdmin(conf1);
        adminExt.disableTableRep(tableName);
        HTableDescriptor table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)0L);
        }
        table = admin2.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)0L);
        }
        adminExt.enableTableRep(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)fam.getScope(), (long)1L);
        }
    }

    @Test(timeout=300000L, expected=TableNotFoundException.class)
    public void testDisableReplicationForNonExistingTable() throws Exception {
        ReplicationAdmin adminExt = new ReplicationAdmin(conf1);
        adminExt.disableTableRep(TableName.valueOf("nonExistingTable"));
    }

    @Test(timeout=300000L, expected=TableNotFoundException.class)
    public void testEnableReplicationForNonExistingTable() throws Exception {
        ReplicationAdmin adminExt = new ReplicationAdmin(conf1);
        adminExt.enableTableRep(TableName.valueOf("nonExistingTable"));
    }

    @Test(timeout=300000L, expected=IllegalArgumentException.class)
    public void testDisableReplicationWhenTableNameAsNull() throws Exception {
        ReplicationAdmin adminExt = new ReplicationAdmin(conf1);
        adminExt.disableTableRep(null);
    }

    @Test(timeout=300000L, expected=IllegalArgumentException.class)
    public void testEnableReplicationWhenTableNameAsNull() throws Exception {
        ReplicationAdmin adminExt = new ReplicationAdmin(conf1);
        adminExt.enableTableRep(null);
    }
}

