/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import drill.shaded.hbase.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class TableConfiguration {
    public static final String WRITE_BUFFER_SIZE_KEY = "hbase.client.write.buffer";
    public static final long WRITE_BUFFER_SIZE_DEFAULT = 0x200000L;
    public static final String MAX_KEYVALUE_SIZE_KEY = "hbase.client.keyvalue.maxsize";
    public static final int MAX_KEYVALUE_SIZE_DEFAULT = -1;
    private final long writeBufferSize;
    private final int metaOperationTimeout;
    private final int operationTimeout;
    private final int scannerCaching;
    private final long scannerMaxResultSize;
    private final int primaryCallTimeoutMicroSecond;
    private final int replicaCallTimeoutMicroSecondScan;
    private final int retries;
    private final int maxKeyValueSize;

    public TableConfiguration(Configuration conf) {
        this.writeBufferSize = conf.getLong(WRITE_BUFFER_SIZE_KEY, 0x200000L);
        this.metaOperationTimeout = conf.getInt("hbase.client.meta.operation.timeout", 1200000);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.scannerMaxResultSize = conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.primaryCallTimeoutMicroSecond = conf.getInt("hbase.client.primaryCallTimeout.get", 10000);
        this.replicaCallTimeoutMicroSecondScan = conf.getInt("hbase.client.replicaCallTimeout.scan", 1000000);
        this.retries = conf.getInt("hbase.client.retries.number", 31);
        this.maxKeyValueSize = conf.getInt(MAX_KEYVALUE_SIZE_KEY, -1);
    }

    @VisibleForTesting
    protected TableConfiguration() {
        this.writeBufferSize = 0x200000L;
        this.metaOperationTimeout = 1200000;
        this.operationTimeout = 1200000;
        this.scannerCaching = Integer.MAX_VALUE;
        this.scannerMaxResultSize = 0x200000L;
        this.primaryCallTimeoutMicroSecond = 10000;
        this.replicaCallTimeoutMicroSecondScan = 1000000;
        this.retries = 31;
        this.maxKeyValueSize = -1;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public int getMetaOperationTimeout() {
        return this.metaOperationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public int getPrimaryCallTimeoutMicroSecond() {
        return this.primaryCallTimeoutMicroSecond;
    }

    public int getReplicaCallTimeoutMicroSecondScan() {
        return this.replicaCallTimeoutMicroSecondScan;
    }

    public int getRetriesNumber() {
        return this.retries;
    }

    public int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }

    public long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }
}

