/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestInfoServers {
    static final Log LOG = LogFactory.getLog(TestInfoServers.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        UTIL.getConfiguration().setInt("hbase.regionserver.info.port", 0);
        UTIL.getConfiguration().setBoolean("hbase.master.ui.readonly", true);
        UTIL.startMiniCluster();
        if (!UTIL.getHBaseCluster().waitForActiveAndReadyMaster(30000L)) {
            throw new RuntimeException("Active master not ready");
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testInfoServersRedirect() throws Exception {
        int port = UTIL.getHBaseCluster().getMaster().getInfoServer().getPort();
        this.assertContainsContent(new URL("http://localhost:" + port + "/index.html"), "master-status");
        port = UTIL.getHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getInfoServer().getPort();
        this.assertContainsContent(new URL("http://localhost:" + port + "/index.html"), "rs-status");
    }

    @Test
    public void testInfoServersStatusPages() throws Exception {
        int port = UTIL.getHBaseCluster().getMaster().getInfoServer().getPort();
        this.assertContainsContent(new URL("http://localhost:" + port + "/master-status"), "meta");
        port = UTIL.getHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getInfoServer().getPort();
        this.assertContainsContent(new URL("http://localhost:" + port + "/rs-status"), "meta");
    }

    @Test
    public void testMasterServerReadOnly() throws Exception {
        TableName tableName = TableName.valueOf("testMasterServerReadOnly");
        byte[] cf = Bytes.toBytes("d");
        UTIL.createTable(tableName, cf);
        UTIL.waitTableAvailable(tableName);
        int port = UTIL.getHBaseCluster().getMaster().getInfoServer().getPort();
        this.assertDoesNotContainContent(new URL("http://localhost:" + port + "/table.jsp?name=" + tableName + "&action=split&key="), "Table action request accepted");
        this.assertDoesNotContainContent(new URL("http://localhost:" + port + "/table.jsp?name=" + tableName), "Actions:");
    }

    private void assertContainsContent(URL u, String expected) throws IOException {
        LOG.info((Object)("Testing " + u.toString() + " has " + expected));
        String content = this.getUrlContent(u);
        Assert.assertTrue((String)("expected=" + expected + ", content=" + content), (boolean)content.contains(expected));
    }

    private void assertDoesNotContainContent(URL u, String expected) throws IOException {
        LOG.info((Object)("Testing " + u.toString() + " does not have " + expected));
        String content = this.getUrlContent(u);
        Assert.assertFalse((String)("Does Not Contain =" + expected + ", content=" + content), (boolean)content.contains(expected));
    }

    private String getUrlContent(URL u) throws IOException {
        URLConnection c = u.openConnection();
        c.setConnectTimeout(2000);
        c.setReadTimeout(2000);
        c.connect();
        try (InputStream in = c.getInputStream();){
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
    }
}

