/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.quotas.RegionServerQuotaManager;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class MockRegionServerServices
implements RegionServerServices {
    protected static final Log LOG = LogFactory.getLog(MockRegionServerServices.class);
    private final Map<String, Region> regions = new HashMap<String, Region>();
    private final ConcurrentSkipListMap<byte[], Boolean> rit = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private HFileSystem hfs = null;
    private final Configuration conf;
    private ZooKeeperWatcher zkw = null;
    private ServerName serverName = null;
    private RpcServerInterface rpcServer = null;
    private volatile boolean abortRequested;
    private volatile boolean stopping = false;
    private final AtomicBoolean running = new AtomicBoolean(true);

    MockRegionServerServices(ZooKeeperWatcher zkw) {
        this(zkw, null);
    }

    MockRegionServerServices(ZooKeeperWatcher zkw, ServerName serverName) {
        this.zkw = zkw;
        this.serverName = serverName;
        this.conf = zkw == null ? new Configuration() : zkw.getConfiguration();
    }

    MockRegionServerServices() {
        this(null, null);
    }

    public MockRegionServerServices(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public boolean removeFromOnlineRegions(Region r, ServerName destination) {
        return this.regions.remove(r.getRegionInfo().getEncodedName()) != null;
    }

    @Override
    public Region getFromOnlineRegions(String encodedRegionName) {
        return this.regions.get(encodedRegionName);
    }

    @Override
    public List<Region> getOnlineRegions(TableName tableName) throws IOException {
        return null;
    }

    @Override
    public Set<TableName> getOnlineTables() {
        return null;
    }

    @Override
    public void addToOnlineRegions(Region r) {
        this.regions.put(r.getRegionInfo().getEncodedName(), r);
    }

    @Override
    public void postOpenDeployTasks(Region r) throws KeeperException, IOException {
        this.addToOnlineRegions(r);
    }

    @Override
    public void postOpenDeployTasks(RegionServerServices.PostOpenDeployContext context) throws KeeperException, IOException {
        this.addToOnlineRegions(context.getRegion());
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public RpcServerInterface getRpcServer() {
        return this.rpcServer;
    }

    public void setRpcServer(RpcServerInterface rpc) {
        this.rpcServer = rpc;
    }

    public ConcurrentSkipListMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return this.rit;
    }

    @Override
    public FlushRequester getFlushRequester() {
        return null;
    }

    @Override
    public CompactionRequestor getCompactionRequester() {
        return null;
    }

    @Override
    public ClusterConnection getConnection() {
        return null;
    }

    @Override
    public MetaTableLocator getMetaTableLocator() {
        return null;
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zkw;
    }

    @Override
    public CoordinatedStateManager getCoordinatedStateManager() {
        return null;
    }

    @Override
    public RegionServerAccounting getRegionServerAccounting() {
        return null;
    }

    @Override
    public TableLockManager getTableLockManager() {
        return new TableLockManager.NullTableLockManager();
    }

    @Override
    public RegionServerQuotaManager getRegionServerQuotaManager() {
        return null;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void abort(String why, Throwable e) {
        this.abortRequested = true;
        this.stop(why);
    }

    @Override
    public void stop(String why) {
        this.stopping = true;
        if (this.running.compareAndSet(true, false)) {
            LOG.info((Object)("Shutting down due to request '" + why + "'"));
        }
    }

    @Override
    public boolean isStopped() {
        return !this.running.get();
    }

    @Override
    public boolean isAborted() {
        return this.abortRequested;
    }

    public HFileSystem getFileSystem() {
        return this.hfs;
    }

    public void setFileSystem(FileSystem hfs) {
        this.hfs = (HFileSystem)hfs;
    }

    @Override
    public Leases getLeases() {
        return null;
    }

    @Override
    public WAL getWAL(HRegionInfo regionInfo) throws IOException {
        return null;
    }

    @Override
    public ExecutorService getExecutorService() {
        return null;
    }

    @Override
    public ChoreService getChoreService() {
        return null;
    }

    @Override
    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
    }

    @Override
    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return null;
    }

    @Override
    public Map<String, Region> getRecoveringRegions() {
        return null;
    }

    @Override
    public ServerNonceManager getNonceManager() {
        return null;
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, HRegionInfo ... hris) {
        return false;
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, HRegionInfo ... hris) {
        return false;
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerServices.RegionStateTransitionContext context) {
        return false;
    }

    @Override
    public boolean registerService(Service service) {
        return false;
    }

    @Override
    public HeapMemoryManager getHeapMemoryManager() {
        return null;
    }

    @Override
    public double getCompactionPressure() {
        return 0.0;
    }
}

