/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.xml;

import java.nio.file.Paths;
import org.apache.drill.categories.RowSetTests;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.xml.XMLFormatConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryTestUtil;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTests.class})
public class TestXMLReader
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        XMLFormatConfig formatConfig = new XMLFormatConfig(null, 2);
        cluster.defineFormat("cp", "xml", (FormatPluginConfig)formatConfig);
        cluster.defineFormat("dfs", "xml", (FormatPluginConfig)formatConfig);
        dirTestWatcher.copyResourceToRoot(Paths.get("xml/", new String[0]));
    }

    @Test
    public void testWildcard() throws Exception {
        String sql = "SELECT * FROM cp.`xml/simple.xml`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        TupleMetadata expectedSchema = new SchemaBuilder().add("attributes", TypeProtos.MinorType.MAP).addNullable("groupID", TypeProtos.MinorType.VARCHAR).addNullable("artifactID", TypeProtos.MinorType.VARCHAR).addNullable("version", TypeProtos.MinorType.VARCHAR).addNullable("classifier", TypeProtos.MinorType.VARCHAR).addNullable("scope", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "org.apache.drill.exec", "drill-java-exec", "${project.version}", null, null}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "org.apache.drill.exec", "drill-java-exec", "${project.version}", "tests", "test"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "org.apache.drill", "drill-common", "${project.version}", "tests", "test"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testXXE() throws Exception {
        String sql = "SELECT * FROM cp.`xml/bad.xml`";
        try {
            client.queryBuilder().sql(sql).rowSet();
            Assert.fail();
        }
        catch (UserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("DATA_READ ERROR: Error parsing XML file"));
        }
    }

    @Test
    public void testSelfClosingTags() throws Exception {
        String sql = "SELECT * FROM cp.`xml/weather.xml`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)1L, (long)results.rowCount());
        TupleMetadata expectedSchema = new SchemaBuilder().addMap("attributes").addNullable("forecast_information_city_data", TypeProtos.MinorType.VARCHAR).addNullable("forecast_information_postal_code_data", TypeProtos.MinorType.VARCHAR).addNullable("forecast_information_latitude_e6_data", TypeProtos.MinorType.VARCHAR).addNullable("forecast_information_longitude_e6_data", TypeProtos.MinorType.VARCHAR).addNullable("forecast_information_forecast_date_data", TypeProtos.MinorType.VARCHAR).addNullable("forecast_information_current_date_time_data", TypeProtos.MinorType.VARCHAR).addNullable("forecast_information_unit_system_data", TypeProtos.MinorType.VARCHAR).addNullable("current_conditions_condition_data", TypeProtos.MinorType.VARCHAR).addNullable("current_conditions_temp_f_data", TypeProtos.MinorType.VARCHAR).addNullable("current_conditions_temp_c_data", TypeProtos.MinorType.VARCHAR).addNullable("current_conditions_humidity_data", TypeProtos.MinorType.VARCHAR).addNullable("current_conditions_icon_data", TypeProtos.MinorType.VARCHAR).addNullable("current_conditions_wind_condition_data", TypeProtos.MinorType.VARCHAR).resumeSchema().addNullable("city", TypeProtos.MinorType.VARCHAR).addNullable("postal_code", TypeProtos.MinorType.VARCHAR).addNullable("latitude_e6", TypeProtos.MinorType.VARCHAR).addNullable("longitude_e6", TypeProtos.MinorType.VARCHAR).addNullable("forecast_date", TypeProtos.MinorType.VARCHAR).addNullable("current_date_time", TypeProtos.MinorType.VARCHAR).addNullable("unit_system", TypeProtos.MinorType.VARCHAR).addNullable("condition", TypeProtos.MinorType.VARCHAR).addNullable("temp_f", TypeProtos.MinorType.VARCHAR).addNullable("temp_c", TypeProtos.MinorType.VARCHAR).addNullable("humidity", TypeProtos.MinorType.VARCHAR).addNullable("icon", TypeProtos.MinorType.VARCHAR).addNullable("wind_condition", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{"Seattle, WA", "Seattle WA", "", "", "2011-09-29", "2011-09-29 17:53:00 +0000", "US", "Clear", "62", "17", "Humidity: 62%", "/ig/images/weather/sunny.gif", "Wind: N at 4 mph"}), null, null, null, null, null, null, null, null, null, null, null, null, null}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitWithSimpleXMLFile() throws Exception {
        String sql = "SELECT groupID, artifactID, version, classifier, scope FROM cp.`xml/simple.xml`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("groupID", TypeProtos.MinorType.VARCHAR).addNullable("artifactID", TypeProtos.MinorType.VARCHAR).addNullable("version", TypeProtos.MinorType.VARCHAR).addNullable("classifier", TypeProtos.MinorType.VARCHAR).addNullable("scope", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"org.apache.drill.exec", "drill-java-exec", "${project.version}", null, null}).addRow(new Object[]{"org.apache.drill.exec", "drill-java-exec", "${project.version}", "tests", "test"}).addRow(new Object[]{"org.apache.drill", "drill-common", "${project.version}", "tests", "test"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testWildcardWithFilter() throws Exception {
        String sql = "SELECT * FROM cp.`xml/simple.xml` WHERE scope='test'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)2L, (long)results.rowCount());
        TupleMetadata expectedSchema = new SchemaBuilder().add("attributes", TypeProtos.MinorType.MAP).addNullable("groupID", TypeProtos.MinorType.VARCHAR).addNullable("artifactID", TypeProtos.MinorType.VARCHAR).addNullable("version", TypeProtos.MinorType.VARCHAR).addNullable("classifier", TypeProtos.MinorType.VARCHAR).addNullable("scope", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "org.apache.drill.exec", "drill-java-exec", "${project.version}", "tests", "test"}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "org.apache.drill", "drill-common", "${project.version}", "tests", "test"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testWildcardWithSingleNestedDataField() throws Exception {
        String sql = "SELECT * FROM cp.`xml/really-simple-nested.xml`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        TupleMetadata expectedSchema = new SchemaBuilder().add("attributes", TypeProtos.MinorType.MAP, TypeProtos.DataMode.REQUIRED).addMap("field1").addNullable("key1", TypeProtos.MinorType.VARCHAR).addNullable("key2", TypeProtos.MinorType.VARCHAR).resumeSchema().buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.strArray((String[])new String[]{"value1", "value2"})}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.strArray((String[])new String[]{"value3", "value4"})}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.strArray((String[])new String[]{"value5", "value6"})}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitWithSingleNestedDataField() throws Exception {
        String sql = "SELECT t1.field1.key1 as key1, t1.field1.key2 as key2 FROM cp.`xml/really-simple-nested.xml` as t1";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("key1", TypeProtos.MinorType.VARCHAR).addNullable("key2", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"value1", "value2"}).addRow(new Object[]{"value3", "value4"}).addRow(new Object[]{"value5", "value6"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "SELECT COUNT(*) FROM cp.`xml/simple.xml`";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)3L, (long)cnt);
    }

    @Test
    public void testExplicitWithCompressedSimpleXMLFile() throws Exception {
        QueryTestUtil.generateCompressedFile((String)"xml/simple.xml", (String)"zip", (String)"xml/simple.xml.zip");
        String sql = "SELECT groupID, artifactID, version, classifier, scope FROM dfs.`xml/simple.xml.zip`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("groupID", TypeProtos.MinorType.VARCHAR).addNullable("artifactID", TypeProtos.MinorType.VARCHAR).addNullable("version", TypeProtos.MinorType.VARCHAR).addNullable("classifier", TypeProtos.MinorType.VARCHAR).addNullable("scope", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"org.apache.drill.exec", "drill-java-exec", "${project.version}", null, null}).addRow(new Object[]{"org.apache.drill.exec", "drill-java-exec", "${project.version}", "tests", "test"}).addRow(new Object[]{"org.apache.drill", "drill-common", "${project.version}", "tests", "test"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testDeepNestedSpecificFields() throws Exception {
        String sql = "select xml.level2.level3.level4.level5.level6.level7.field1 as field1, xml.level2.level3.level4.level5.level6.level7.field2 as field2, xml.level2.level3.level4.level5.level6.level7.field3 as field3 FROM cp.`xml/deep-nested.xml` as xml";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)2L, (long)results.rowCount());
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).addNullable("field2", TypeProtos.MinorType.VARCHAR).addNullable("field3", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"f1", "f2", "f3"}).addRow(new Object[]{"f4", "f5", "f6"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testDeepNesting() throws Exception {
        String sql = "SELECT * FROM cp.`xml/deep-nested.xml`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)2L, (long)results.rowCount());
        TupleMetadata expectedSchema = new SchemaBuilder().add("attributes", TypeProtos.MinorType.MAP, TypeProtos.DataMode.REQUIRED).addMap("level2").addNullable("field1-level2", TypeProtos.MinorType.VARCHAR).addMap("level3").addNullable("field1-level3", TypeProtos.MinorType.VARCHAR).addMap("level4").addNullable("field1-level4", TypeProtos.MinorType.VARCHAR).addMap("level5").addNullable("field1-level5", TypeProtos.MinorType.VARCHAR).addMap("level6").addNullable("field1-level6", TypeProtos.MinorType.VARCHAR).addMap("level7").addNullable("field1", TypeProtos.MinorType.VARCHAR).addNullable("field2", TypeProtos.MinorType.VARCHAR).addNullable("field3", TypeProtos.MinorType.VARCHAR).resumeMap().resumeMap().resumeMap().resumeMap().resumeMap().resumeSchema().build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.objArray((Object[])RowSetUtilities.objArray((Object[])new Object[]{"l2", RowSetUtilities.objArray((Object[])new Object[]{"l3", RowSetUtilities.objArray((Object[])new Object[]{"l4", RowSetUtilities.objArray((Object[])new Object[]{"l5", RowSetUtilities.objArray((Object[])new Object[]{"l6", RowSetUtilities.strArray((String[])new String[]{"f1", "f2", "f3"})})})})})}))}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.objArray((Object[])RowSetUtilities.objArray((Object[])new Object[]{null, RowSetUtilities.objArray((Object[])new Object[]{null, RowSetUtilities.objArray((Object[])new Object[]{null, RowSetUtilities.objArray((Object[])new Object[]{null, RowSetUtilities.objArray((Object[])new Object[]{null, RowSetUtilities.strArray((String[])new String[]{"f4", "f5", "f6"})})})})})}))}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testDataLevel() throws Exception {
        String sql = "SELECT * FROM table(cp.`xml/deep-nested2.xml` (type => 'xml', dataLevel => 8))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("attributes", TypeProtos.MinorType.MAP, TypeProtos.DataMode.REQUIRED).addNullable("field1", TypeProtos.MinorType.VARCHAR).addNullable("field2", TypeProtos.MinorType.VARCHAR).addNullable("field3", TypeProtos.MinorType.VARCHAR).addNullable("field1-level6", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "f4", "f5", "f6", null}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), "f1", "f2", "f3", "l6"}).build();
        Assert.assertEquals((long)2L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitDataLevel() throws Exception {
        String sql = "SELECT field1, field2, field3 FROM table(cp.`xml/deep-nested2.xml` (type => 'xml', dataLevel => 8))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("field1", TypeProtos.MinorType.VARCHAR).addNullable("field2", TypeProtos.MinorType.VARCHAR).addNullable("field3", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"f4", "f5", "f6"}).addRow(new Object[]{"f1", "f2", "f3"}).build();
        Assert.assertEquals((long)2L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testComplexWildcardStar() throws Exception {
        String sql = "SELECT * FROM cp.`xml/nested.xml`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("attributes", TypeProtos.MinorType.MAP, TypeProtos.DataMode.REQUIRED).addMap("field1").addNullable("key1", TypeProtos.MinorType.VARCHAR).addNullable("key2", TypeProtos.MinorType.VARCHAR).resumeSchema().addMap("field2").addNullable("key3", TypeProtos.MinorType.VARCHAR).addMap("nestedField1").addNullable("nk1", TypeProtos.MinorType.VARCHAR).addNullable("nk2", TypeProtos.MinorType.VARCHAR).addNullable("nk3", TypeProtos.MinorType.VARCHAR).resumeMap().resumeSchema().buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.strArray((String[])new String[]{"value1", "value2"}), RowSetUtilities.objArray((Object[])new Object[]{"k1", RowSetUtilities.strArray((String[])new String[]{"nk_value1", "nk_value2", "nk_value3"})})}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.strArray((String[])new String[]{"value3", "value4"}), RowSetUtilities.objArray((Object[])new Object[]{"k2", RowSetUtilities.strArray((String[])new String[]{"nk_value4", "nk_value5", "nk_value6"})})}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.strArray((String[])new String[]{"value5", "value6"}), RowSetUtilities.objArray((Object[])new Object[]{"k3", RowSetUtilities.strArray((String[])new String[]{"nk_value7", "nk_value8", "nk_value9"})})}).build();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testComplexNestedExplicit() throws Exception {
        String sql = "SELECT xml.field2.nestedField1.nk1 as nk1, xml.field2.nestedField1.nk2 as nk2, xml.field2.nestedField1.nk3 as nk3 FROM cp.`xml/nested.xml` AS xml";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("nk1", TypeProtos.MinorType.VARCHAR).addNullable("nk2", TypeProtos.MinorType.VARCHAR).addNullable("nk3", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"nk_value1", "nk_value2", "nk_value3"}).addRow(new Object[]{"nk_value4", "nk_value5", "nk_value6"}).addRow(new Object[]{"nk_value7", "nk_value8", "nk_value9"}).build();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testAttributes() throws Exception {
        String sql = "SELECT attributes FROM cp.`xml/attributes.xml`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addMap("attributes").addNullable("title_binding", TypeProtos.MinorType.VARCHAR).addNullable("title_subcategory", TypeProtos.MinorType.VARCHAR).resumeSchema().build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[][]{null, null})}).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{"paperback", null})}).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{"hardcover", "non-fiction"})}).build();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testNestedAttributes() throws Exception {
        String sql = "SELECT * FROM cp.`xml/nested-with-attributes.xml`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addMap("attributes").addNullable("field1_f1", TypeProtos.MinorType.VARCHAR).addNullable("field2_f2", TypeProtos.MinorType.VARCHAR).addNullable("field2_key3_f3", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_f4", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_f5", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_nk1_f6", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_nk1_f7", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_nk3_f8", TypeProtos.MinorType.VARCHAR).resumeSchema().addMap("field1").addNullable("key1", TypeProtos.MinorType.VARCHAR).addNullable("key2", TypeProtos.MinorType.VARCHAR).resumeSchema().addMap("field2").addNullable("key3", TypeProtos.MinorType.VARCHAR).addMap("nestedField1").addNullable("nk1", TypeProtos.MinorType.VARCHAR).addNullable("nk2", TypeProtos.MinorType.VARCHAR).addNullable("nk3", TypeProtos.MinorType.VARCHAR).resumeMap().resumeSchema().buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{"k1", "k2", "k3", "k4", "k5", "k6", "k7", null}), RowSetUtilities.strArray((String[])new String[]{"value1", "value2"}), RowSetUtilities.objArray((Object[])new Object[]{"k1", RowSetUtilities.strArray((String[])new String[]{"nk_value1", "nk_value2", "nk_value3"})})}).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{null, null, null, null, null, null, null, null}), RowSetUtilities.strArray((String[])new String[]{"value3", "value4"}), RowSetUtilities.objArray((Object[])new Object[]{"k2", RowSetUtilities.strArray((String[])new String[]{"nk_value4", "nk_value5", "nk_value6"})})}).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{null, null, null, null, null, null, null, "k8"}), RowSetUtilities.strArray((String[])new String[]{"value5", "value6"}), RowSetUtilities.objArray((Object[])new Object[]{"k3", RowSetUtilities.strArray((String[])new String[]{"nk_value7", "nk_value8", "nk_value9"})})}).build();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitNestedAttributes() throws Exception {
        String sql = "SELECT data.attributes.field1_f1 AS field1_f1,data.attributes.field2_f2 AS field2_f2, data.attributes.field2_key3_f3 AS field2_key3_f3,data.attributes.field2_nestedField1_f4 AS field2_nestedField1_f4,data.attributes.field2_nestedField1_f5 AS field2_nestedField1_f5, data.attributes.field2_nestedField1_nk1_f6 AS field2_nestedField1_nk1_f6, data.attributes.field2_nestedField1_nk1_f7 AS field2_nestedField1_nk1_f7,data.attributes.field2_nestedField1_nk3_f8 AS field2_nestedField1_nk3_f8 FROM cp.`xml/nested-with-attributes.xml` AS data";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("field1_f1", TypeProtos.MinorType.VARCHAR).addNullable("field2_f2", TypeProtos.MinorType.VARCHAR).addNullable("field2_key3_f3", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_f4", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_f5", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_nk1_f6", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_nk1_f7", TypeProtos.MinorType.VARCHAR).addNullable("field2_nestedField1_nk3_f8", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"k1", "k2", "k3", "k4", "k5", "k6", "k7", null}).addRow(new Object[]{null, null, null, null, null, null, null, null}).addRow(new Object[]{null, null, null, null, null, null, null, "k8"}).build();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testLimitPushdown() throws Exception {
        String sql = "SELECT * FROM cp.`xml/simple.xml` LIMIT 2";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "limit=2"}).match();
    }

    @Test
    public void testMapError() throws Exception {
        String sql = "SELECT * FROM cp.`xml/schemaChange.xml`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addMap("attributes").resumeSchema().addMap("parent").addNullable("link", TypeProtos.MinorType.VARCHAR).addNullable("value", TypeProtos.MinorType.VARCHAR).resumeSchema().build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.mapArray((Object[][])new Object[][]{null, null})}).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.strArray((String[])new String[]{"https://dev57595.service-now.com/api/now/table/task/46eaa7c9a9fe198100bbe282da0d4b7d", "46eaa7c9a9fe198100bbe282da0d4b7d"})}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }
}

