/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.spss;

import java.nio.file.Paths;
import org.apache.drill.categories.RowSetTests;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.QueryTestUtil;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTests.class})
public class TestSpssReader
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("spss/", new String[0]));
    }

    @Test
    public void testStarQuery() throws Exception {
        String sql = "SELECT * FROM dfs.`spss/testdata.sav` WHERE d16=4";
        QueryBuilder q = client.queryBuilder().sql(sql);
        DirectRowSet results = q.rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ID", TypeProtos.MinorType.FLOAT8).addNullable("Urban", TypeProtos.MinorType.FLOAT8).addNullable("Urban_value", TypeProtos.MinorType.VARCHAR).addNullable("District", TypeProtos.MinorType.FLOAT8).addNullable("District_value", TypeProtos.MinorType.VARCHAR).addNullable("Province", TypeProtos.MinorType.FLOAT8).addNullable("Province_value", TypeProtos.MinorType.VARCHAR).addNullable("Interviewer", TypeProtos.MinorType.FLOAT8).addNullable("Date", TypeProtos.MinorType.FLOAT8).addNullable("d6_1", TypeProtos.MinorType.FLOAT8).addNullable("d6_1_Value", TypeProtos.MinorType.VARCHAR).addNullable("d6_2", TypeProtos.MinorType.FLOAT8).addNullable("d6_2_Value", TypeProtos.MinorType.VARCHAR).addNullable("d6_3", TypeProtos.MinorType.FLOAT8).addNullable("d6_3_Value", TypeProtos.MinorType.VARCHAR).addNullable("d6_4", TypeProtos.MinorType.FLOAT8).addNullable("d6_4_Value", TypeProtos.MinorType.VARCHAR).addNullable("s_1", TypeProtos.MinorType.VARCHAR).addNullable("d6_5", TypeProtos.MinorType.FLOAT8).addNullable("d6_5_Value", TypeProtos.MinorType.VARCHAR).addNullable("d6_6", TypeProtos.MinorType.FLOAT8).addNullable("d6_6_Value", TypeProtos.MinorType.VARCHAR).addNullable("d6_7", TypeProtos.MinorType.FLOAT8).addNullable("d6_7_Value", TypeProtos.MinorType.VARCHAR).addNullable("q1", TypeProtos.MinorType.FLOAT8).addNullable("q1_Value", TypeProtos.MinorType.VARCHAR).addNullable("q2", TypeProtos.MinorType.FLOAT8).addNullable("q2_Value", TypeProtos.MinorType.VARCHAR).addNullable("d7a", TypeProtos.MinorType.FLOAT8).addNullable("d7a_Value", TypeProtos.MinorType.VARCHAR).addNullable("d7b", TypeProtos.MinorType.FLOAT8).addNullable("d7b_Value", TypeProtos.MinorType.VARCHAR).addNullable("d16", TypeProtos.MinorType.FLOAT8).addNullable("Stratum", TypeProtos.MinorType.FLOAT8).addNullable("S1_IP", TypeProtos.MinorType.FLOAT8).addNullable("S2_IP", TypeProtos.MinorType.FLOAT8).addNullable("Sample_Weight", TypeProtos.MinorType.FLOAT8).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{47.0, 1.0, "Urban", 101.0, "Kabul", 1.0, "Kabul", 151.0, 1.34557632E10, 1.0, "Yes", 2.0, "No", 2.0, "No", 2.0, "No", "", 2.0, "No", 2.0, "No", 2.0, "No", 1.0, "Good", 2.0, "The same", 5.0, "Housewife (not working outside of the home)", 97.0, "Not Asked", 4.0, 121.0, 0.007463305415042708, 0.006666666666666667, 20098.33333333333}).addRow(new Object[]{53.0, 1.0, "Urban", 101.0, "Kabul", 1.0, "Kabul", 151.0, 1.34557632E10, 1.0, "Yes", 2.0, "No", 2.0, "No", 2.0, "No", "", 2.0, "No", 2.0, "No", 2.0, "No", 1.0, "Good", 2.0, "The same", 5.0, "Housewife (not working outside of the home)", 97.0, "Not Asked", 4.0, 121.0, 0.007463305415042708, 0.006666666666666667, 20098.33333333333}).addRow(new Object[]{66.0, 1.0, "Urban", 101.0, "Kabul", 1.0, "Kabul", 774.0, 1.34556768E10, 2.0, "No", 1.0, "Yes", 1.0, "Yes", 2.0, "No", "", 2.0, "No", 2.0, "No", 2.0, "No", 1.0, "Good", 1.0, "Better", 1.0, "Working full time", 13.0, "Private Business Sole Proprietor", 4.0, 111.0, 0.017389288198469743, 0.006666666666666667, 8626.0}).build();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitQuery() throws Exception {
        String sql = "SELECT ID, Urban, Urban_value FROM dfs.`spss/testdata.sav` WHERE d16=4";
        QueryBuilder q = client.queryBuilder().sql(sql);
        DirectRowSet results = q.rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ID", TypeProtos.MinorType.FLOAT8).addNullable("Urban", TypeProtos.MinorType.FLOAT8).addNullable("Urban_value", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{47.0, 1.0, "Urban"}).addRow(new Object[]{53.0, 1.0, "Urban"}).addRow(new Object[]{66.0, 1.0, "Urban"}).build();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "SELECT COUNT(*) FROM dfs.`spss/testdata.sav`";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)25L, (long)cnt);
    }

    @Test
    public void testExplicitQueryWithCompressedFile() throws Exception {
        QueryTestUtil.generateCompressedFile((String)"spss/testdata.sav", (String)"zip", (String)"spss/testdata.sav.zip");
        String sql = "SELECT ID, Urban, Urban_value FROM dfs.`spss/testdata.sav.zip`  WHERE d16=4";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ID", TypeProtos.MinorType.FLOAT8).addNullable("Urban", TypeProtos.MinorType.FLOAT8).addNullable("Urban_value", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{47.0, 1.0, "Urban"}).addRow(new Object[]{53.0, 1.0, "Urban"}).addRow(new Object[]{66.0, 1.0, "Urban"}).build();
        Assert.assertEquals((long)3L, (long)results.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }
}

