/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sas;

import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalTime;
import org.apache.drill.categories.RowSetTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryTestUtil;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTest.class})
public class TestSasReader
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("sas/", new String[0]));
    }

    @Test
    public void testStarQuery() throws Exception {
        String sql = "SELECT * FROM cp.`sas/mixed_data_two.sas7bdat` WHERE x1 = 1";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("x1", TypeProtos.MinorType.FLOAT8).addNullable("x2", TypeProtos.MinorType.FLOAT8).addNullable("x3", TypeProtos.MinorType.VARCHAR).addNullable("x4", TypeProtos.MinorType.FLOAT8).addNullable("x5", TypeProtos.MinorType.FLOAT8).addNullable("x6", TypeProtos.MinorType.FLOAT8).addNullable("x7", TypeProtos.MinorType.FLOAT8).addNullable("x8", TypeProtos.MinorType.FLOAT8).addNullable("x9", TypeProtos.MinorType.FLOAT8).addNullable("x10", TypeProtos.MinorType.FLOAT8).addNullable("x11", TypeProtos.MinorType.FLOAT8).addNullable("x12", TypeProtos.MinorType.FLOAT8).addNullable("x13", TypeProtos.MinorType.FLOAT8).addNullable("x14", TypeProtos.MinorType.FLOAT8).addNullable("x15", TypeProtos.MinorType.FLOAT8).addNullable("x16", TypeProtos.MinorType.FLOAT8).addNullable("x17", TypeProtos.MinorType.FLOAT8).addNullable("x18", TypeProtos.MinorType.FLOAT8).addNullable("x19", TypeProtos.MinorType.FLOAT8).addNullable("x20", TypeProtos.MinorType.FLOAT8).addNullable("x21", TypeProtos.MinorType.FLOAT8).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 1.1, "AAAAAAAA", 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 31626061L, 31625961L, 31627061L, 31616061L, 31636061L, 31526061L, 31726061L}).addRow(new Object[]{1L, 1.1, "AAAAAAAA", 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 1.1, 31626061L, 31625961L, 31627061L, 31616061L, 31636061L, 31526061L, 31726061L}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testMetadataColumns() throws Exception {
        String sql = "SELECT _compression_method, _file_label, _file_type, _os_name, _os_type, _sas_release, _session_encoding, _server_type, _date_created, _date_modified FROM cp.`sas/date_formats.sas7bdat`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("_compression_method", TypeProtos.MinorType.VARCHAR).addNullable("_file_label", TypeProtos.MinorType.VARCHAR).addNullable("_file_type", TypeProtos.MinorType.VARCHAR).addNullable("_os_name", TypeProtos.MinorType.VARCHAR).addNullable("_os_type", TypeProtos.MinorType.VARCHAR).addNullable("_sas_release", TypeProtos.MinorType.VARCHAR).addNullable("_session_encoding", TypeProtos.MinorType.VARCHAR).addNullable("_server_type", TypeProtos.MinorType.VARCHAR).addNullable("_date_created", TypeProtos.MinorType.DATE).addNullable("_date_modified", TypeProtos.MinorType.DATE).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{null, "DATA", null, null, "9.0401M4", null, "X64_7PRO", null, LocalDate.parse("2017-03-14"), LocalDate.parse("2017-03-14")}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testCompressedFile() throws Exception {
        QueryTestUtil.generateCompressedFile((String)"sas/mixed_data_two.sas7bdat", (String)"zip", (String)"sas/mixed_data_two.sas7bdat.zip");
        String sql = "SELECT x1, x2, x3 FROM dfs.`sas/mixed_data_two.sas7bdat.zip` WHERE x1 = 1";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("x1", TypeProtos.MinorType.FLOAT8).addNullable("x2", TypeProtos.MinorType.FLOAT8).addNullable("x3", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1L, 1.1, "AAAAAAAA"}).addRow(new Object[]{1L, 1.1, "AAAAAAAA"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testDates() throws Exception {
        String sql = "SELECT b8601da, e8601da, `date` FROM cp.`sas/date_formats.sas7bdat`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("b8601da", TypeProtos.MinorType.DATE).addNullable("e8601da", TypeProtos.MinorType.DATE).addNullable("date", TypeProtos.MinorType.DATE).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{LocalDate.parse("2017-03-14"), LocalDate.parse("2017-03-14"), LocalDate.parse("2017-03-14")}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testTimes() throws Exception {
        String sql = "SELECT * FROM cp.`sas/time_formats.sas7bdat`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("E8601LZ", TypeProtos.MinorType.TIME).addNullable("E8601TM", TypeProtos.MinorType.TIME).addNullable("HHMM", TypeProtos.MinorType.TIME).addNullable("HOUR", TypeProtos.MinorType.TIME).addNullable("MMSS", TypeProtos.MinorType.TIME).addNullable("TIME", TypeProtos.MinorType.TIME).addNullable("TIMEAMPM", TypeProtos.MinorType.TIME).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{LocalTime.parse("10:10:10"), LocalTime.parse("10:10:10"), LocalTime.parse("10:10:10"), LocalTime.parse("10:10:10"), LocalTime.parse("10:10:10"), LocalTime.parse("10:10:10"), LocalTime.parse("10:10:10")}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "SELECT COUNT(*) as cnt FROM cp.`sas/mixed_data_two.sas7bdat` ";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)50L, (long)cnt);
    }

    @Test
    public void testLimitPushdown() throws Exception {
        String sql = "SELECT * FROM cp.`sas/mixed_data_one.sas7bdat` LIMIT 5";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "limit=5"}).match();
    }
}

