/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pdf;

import java.io.File;
import java.util.List;
import org.apache.drill.exec.store.pdf.PdfUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.junit.Assert;
import org.junit.Test;
import technology.tabula.Table;

public class TestPdfUtils {
    private static final String DATA_PATH = "src/test/resources/pdf/";

    @Test
    public void testTableExtractor() throws Exception {
        PDDocument document = this.getDocument("argentina_diputados_voting_record.pdf");
        List tableList = PdfUtils.extractTablesFromPDF((PDDocument)document);
        document.close();
        Assert.assertEquals((long)tableList.size(), (long)1L);
        PDDocument document2 = this.getDocument("twotables.pdf");
        List tableList2 = PdfUtils.extractTablesFromPDF((PDDocument)document2);
        document2.close();
        Assert.assertEquals((long)tableList2.size(), (long)2L);
    }

    @Test
    public void testTableExtractorWithNoBoundingFrame() throws Exception {
        PDDocument document = this.getDocument("spreadsheet_no_bounding_frame.pdf");
        List tableList = PdfUtils.extractTablesFromPDF((PDDocument)document);
        document.close();
        Assert.assertEquals((long)tableList.size(), (long)1L);
    }

    @Test
    public void testTableExtractorWitMultipage() throws Exception {
        PDDocument document = this.getDocument("us-020.pdf");
        List tableList = PdfUtils.extractTablesFromPDF((PDDocument)document);
        document.close();
        Assert.assertEquals((long)tableList.size(), (long)4L);
    }

    @Test
    public void testGetSpecificTable() throws Exception {
        PDDocument document = this.getDocument("us-020.pdf");
        Table table = PdfUtils.getSpecificTable((PDDocument)document, (int)0, null);
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((long)7L, (long)table.getColCount());
    }

    @Test
    public void testGetFullPageSpecificTable() throws Exception {
        PDDocument document = this.getDocument("schools.pdf");
        Table table = PdfUtils.getSpecificTable((PDDocument)document, (int)3, null);
        Assert.assertNotNull((Object)table);
    }

    @Test
    public void testGetSpecificTableOutSideOfBounds() throws Exception {
        PDDocument document = this.getDocument("us-020.pdf");
        Table table = PdfUtils.getSpecificTable((PDDocument)document, (int)4, null);
        Assert.assertNull((Object)table);
    }

    @Test
    public void testFirstRowExtractor() throws Exception {
        PDDocument document = this.getDocument("schools.pdf");
        List tableList = PdfUtils.extractTablesFromPDF((PDDocument)document);
        document.close();
        List values = PdfUtils.extractFirstRowValues((Table)((Table)tableList.get(0)));
        Assert.assertEquals((long)values.size(), (long)11L);
    }

    private PDDocument getDocument(String fileName) throws Exception {
        return PDDocument.load((File)new File(DATA_PATH + fileName));
    }
}

