/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pcap;

import java.nio.file.Paths;
import java.util.List;
import org.apache.drill.PlanTestBase;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.store.pcap.decoder.Packet;
import org.apache.drill.test.BaseTestQuery;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestPcapRecordReader
extends BaseTestQuery {
    @BeforeClass
    public static void setupTestFiles() {
        dirTestWatcher.copyResourceToRoot(Paths.get("pcap", new String[0]));
    }

    @Test
    public void testStarQuery() throws Exception {
        this.runSQLVerifyCount("select * from dfs.`pcap/tcp-1.pcap`", 16);
        this.runSQLVerifyCount("select distinct DST_IP from dfs.`pcap/tcp-1.pcap`", 1);
        this.runSQLVerifyCount("select distinct DsT_IP from dfs.`pcap/tcp-1.pcap`", 1);
        this.runSQLVerifyCount("select distinct dst_ip from dfs.`pcap/tcp-1.pcap`", 1);
    }

    @Test
    public void testCorruptPCAPQuery() throws Exception {
        this.runSQLVerifyCount("select * from dfs.`pcap/testv1.pcap`", 7000);
    }

    @Test
    public void testTrueCorruptPCAPQuery() throws Exception {
        this.runSQLVerifyCount("select * from dfs.`pcap/testv1.pcap` WHERE is_corrupt=true", 16);
    }

    @Test
    public void testNotCorruptPCAPQuery() throws Exception {
        this.runSQLVerifyCount("select * from dfs.`pcap/testv1.pcap` WHERE is_corrupt=false", 6984);
    }

    @Test
    public void testCountQuery() throws Exception {
        this.runSQLVerifyCount("select count(*) from dfs.`pcap/tcp-1.pcap`", 1);
        this.runSQLVerifyCount("select count(*) from dfs.`pcap/tcp-2.pcap`", 1);
    }

    @Test
    public void testDistinctQuery() throws Exception {
        this.runSQLVerifyCount("select distinct type, network, `timestamp`, src_ip, dst_ip, src_port, dst_port, src_mac_address, dst_mac_address, tcp_session, packet_length from dfs.`pcap/tcp-1.pcap`", 1);
    }

    @Test
    public void testFlagFormatting() {
        Assert.assertEquals((Object)"NS", (Object)Packet.formatFlags((int)256));
        Assert.assertEquals((Object)"CWR", (Object)Packet.formatFlags((int)128));
        Assert.assertEquals((Object)"ECE", (Object)Packet.formatFlags((int)64).substring(0, 3));
        Assert.assertEquals((Object)"ECE", (Object)Packet.formatFlags((int)66).substring(0, 3));
        Assert.assertEquals((Object)"URG", (Object)Packet.formatFlags((int)32));
        Assert.assertEquals((Object)"ACK", (Object)Packet.formatFlags((int)16));
        Assert.assertEquals((Object)"PSH", (Object)Packet.formatFlags((int)8));
        Assert.assertEquals((Object)"RST", (Object)Packet.formatFlags((int)4));
        Assert.assertEquals((Object)"SYN", (Object)Packet.formatFlags((int)2));
        Assert.assertEquals((Object)"FIN", (Object)Packet.formatFlags((int)1));
        Assert.assertEquals((Object)"RST|SYN|FIN", (Object)Packet.formatFlags((int)7));
    }

    @Test
    public void checkFlags() throws Exception {
        this.runSQLVerifyCount("select tcp_session, tcp_ack, tcp_flags from dfs.`pcap/synscan.pcap`", 2011);
    }

    @Test
    public void testSerDe() throws Exception {
        String path = "pcap/tcp-1.pcap";
        dirTestWatcher.copyResourceToRoot(Paths.get(path, new String[0]));
        this.testPhysicalPlanSubmission(String.format("select * from dfs.`%s`", path), String.format("select * from table(dfs.`%s`(type=>'pcap'))", path));
    }

    private void runSQLVerifyCount(String sql, int expectedRowCount) throws Exception {
        List<QueryDataBatch> results = this.runSQLWithResults(sql);
        this.verifyRowCount(results, expectedRowCount);
    }

    private List<QueryDataBatch> runSQLWithResults(String sql) throws Exception {
        return TestPcapRecordReader.testSqlWithResults((String)sql);
    }

    private void verifyRowCount(List<QueryDataBatch> results, int expectedRowCount) {
        int count = 0;
        for (QueryDataBatch result : results) {
            count += result.getHeader().getRowCount();
            result.release();
        }
        Assert.assertEquals((long)expectedRowCount, (long)count);
    }

    private void testPhysicalPlanSubmission(String ... queries) throws Exception {
        for (String query : queries) {
            PlanTestBase.testPhysicalPlanExecutionBasedOnQuery((String)query);
        }
    }
}

