/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pcapng;

import com.google.common.collect.ImmutableList;
import java.nio.file.Paths;
import java.util.List;
import org.apache.drill.categories.RowSetTest;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.pcap.plugin.PcapFormatConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTest.class})
public class TestPcapngStatRecordReader
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        cluster.defineFormat("dfs", "pcapng", (FormatPluginConfig)new PcapFormatConfig((List)ImmutableList.of((Object)"pcapng"), true, Boolean.valueOf(false)));
        dirTestWatcher.copyResourceToRoot(Paths.get("pcapng/", new String[0]));
    }

    @Test
    public void testStarQuery() throws Exception {
        String sql = "select * from dfs.`pcapng/example.pcapng`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)3L, (long)sets.rowCount());
        sets.clear();
    }

    @Test
    public void testExplicitQuery() throws Exception {
        String sql = "select path, shb_hardware, shb_os, if_name, isb_ifrecv from dfs.`pcapng/sniff.pcapng`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("path", TypeProtos.MinorType.VARCHAR).addNullable("shb_hardware", TypeProtos.MinorType.VARCHAR).addNullable("shb_os", TypeProtos.MinorType.VARCHAR).addNullable("if_name", TypeProtos.MinorType.VARCHAR).addNullable("isb_ifrecv", TypeProtos.MinorType.BIGINT).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"sniff.pcapng", "Intel(R) Core(TM) i7-6700HQ CPU @ 2.60GHz (with SSE4.2)", "Mac OS X 10.13.3, build 17D47 (Darwin 17.4.0)", null, null}).addRow(new Object[]{"sniff.pcapng", null, null, "en0", null}).addRow(new Object[]{"sniff.pcapng", null, null, null, 123}).build();
        Assert.assertEquals((long)3L, (long)sets.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testLimitPushdown() throws Exception {
        String sql = "select * from dfs.`pcapng/example.pcapng` limit 2";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)2L, (long)sets.rowCount());
        sets.clear();
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "select count(*) from dfs.`pcapng/*.pcapng`";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)6L, (long)cnt);
    }

    @Test
    public void testValidHeaders() throws Exception {
        String sql = "select * from dfs.`pcapng/sniff.pcapng`";
        DirectRowSet sets = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("path", TypeProtos.MinorType.VARCHAR).addNullable("shb_hardware", TypeProtos.MinorType.VARCHAR).addNullable("shb_os", TypeProtos.MinorType.VARCHAR).addNullable("shb_userappl", TypeProtos.MinorType.VARCHAR).addNullable("if_name", TypeProtos.MinorType.VARCHAR).addNullable("if_description", TypeProtos.MinorType.VARCHAR).addNullable("if_ipv4addr", TypeProtos.MinorType.VARCHAR).addNullable("if_ipv6addr", TypeProtos.MinorType.VARCHAR).addNullable("if_macaddr", TypeProtos.MinorType.VARCHAR).addNullable("if_euiaddr", TypeProtos.MinorType.VARCHAR).addNullable("if_speed", TypeProtos.MinorType.INT).addNullable("if_tsresol", TypeProtos.MinorType.INT).addNullable("if_tzone", TypeProtos.MinorType.INT).addNullable("if_os", TypeProtos.MinorType.VARCHAR).addNullable("if_fcslen", TypeProtos.MinorType.INT).addNullable("if_tsoffset", TypeProtos.MinorType.INT).addNullable("ns_dnsname", TypeProtos.MinorType.VARCHAR).addNullable("ns_dnsip4addr", TypeProtos.MinorType.VARCHAR).addNullable("ns_dnsip6addr", TypeProtos.MinorType.VARCHAR).addNullable("isb_starttime", TypeProtos.MinorType.TIMESTAMP).addNullable("isb_endtime", TypeProtos.MinorType.TIMESTAMP).addNullable("isb_ifrecv", TypeProtos.MinorType.BIGINT).addNullable("isb_ifdrop", TypeProtos.MinorType.BIGINT).addNullable("isb_filteraccept", TypeProtos.MinorType.BIGINT).addNullable("isb_osdrop", TypeProtos.MinorType.BIGINT).addNullable("isb_usrdeliv", TypeProtos.MinorType.BIGINT).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }
}

