/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pcap;

import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ConcatPcap {
    public static void main(String[] args) throws IOException {
        try (DataOutputStream out = new DataOutputStream(System.out);){
            if (args.length > 0) {
                boolean first = true;
                for (String arg : args) {
                    try (FileInputStream in = new FileInputStream(arg);){
                        ConcatPcap.copy(first, in, out);
                        first = false;
                    }
                }
            } else {
                ConcatPcap.copy(true, System.in, out);
            }
        }
    }

    public static void copy(boolean first, InputStream in, DataOutputStream out) throws IOException {
        byte[] buffer = new byte[0x100000];
        if (!first) {
            int n = (int)in.skip(24L);
        }
        int n = in.read(buffer);
        while (n > 0) {
            out.write(buffer, 0, n);
            n = in.read(buffer);
        }
    }
}

