/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pcap;

import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.drill.exec.store.pcap.ConcatPcap;
import org.apache.drill.exec.store.pcap.decoder.Packet;
import org.apache.drill.exec.store.pcap.decoder.PacketDecoder;
import org.apache.drill.test.BaseTestQuery;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPcapDecoder
extends BaseTestQuery {
    private static final Logger logger = LoggerFactory.getLogger(TestPcapDecoder.class);
    private static File bigFile;

    @Test
    public void testByteOrdering() throws IOException {
        File f = File.createTempFile("foo", "pcap");
        f.deleteOnExit();
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(f));){
            TestPcapDecoder.writeHeader(out);
        }
        try (FileInputStream in = new FileInputStream(f);){
            PacketDecoder pd = new PacketDecoder((InputStream)in);
            Assert.assertTrue((boolean)pd.isBigEndian());
        }
    }

    @Test
    public void testBasics() throws IOException {
        InputStream in = Resources.getResource((String)"pcap/tcp-2.pcap").openStream();
        PacketDecoder pd = new PacketDecoder(in);
        Packet p = pd.packet();
        int offset = 0;
        byte[] buffer = new byte[500000 + pd.getMaxLength()];
        int validBytes = in.read(buffer);
        Assert.assertTrue((validBytes > 50 ? 1 : 0) != 0);
        offset = pd.decodePacket(buffer, offset, p, pd.getMaxLength(), validBytes);
        offset = pd.decodePacket(buffer, offset, p, pd.getMaxLength(), validBytes);
        Assert.assertEquals((long)228L, (long)offset);
        Assert.assertEquals((Object)"FE:00:00:00:00:02", (Object)p.getEthernetDestination());
        Assert.assertEquals((Object)"FE:00:00:00:00:01", (Object)p.getEthernetSource());
        Assert.assertEquals((Object)"/192.168.0.1", (Object)p.getSrc_ip().toString());
        Assert.assertEquals((Object)"/192.168.0.2", (Object)p.getDst_ip().toString());
        Assert.assertEquals((long)161L, (long)p.getSrc_port());
        Assert.assertEquals((long)0L, (long)p.getDst_port());
        Assert.assertEquals((long)0L, (long)p.getTimestampMicro());
    }

    private static void writeHeader(DataOutputStream out) throws IOException {
        out.writeInt(-1582119980);
        out.writeShort(2);
        out.writeShort(4);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(65536);
        out.writeInt(1);
    }

    private static void checkConventionalApproach() throws IOException {
        TestPcapDecoder.speedRun(new FileInputStream(bigFile), " without buffering");
    }

    private static void checkBufferedApproach() throws IOException {
        TestPcapDecoder.speedRun(new BufferedInputStream(new FileInputStream(bigFile), 100000), " with buffering");
    }

    private static void speedRun(InputStream in, String msg) throws IOException {
        PacketDecoder pd = new PacketDecoder(in);
        Packet p = pd.nextPacket();
        long total = 0L;
        int tcpCount = 0;
        int udpCount = 0;
        int allCount = 0;
        long t0 = System.nanoTime();
        while (p != null) {
            total += (long)p.getPacketLength();
            ++allCount;
            if (p.isTcpPacket()) {
                ++tcpCount;
            } else if (p.isUdpPacket()) {
                ++udpCount;
            }
            p = pd.nextPacket();
        }
        long t1 = System.nanoTime();
        logger.info("Speed test for per packet object {}", (Object)msg);
        logger.info(String.format("    Read %.1f MB in %.2f s for %.1f MB/s\n", (double)total / 1000000.0, (double)(t1 - t0) / 1.0E9, (double)total * 1000.0 / (double)(t1 - t0)));
        logger.info(String.format("    %d packets, %d TCP packets, %d UDP\n", allCount, tcpCount, udpCount));
        logger.info("\n\n\n");
    }

    private static void checkFastApproach() throws IOException {
        FileInputStream in = new FileInputStream(bigFile);
        PacketDecoder pd = new PacketDecoder((InputStream)in);
        Packet p = pd.packet();
        byte[] buffer = new byte[500000 + pd.getMaxLength()];
        int validBytes = ((InputStream)in).read(buffer);
        int offset = 0;
        long total = 0L;
        int tcpCount = 0;
        int udpCount = 0;
        int allCount = 0;
        long t0 = System.nanoTime();
        while (offset < validBytes) {
            if (validBytes - offset < pd.getMaxLength()) {
                System.arraycopy(buffer, 0, buffer, offset, validBytes - offset);
                validBytes -= offset;
                offset = 0;
                int n = ((InputStream)in).read(buffer, validBytes, buffer.length - validBytes);
                if (n > 0) {
                    validBytes += n;
                }
            }
            offset = pd.decodePacket(buffer, offset, p, pd.getMaxLength(), validBytes);
            total += (long)p.getPacketLength();
            ++allCount;
            if (p.isTcpPacket()) {
                ++tcpCount;
                continue;
            }
            if (!p.isUdpPacket()) continue;
            ++udpCount;
        }
        long t1 = System.nanoTime();
        logger.info("Speed test for in-place packet decoding");
        logger.info(String.format("    Read %.1f MB in %.2f s for %.1f MB/s\n", (double)total / 1000000.0, (double)(t1 - t0) / 1.0E9, (double)total * 1000.0 / (double)(t1 - t0)));
        logger.info(String.format("    %d packets, %d TCP packets, %d UDP\n", allCount, tcpCount, udpCount));
        logger.info("\n\n\n");
    }

    private static void buildBigTcpFile() throws IOException {
        bigFile = File.createTempFile("tcp", ".pcap");
        bigFile.deleteOnExit();
        boolean first = true;
        logger.info("Building large test file");
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(bigFile));){
            int i = 0;
            while ((double)i < 34266.350877192985) {
                try (InputStream in = Resources.getResource((String)"pcap/tcp-2.pcap").openStream();){
                    ConcatPcap.copy(first, in, out);
                }
                first = false;
                ++i;
            }
        }
    }

    public static void main(String[] args) throws IOException {
        logger.info("Checking speeds for various approaches");
        TestPcapDecoder.buildBigTcpFile();
        TestPcapDecoder.checkConventionalApproach();
        TestPcapDecoder.checkBufferedApproach();
        TestPcapDecoder.checkFastApproach();
    }
}

