/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.pcapng;

import java.nio.file.Paths;
import java.time.Instant;
import org.apache.drill.categories.RowSetTests;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.QueryTestUtil;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTests.class})
public class TestPcapngRecordReader
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("pcapng/", new String[0]));
        dirTestWatcher.copyResourceToRoot(Paths.get("todo/", new String[0]));
    }

    @Test
    public void testStarQuery() throws Exception {
        String sql = "select * from dfs.`pcapng/sniff.pcapng`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)123L, (long)sets.rowCount());
        sets.clear();
    }

    @Test
    public void testExplicitQuery() throws Exception {
        String sql = "select type, packet_length, `timestamp` from dfs.`pcapng/sniff.pcapng` where type = 'ARP'";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("type", TypeProtos.MinorType.VARCHAR).add("packet_length", TypeProtos.MinorType.INT).add("timestamp", TypeProtos.MinorType.TIMESTAMP).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"ARP", 90, Instant.ofEpochMilli(1518010669927L)}).addRow(new Object[]{"ARP", 90, Instant.ofEpochMilli(1518010671874L)}).build();
        Assert.assertEquals((long)2L, (long)sets.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testLimitPushdown() throws Exception {
        String sql = "select * from dfs.`pcapng/sniff.pcapng` where type = 'UDP' limit 10 offset 65";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)6L, (long)sets.rowCount());
        sets.clear();
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "select count(*) from dfs.`pcapng/example.pcapng`";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)1L, (long)cnt);
    }

    @Test
    public void testExplicitQueryWithCompressedFile() throws Exception {
        QueryTestUtil.generateCompressedFile((String)"pcapng/sniff.pcapng", (String)"zip", (String)"pcapng/sniff.pcapng.zip");
        String sql = "select type, packet_length, `timestamp` from dfs.`pcapng/sniff.pcapng.zip` where type = 'ARP'";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("type", TypeProtos.MinorType.VARCHAR).add("packet_length", TypeProtos.MinorType.INT).add("timestamp", TypeProtos.MinorType.TIMESTAMP).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"ARP", 90, Instant.ofEpochMilli(1518010669927L)}).addRow(new Object[]{"ARP", 90, Instant.ofEpochMilli(1518010671874L)}).build();
        Assert.assertEquals((long)2L, (long)sets.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testCaseInsensitiveQuery() throws Exception {
        String sql = "select `timestamp`, paCket_dAta, TyPe from dfs.`pcapng/sniff.pcapng`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)123L, (long)sets.rowCount());
        sets.clear();
    }

    @Test
    public void testWhereSyntaxQuery() throws Exception {
        String sql = "select type, src_ip, dst_ip, packet_length from dfs.`pcapng/sniff.pcapng` where src_ip= '10.2.15.239'";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("type", TypeProtos.MinorType.VARCHAR).addNullable("src_ip", TypeProtos.MinorType.VARCHAR).addNullable("dst_ip", TypeProtos.MinorType.VARCHAR).add("packet_length", TypeProtos.MinorType.INT).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"UDP", "10.2.15.239", "239.255.255.250", 214}).addRow(new Object[]{"UDP", "10.2.15.239", "239.255.255.250", 214}).addRow(new Object[]{"UDP", "10.2.15.239", "239.255.255.250", 214}).build();
        Assert.assertEquals((long)3L, (long)sets.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testValidHeaders() throws Exception {
        String sql = "select * from dfs.`pcapng/sniff.pcapng`";
        DirectRowSet sets = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata schema = new SchemaBuilder().add("timestamp", TypeProtos.MinorType.TIMESTAMP).add("packet_length", TypeProtos.MinorType.INT).addNullable("type", TypeProtos.MinorType.VARCHAR).addNullable("src_ip", TypeProtos.MinorType.VARCHAR).addNullable("dst_ip", TypeProtos.MinorType.VARCHAR).addNullable("src_port", TypeProtos.MinorType.INT).addNullable("dst_port", TypeProtos.MinorType.INT).addNullable("src_mac_address", TypeProtos.MinorType.VARCHAR).addNullable("dst_mac_address", TypeProtos.MinorType.VARCHAR).addNullable("tcp_session", TypeProtos.MinorType.BIGINT).addNullable("tcp_ack", TypeProtos.MinorType.INT).addNullable("tcp_flags", TypeProtos.MinorType.INT).addNullable("tcp_flags_ns", TypeProtos.MinorType.INT).addNullable("tcp_flags_cwr", TypeProtos.MinorType.INT).addNullable("tcp_flags_ece", TypeProtos.MinorType.INT).addNullable("tcp_flags_ece_ecn_capable", TypeProtos.MinorType.INT).addNullable("tcp_flags_ece_congestion_experienced", TypeProtos.MinorType.INT).addNullable("tcp_flags_urg", TypeProtos.MinorType.INT).addNullable("tcp_flags_ack", TypeProtos.MinorType.INT).addNullable("tcp_flags_psh", TypeProtos.MinorType.INT).addNullable("tcp_flags_rst", TypeProtos.MinorType.INT).addNullable("tcp_flags_syn", TypeProtos.MinorType.INT).addNullable("tcp_flags_fin", TypeProtos.MinorType.INT).addNullable("tcp_parsed_flags", TypeProtos.MinorType.VARCHAR).addNullable("packet_data", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    @Ignore
    public void testPcapNG() throws Exception {
        String sql = "select * from dfs.`todo/mac2.pcap` limit 1";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)1L, (long)sets.rowCount());
        sets.clear();
    }

    @Test
    public void testGroupBy() throws Exception {
        String sql = "select src_ip, count(1), sum(packet_length) from dfs.`pcapng/sniff.pcapng` group by src_ip";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)47L, (long)sets.rowCount());
        sets.clear();
    }

    @Test
    public void testDistinctQuery() throws Exception {
        String sql = "select distinct `timestamp`, src_ip from dfs.`pcapng/sniff.pcapng`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)119L, (long)sets.rowCount());
        sets.clear();
    }

    @Test(expected=UserRemoteException.class)
    public void testBasicQueryWithIncorrectFileName() throws Exception {
        String sql = "select * from dfs.`pcapng/drill.pcapng`";
        client.queryBuilder().sql(sql).rowSet();
    }

    @Test
    public void testPcapNGFileWithPcapExt() throws Exception {
        String sql = "select count(*) from dfs.`pcapng/example.pcap`";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)1L, (long)cnt);
    }

    @Test
    public void testInlineSchema() throws Exception {
        String sql = "SELECT type, packet_length, `timestamp` FROM table(dfs.`pcapng/sniff.pcapng` (type => 'pcapng', stat => false, sessionizeTCPStreams => true )) where type = 'ARP'";
        DirectRowSet sets = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("type", TypeProtos.MinorType.VARCHAR).add("packet_length", TypeProtos.MinorType.INT).add("timestamp", TypeProtos.MinorType.TIMESTAMP).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"ARP", 90, Instant.ofEpochMilli(1518010669927L)}).addRow(new Object[]{"ARP", 90, Instant.ofEpochMilli(1518010671874L)}).build();
        Assert.assertEquals((long)2L, (long)sets.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }
}

