/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.persistent.store.pcap;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.TestWithZookeeper;
import org.apache.drill.exec.coord.zk.PathUtils;
import org.apache.drill.exec.coord.zk.ZookeeperClient;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.pcap.plugin.PcapFormatConfig;
import org.apache.drill.exec.store.pcap.plugin.PcapngFormatConfig;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.store.ZookeeperPersistentStore;
import org.apache.drill.exec.store.sys.store.provider.ZookeeperPersistentStoreProvider;
import org.apache.zookeeper.CreateMode;
import org.junit.Assert;
import org.junit.Test;

public class TestPcapWithPersistentStore
extends TestWithZookeeper {
    @Test
    public void pcapPluginBackwardCompatabilityTest() throws Exception {
        String oldPlugin = "oldFormatPlugin";
        try (CuratorFramework curator = this.createCurator();){
            curator.start();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerSubtypes(new Class[]{PcapFormatConfig.class, PcapngFormatConfig.class});
            PersistentStoreConfig storeConfig = PersistentStoreConfig.newJacksonBuilder((ObjectMapper)objectMapper, FileSystemConfig.class).name("type").build();
            try (ZookeeperClient zkClient = new ZookeeperClient(curator, PathUtils.join((String[])new String[]{"/", storeConfig.getName()}), CreateMode.PERSISTENT);){
                zkClient.start();
                String oldFormatPlugin = DrillFileUtils.getResourceAsString((String)"/config/oldPcapPlugins.json");
                zkClient.put("oldFormatPlugin", oldFormatPlugin.getBytes(), null);
            }
            try (ZookeeperPersistentStoreProvider provider = new ZookeeperPersistentStoreProvider(this.zkHelper.getConfig(), curator);){
                PersistentStore store = provider.getOrCreateStore(storeConfig);
                Assert.assertTrue((boolean)(store instanceof ZookeeperPersistentStore));
                FileSystemConfig oldPluginConfig = (FileSystemConfig)((ZookeeperPersistentStore)store).get("oldFormatPlugin", null);
                Map formats = oldPluginConfig.getFormats();
                Assert.assertEquals(formats.keySet(), (Object)ImmutableSet.of((Object)"pcap", (Object)"pcapng"));
                PcapFormatConfig pcap = (PcapFormatConfig)formats.get("pcap");
                PcapngFormatConfig pcapng = (PcapngFormatConfig)formats.get("pcapng");
                Assert.assertEquals((Object)pcap.getExtensions(), (Object)ImmutableList.of((Object)"pcap"));
                Assert.assertTrue((boolean)pcapng.getStat());
            }
        }
    }
}

