/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.msaccess;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.FormatPluginConfig;

@JsonTypeName(value="msaccess")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class MSAccessFormatConfig
implements FormatPluginConfig {
    private final List<String> extensions;
    private final String tableName;

    @JsonCreator
    public MSAccessFormatConfig(@JsonProperty(value="extensions") List<String> extensions, @JsonProperty(value="tableName") String tableName) {
        this.extensions = extensions == null ? Arrays.asList("accdb", "mdb") : ImmutableList.copyOf(extensions);
        this.tableName = tableName;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<String> getExtensions() {
        return this.extensions;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSAccessFormatConfig that = (MSAccessFormatConfig)o;
        return Objects.equals(this.extensions, that.extensions) && Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.extensions, this.tableName);
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("extensions", this.extensions).field("tableName", this.tableName).toString();
    }
}

