/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.msaccess;

import org.apache.drill.categories.RowSetTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryTestUtil;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTest.class})
public class TestMSAccessReader
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
    }

    @Test
    public void testStarQuery() throws Exception {
        String sql = "SELECT * FROM table(cp.`data/V2019/extDateTestV2019.accdb` (type=> 'msaccess', tableName => 'Table1')) LIMIT 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ID", TypeProtos.MinorType.INT).addNullable("Field1", TypeProtos.MinorType.VARCHAR).addNullable("DateExt", TypeProtos.MinorType.TIMESTAMP).addNullable("DateNormal", TypeProtos.MinorType.TIMESTAMP).addNullable("DateExtStr", TypeProtos.MinorType.VARCHAR).addNullable("DateNormalCalc", TypeProtos.MinorType.TIMESTAMP).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, "row1", QueryTestUtil.ConvertDateToLong((String)"2020-06-17T00:00:00Z"), QueryTestUtil.ConvertDateToLong((String)"2020-06-17T00:00:00Z"), "6/17/2020", QueryTestUtil.ConvertDateToLong((String)"2020-06-17T00:00:00Z")}).addRow(new Object[]{2, "row2", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T00:00:00Z"), QueryTestUtil.ConvertDateToLong((String)"2021-06-14T00:00:00Z"), "6/14/2021", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T00:00:00Z")}).addRow(new Object[]{3, "row3", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T12:45:00Z"), QueryTestUtil.ConvertDateToLong((String)"2021-06-14T12:45:00Z"), "6/14/2021 12:45:00.0000000 PM", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T12:45:00Z")}).addRow(new Object[]{4, "row4", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T01:45:00Z"), QueryTestUtil.ConvertDateToLong((String)"2021-06-14T01:45:00Z"), "6/14/2021 1:45:00.0000000 AM", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T01:45:00Z")}).addRow(new Object[]{5, "row5", null, null, null, null}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitQuery() throws Exception {
        String sql = "SELECT ID, Field1, DateExt, DateNormal, DateExtStr, DateNormalCalc FROM table(cp.`data/V2019/extDateTestV2019.accdb` (type=> 'msaccess', tableName => 'Table1')) LIMIT 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ID", TypeProtos.MinorType.INT).addNullable("Field1", TypeProtos.MinorType.VARCHAR).addNullable("DateExt", TypeProtos.MinorType.TIMESTAMP).addNullable("DateNormal", TypeProtos.MinorType.TIMESTAMP).addNullable("DateExtStr", TypeProtos.MinorType.VARCHAR).addNullable("DateNormalCalc", TypeProtos.MinorType.TIMESTAMP).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, "row1", QueryTestUtil.ConvertDateToLong((String)"2020-06-17T00:00:00Z"), QueryTestUtil.ConvertDateToLong((String)"2020-06-17T00:00:00Z"), "6/17/2020", QueryTestUtil.ConvertDateToLong((String)"2020-06-17T00:00:00Z")}).addRow(new Object[]{2, "row2", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T00:00:00Z"), QueryTestUtil.ConvertDateToLong((String)"2021-06-14T00:00:00Z"), "6/14/2021", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T00:00:00Z")}).addRow(new Object[]{3, "row3", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T12:45:00Z"), QueryTestUtil.ConvertDateToLong((String)"2021-06-14T12:45:00Z"), "6/14/2021 12:45:00.0000000 PM", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T12:45:00Z")}).addRow(new Object[]{4, "row4", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T01:45:00Z"), QueryTestUtil.ConvertDateToLong((String)"2021-06-14T01:45:00Z"), "6/14/2021 1:45:00.0000000 AM", QueryTestUtil.ConvertDateToLong((String)"2021-06-14T01:45:00Z")}).addRow(new Object[]{5, "row5", null, null, null, null}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testStarQueryWithDataTypes() throws Exception {
        String sql = "SELECT * FROM table(cp.`data/V2010/testV2010.accdb` (type=> 'msaccess', tableName => 'Table1')) LIMIT 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("A", TypeProtos.MinorType.VARCHAR).addNullable("B", TypeProtos.MinorType.VARCHAR).addNullable("C", TypeProtos.MinorType.TINYINT).addNullable("D", TypeProtos.MinorType.SMALLINT).addNullable("E", TypeProtos.MinorType.INT).addNullable("F", TypeProtos.MinorType.FLOAT8).addNullable("G", TypeProtos.MinorType.TIMESTAMP).addNullable("H", TypeProtos.MinorType.VARDECIMAL).addNullable("I", TypeProtos.MinorType.BIT).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"a", "b", 0, 0, 0, 0.0, QueryTestUtil.ConvertDateToLong((String)"1981-12-12T00:00:00Z"), 0, false}).addRow(new Object[]{"abcdefg", "hijklmnop", 2, 222, 333333333, 444.555, QueryTestUtil.ConvertDateToLong((String)"1974-09-21T00:00:00Z"), 4, true}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testMetadataStarQuery() throws Exception {
        String sql = "SELECT * FROM cp.`data/V2019/extDateTestV2019.accdb`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("table", TypeProtos.MinorType.VARCHAR).add("created_date", TypeProtos.MinorType.TIMESTAMP).add("updated_date", TypeProtos.MinorType.TIMESTAMP).add("row_count", TypeProtos.MinorType.INT).add("col_count", TypeProtos.MinorType.INT).addArray("columns", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"Table1", QueryTestUtil.ConvertDateToLong((String)"2021-06-03T20:09:56.993Z"), QueryTestUtil.ConvertDateToLong((String)"2021-06-03T20:09:56.993Z"), 9, 6, RowSetUtilities.strArray((String[])new String[]{"ID", "Field1", "DateExt", "DateNormal", "DateExtStr", "DateNormalCalc"})}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "SELECT COUNT(*) AS cnt FROM table(cp.`data/V2019/extDateTestV2019.accdb` (type=> 'msaccess', tableName => 'Table1'))";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)9L, (long)cnt);
    }
}

