/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.index;

import com.mapr.drill.maprdb.tests.index.TestBigTable;
import java.util.HashMap;
import java.util.Map;

public class TableIndexCmd {
    public static Map<String, String> parseParameter(String[] params) {
        HashMap<String, String> retParams = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].startsWith("-") || i >= params.length - 1) continue;
            String paramName = params[i].replaceFirst("-*", "");
            retParams.put(paramName, params[i + 1]);
            ++i;
        }
        return retParams;
    }

    public static void pressEnterKeyToContinue() {
        System.out.println("Press any key to continue...");
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String inHost = "localhost";
        String inPort = "5181";
        String inTable = "/tmp/population";
        String dictPath = "hbase";
        boolean waitKeyPress = true;
        long inSize = 10000L;
        Map<String, String> params = TableIndexCmd.parseParameter(args);
        if (args.length >= 2) {
            if (params.get("host") != null) {
                inHost = params.get("host");
            }
            if (params.get("port") != null) {
                inPort = params.get("port");
            }
            if (params.get("table") != null) {
                inTable = params.get("table");
            }
            if (params.get("size") != null) {
                inSize = Long.parseLong(params.get("size"));
            }
            if (params.get("dict") != null) {
                dictPath = params.get("dict");
            }
            if (params.get("wait") != null) {
                String answer = params.get("wait");
                boolean bl = waitKeyPress = answer.startsWith("y") || answer.startsWith("t");
            }
        }
        if (waitKeyPress) {
            TableIndexCmd.pressEnterKeyToContinue();
        }
        try {
            TestBigTable tbt = new TestBigTable();
            tbt.init(inHost, inPort);
            tbt.gen.generateTableWithIndex(inTable, (int)(inSize & 0xFFFFFFFFL), null);
        }
        catch (Exception e) {
            System.out.println("generate big table got exception:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

