/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.index;

import com.mapr.drill.maprdb.tests.index.IndexPlanTest;
import com.mapr.tests.annotations.ClusterTest;
import org.apache.drill.PlanTestBase;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@Category(value={ClusterTest.class})
public class IndexHintPlanTest
extends IndexPlanTest {
    private static final String defaultHavingIndexPlan = "alter session reset `planner.enable_index_planning`";

    @Test
    public void testSimpleIndexHint() throws Exception {
        String hintquery = "SELECT  t.id.ssn as ssn FROM table(hbase.`index_test_primary`(type => 'maprdb', index => 'i_ssn')) as t  where t.id.ssn = '100007423'";
        String query = "SELECT t.id.ssn as ssn FROM hbase.`index_test_primary` as t where t.id.ssn = '100007423'";
        IndexHintPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)hintquery, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_ssn"}, (String[])new String[]{"RowKeyJoin"});
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_ssn"}, (String[])new String[]{"RowKeyJoin"});
        IndexHintPlanTest.testBuilder().sqlQuery(hintquery).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).go();
    }

    @Test
    public void testHintCaseWithMultipleIndexes_1() throws Exception {
        String hintquery = "SELECT t.`address`.`state` AS `state` FROM table(hbase.`index_test_primary`(type => 'maprdb', index => 'i_state_city')) as t  where t.address.state = 'pc'";
        String query = "SELECT t.`address`.`state` AS `state` FROM hbase.`index_test_primary` as t where t.address.state = 'pc'";
        IndexHintPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)hintquery, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_state_city"}, (String[])new String[]{"RowKeyJoin"});
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=(i_state_city|i_state_age_phone)"}, (String[])new String[]{"RowKeyJoin"});
    }

    @Test
    public void testHintCaseWithMultipleIndexes_2() throws Exception {
        String hintquery = "SELECT t.`address`.`state` AS `state` FROM table(hbase.`index_test_primary`(type => 'maprdb', index => 'i_state_age_phone')) as t  where t.address.state = 'pc'";
        String query = "SELECT t.`address`.`state` AS `state` FROM hbase.`index_test_primary` as t where t.address.state = 'pc'";
        IndexHintPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)hintquery, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_state_age_phone"}, (String[])new String[]{"RowKeyJoin"});
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=(i_state_city|i_state_age_phone)"}, (String[])new String[]{"RowKeyJoin"});
    }

    @Test
    public void testWithMultipleIndexesButNoIndexWithHint() throws Exception {
        String hintquery = "SELECT t.`address`.`state` AS `state` FROM table(hbase.`index_test_primary`(type => 'maprdb', index => 'i_state_and_city')) as t  where t.address.state = 'pc'";
        IndexHintPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)hintquery, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=(i_state_city|i_state_age_phone)"}, (String[])new String[]{"RowKeyJoin"});
    }

    @Test
    public void testWithMultipleIndexesButNoIndexWithValidHint() throws Exception {
        String hintquery = "SELECT t.`address`.`state` AS `state` FROM table(hbase.`index_test_primary`(type => 'maprdb', index => 'i_ssn')) as t  where t.address.state = 'pc'";
        String query = "SELECT t.`address`.`state` AS `state` FROM hbase.`index_test_primary` as t where t.address.state = 'pc'";
        IndexHintPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)hintquery, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary"}, (String[])new String[]{"RowKeyJoin", "indexName="});
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=(i_state_city|i_state_age_phone)"}, (String[])new String[]{"RowKeyJoin"});
    }

    @Test
    public void testSimpleNoRowKeyJoin() throws Exception {
        String query = "SELECT `reverseid` from table(hbase.`index_test_primary`(type => 'maprdb', index => 'hash_i_reverseid'))  where `reverseid` = 1234";
        IndexHintPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=hash_i_reverseid"}, (String[])new String[]{"RowKeyJoin"});
    }
}

