/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.json;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.JsonTable;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.drill.maprdb.tests.json.BaseJsonTest;
import java.io.InputStream;
import java.util.Map;
import org.apache.drill.PlanTestBase;
import org.apache.drill.exec.util.EncodedSchemaPathSet;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ojai.DocumentStream;
import org.ojai.json.Json;

public class TestEncodedFieldPaths
extends BaseJsonTest {
    private static final String TABLE_NAME = "encoded_fields_userdata_table";
    private static final String INDEX_NAME = "encoded_fields_userdata_index";
    private static final String JSON_FILE_URL = "/com/mapr/drill/json/encoded_fields_userdata.json";
    private static boolean tableCreated = false;
    private static String tablePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setup_TestEncodedFieldPaths() throws Exception {
        try (JsonTable table = DBTests.createOrReplaceTable((String)TABLE_NAME, (Map)ImmutableMap.of((Object)"codes", (Object)"codes"));){
            tableCreated = true;
            tablePath = table.getPath().toUri().getPath();
            DBTests.createIndex((String)TABLE_NAME, (String)INDEX_NAME, (String[])new String[]{"age"}, (String[])new String[]{"name.last", "data.salary"});
            DBTests.admin().getTableIndexes(table.getPath(), true);
            try (InputStream in = TestEncodedFieldPaths.class.getResourceAsStream(JSON_FILE_URL);
                 DocumentStream stream = Json.newDocumentStream((InputStream)in);){
                table.insertOrReplace(stream);
                table.flush();
            }
            DBTests.waitForRowCount((Path)table.getPath(), (long)5L, (long)60000L);
            DBTests.waitForIndexFlush((Path)table.getPath(), (long)60000L);
        }
        finally {
            TestEncodedFieldPaths.test((String)"ALTER SESSION SET `planner.disable_full_table_scan` = true");
        }
    }

    @AfterClass
    public static void cleanup_TestEncodedFieldPaths() throws Exception {
        TestEncodedFieldPaths.test((String)"ALTER SESSION SET `planner.disable_full_table_scan` = false");
        if (tableCreated) {
            DBTests.deleteTables((String[])new String[]{TABLE_NAME});
        }
    }

    @Test
    public void test_encoded_fields_with_non_covering_index() throws Exception {
        String sql = String.format("SELECT\n  t.`%s`,t.`$$document`\nFROM\n  hbase.root.`%s` t\nWHERE (t.`age` > 20)\nORDER BY t.`_id` ASC", EncodedSchemaPathSet.encode((String[])new String[]{"_id", "codes"})[0], tablePath);
        this.setColumnWidths(new int[]{20, 60});
        this.runSQLAndVerifyCount(sql, 3);
        String[] expectedPlan = new String[]{"JsonTableGroupScan.*indexName=encoded_fields_userdata_index.*columns=\\[`_id`, `age`\\]", "RestrictedJsonTableGroupScan.*columns=\\[`age`, `\\$\\$ENC00L5UWIADDN5SGK4Y`, `\\$\\$document`, `_id`\\]", "RowKeyJoin"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void test_encoded_fields_with_covering_index() throws Exception {
        String sql = String.format("SELECT\n  t.`%s`,t.`$$document`\nFROM\n  hbase.root.`%s` t\nWHERE (t.`age` > 10)\nORDER BY t.`_id` ASC", EncodedSchemaPathSet.encode((String[])new String[]{"name.last", "data.salary"})[0], tablePath);
        this.setColumnWidths(new int[]{20, 60});
        this.runSQLAndVerifyCount(sql, 4);
        String[] expectedPlan = new String[]{"JsonTableGroupScan.*indexName=encoded_fields_userdata_index.*", "columns=\\[`age`, `\\$\\$ENC00NZQW2ZJONRQXG5AAMRQXIYJOONQWYYLSPE`, `\\$\\$document`, `_id`\\]"};
        String[] excludedPlan = new String[]{"RestrictedJsonTableGroupScan", "RowKeyJoin"};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void test_encoded_array_fields_projection() throws Exception {
        String sql = String.format("SELECT\n  t.`%s`,t.`$$document`\nFROM\n  hbase.root.`%s` t", EncodedSchemaPathSet.encode((String[])new String[]{"_id", "codes[]"})[0], tablePath);
        this.setColumnWidths(new int[]{20, 60});
        this.runSQLAndVerifyCount(sql, 5);
        String[] expectedPlan = new String[]{"JsonTableGroupScan.*", "columns=\\[`\\$\\$ENC00L5UWIADDN5SGK423LU`, `\\$\\$document`\\]"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }
}

