/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.json;

import com.mapr.db.JsonTable;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.drill.maprdb.tests.MaprDBTestsSuite;
import com.mapr.drill.maprdb.tests.json.BaseJsonTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.InputStream;
import org.apache.drill.PlanTestBase;
import org.apache.drill.SingleRowListener;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.util.VectorUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.json.Json;

@Category(value={ClusterTest.class})
public class TestSimpleJson
extends BaseJsonTest {
    private static final String TABLE_NAME = "business";
    private static final String JSON_FILE_URL = "/com/mapr/drill/json/business.json";
    private static boolean tableCreated = false;
    private static String tablePath;

    @Override
    protected String getTablePath() {
        return tablePath;
    }

    @BeforeClass
    public static void setup_TestSimpleJson() throws Exception {
        try (JsonTable table = DBTests.createOrReplaceTable((String)TABLE_NAME);
             InputStream in = MaprDBTestsSuite.getJsonStream(JSON_FILE_URL);
             DocumentStream stream = Json.newDocumentStream((InputStream)in);){
            tableCreated = true;
            tablePath = table.getPath().toUri().getPath();
            for (Document document : stream) {
                table.insert(document, "business_id");
            }
            table.flush();
        }
    }

    @AfterClass
    public static void cleanup_TestEncodedFieldPaths() throws Exception {
        if (tableCreated) {
            DBTests.deleteTables((String[])new String[]{TABLE_NAME});
        }
    }

    @Test
    public void testSelectStar() throws Exception {
        String sql = this.format("SELECT\n  *\nFROM\n  %s.`%s` business");
        this.runSQLAndVerifyCount(sql, 10);
    }

    @Test
    public void testSelectId() throws Exception {
        this.setColumnWidths(new int[]{23});
        String sql = this.format("SELECT\n  _id\nFROM\n  %s.`%s` business");
        this.runSQLAndVerifyCount(sql, 10);
    }

    @Test
    public void testSelectNonExistentColumns() throws Exception {
        this.setColumnWidths(new int[]{23});
        String sql = this.format("SELECT\n  something\nFROM\n  %s.`%s` business limit 5");
        this.runSQLAndVerifyCount(sql, 5);
    }

    @Test
    public void testKVGen() throws Exception {
        this.setColumnWidths(new int[]{21, 10, 6});
        String sql = this.format("select _id, t.parking[0].`key` K, t.parking[0].`value` V from (select _id, kvgen(b.attributes.Parking) as parking from %s.`%s` b) as t where t.parking[0].`key` = 'garage' AND t.parking[0].`value` = true");
        this.runSQLAndVerifyCount(sql, 1);
    }

    @Test
    public void testPushdownDisabled() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, categories, full_address\nFROM\n  table(%s.`%s`(type => 'maprdb', enablePushdown => false)) business\nWHERE\n name <> 'Sprint'");
        this.runSQLAndVerifyCount(sql, 9);
        String[] expectedPlan = new String[]{"condition=null", "columns=\\[`name`, `_id`, `categories`, `full_address`, `\\**`\\]"};
        String[] excludedPlan = new String[]{"condition=\\(name != \"Sprint\"\\)"};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushdownStringEqual() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, business.hours.Monday.`open`, categories[1], years[2], full_address\nFROM\n  %s.`%s` business\nWHERE\n name = 'Sprint'");
        final Document queryResult = MapRDBImpl.newDocument();
        SingleRowListener listener = new SingleRowListener(){

            protected void rowArrived(QueryDataBatch result) {
                RecordBatchLoader loader = new RecordBatchLoader(TestSimpleJson.getAllocator());
                loader.load(result.getHeader().getDef(), result.getData());
                StringBuilder sb = new StringBuilder();
                VectorUtil.appendVectorAccessibleContent((VectorAccessible)loader, (StringBuilder)sb, (String)"|", (boolean)false);
                loader.clear();
                queryResult.set("result", sb.toString());
            }
        };
        TestSimpleJson.testWithListener((UserBitShared.QueryType)UserBitShared.QueryType.SQL, (String)sql, (UserResultsListener)listener);
        listener.waitForCompletion();
        Assert.assertNull((Object)queryResult.getString("error"));
        Assert.assertNotNull((Object)queryResult.getString("result"));
        String[] fields = queryResult.getString("result").split("\\|");
        Assert.assertEquals((Object)"11:00", (Object)fields[2]);
        Assert.assertEquals((Object)"Mobile Phones", (Object)fields[3]);
        Assert.assertEquals((Object)"2016.0", (Object)fields[4]);
        String[] expectedPlan = new String[]{"condition=\\(name = \"Sprint\"\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushdownStringLike() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, categories, full_address\nFROM\n  %s.`%s` business\nWHERE\n name LIKE 'S%%'");
        this.runSQLAndVerifyCount(sql, 3);
        String[] expectedPlan = new String[]{"condition=\\(name MATCHES \"\\^\\\\\\\\QS\\\\\\\\E\\.\\*\\$\"\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushdownStringNotEqual() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, categories, full_address\nFROM\n  %s.`%s` business\nWHERE\n name <> 'Sprint'");
        this.runSQLAndVerifyCount(sql, 9);
        String[] expectedPlan = new String[]{"condition=\\(name != \"Sprint\"\\)", "columns=\\[`_id`, `name`, `categories`, `full_address`\\]"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushdownLongEqual() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, categories, full_address\nFROM\n  %s.`%s` business\nWHERE\n zip = 85260");
        this.runSQLAndVerifyCount(sql, 1);
        String[] expectedPlan = new String[]{"condition=\\(zip = \\{\"\\$numberInt\":85260\\}\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testCompositePredicate() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, categories, full_address\nFROM\n  %s.`%s` business\nWHERE\n zip = 85260\n OR\n city = 'Las Vegas'");
        this.runSQLAndVerifyCount(sql, 4);
        String[] expectedPlan = new String[]{"condition=\\(\\(zip = \\{\"\\$numberInt\":85260\\}\\) or \\(city = \"Las Vegas\"\\)\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPruneScanRange() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, categories, full_address\nFROM\n  %s.`%s` business\nWHERE\n _id = 'jFTZmywe7StuZ2hEjxyA'");
        this.runSQLAndVerifyCount(sql, 1);
        String[] expectedPlan = new String[]{"condition=\\(_id = \"jFTZmywe7StuZ2hEjxyA\"\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    @Ignore(value="Bug 27981")
    public void testPruneScanRangeAndPushDownCondition() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, categories, full_address\nFROM\n  %s.`%s` business\nWHERE\n _id = 'jFTZmywe7StuZ2hEjxyA' AND\n name = 'Subway'");
        this.runSQLAndVerifyCount(sql, 1);
        String[] expectedPlan = new String[]{"condition=\\(\\(_id = \"jFTZmywe7StuZ2hEjxyA\"\\) and \\(name = \"Subway\"\\)\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownOnSubField1() throws Exception {
        this.setColumnWidths(new int[]{25, 120, 20});
        String sql = this.format("SELECT\n  _id, name, b.attributes.Ambience.touristy attributes\nFROM\n  %s.`%s` b\nWHERE\n b.attributes.Ambience.casual = false");
        this.runSQLAndVerifyCount(sql, 1);
        String[] expectedPlan = new String[]{"condition=\\(attributes.Ambience.casual = false\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownOnSubField2() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, b.attributes.Attire attributes\nFROM\n  %s.`%s` b\nWHERE\n b.attributes.Attire = 'casual'");
        this.runSQLAndVerifyCount(sql, 4);
        String[] expectedPlan = new String[]{"condition=\\(attributes.Attire = \"casual\"\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownIsNull() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, attributes\nFROM\n  %s.`%s` business\nWHERE\n business.attributes.Ambience.casual IS NULL");
        this.runSQLAndVerifyCount(sql, 7);
        String[] expectedPlan = new String[]{"condition=\\(\\(attributes.Ambience.casual = null\\) or \\(TYPE_OF\\(attributes.Ambience.casual\\) = NULL\\)\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownIsNotNull() throws Exception {
        this.setColumnWidths(new int[]{25, 75, 75, 50});
        String sql = this.format("SELECT\n  _id, name, b.attributes.Parking\nFROM\n  %s.`%s` b\nWHERE\n b.attributes.Ambience.casual IS NOT NULL");
        this.runSQLAndVerifyCount(sql, 3);
        String[] expectedPlan = new String[]{"condition=\\(\\(attributes.Ambience.casual != null\\) and \\(TYPE_OF\\(attributes.Ambience.casual\\) != NULL\\)\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownOnSubField3() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 40, 40});
        String sql = this.format("SELECT\n  _id, name, b.attributes.`Accepts Credit Cards` attributes\nFROM\n  %s.`%s` b\nWHERE\n b.attributes.`Accepts Credit Cards` IS NULL");
        this.runSQLAndVerifyCount(sql, 3);
        String[] expectedPlan = new String[]{"condition=\\(\\(attributes.Accepts Credit Cards = null\\) or \\(TYPE_OF\\(attributes.Accepts Credit Cards\\) = NULL\\)\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownLong() throws Exception {
        String sql = this.format("SELECT\n  *\nFROM\n  %s.`%s` business\nWHERE\n stars > 4.0");
        this.runSQLAndVerifyCount(sql, 2);
        String[] expectedPlan = new String[]{"condition=\\(stars > 4\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownSubField4() throws Exception {
        String sql = this.format("SELECT\n  *\nFROM\n  %s.`%s` business\nWHERE\n business.attributes.`Good For`.lunch is true AND stars > 4.1");
        this.runSQLAndVerifyCount(sql, 1);
        String[] expectedPlan = new String[]{"condition=\\(\\(attributes.Good For.lunch = true\\) and \\(stars > 4.1\\)\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownSubField5() throws Exception {
        String sql = this.format("SELECT\n  *\nFROM\n  %s.`%s` business\nWHERE\n business.hours.Tuesday.`open` < TIME '10:30:00'");
        this.runSQLAndVerifyCount(sql, 1);
        String[] expectedPlan = new String[]{"condition=\\(hours.Tuesday.open < \\{\"\\$time\":\"10:30:00\"\\}\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownSubField6() throws Exception {
        String sql = this.format("SELECT\n  *\nFROM\n  %s.`%s` business\nWHERE\n business.hours.Sunday.`close` > TIME '20:30:00'");
        this.runSQLAndVerifyCount(sql, 3);
        String[] expectedPlan = new String[]{"condition=\\(hours.Sunday.close > \\{\"\\$time\":\"20:30:00\"\\}\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownSubField7() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 25, 45});
        String sql = this.format("SELECT\n  _id, name, start_date, last_update\nFROM\n  %s.`%s` business\nWHERE\n business.`start_date` = DATE '2012-07-14'");
        this.runSQLAndVerifyCount(sql, 1);
        String[] expectedPlan = new String[]{"condition=\\(start_date = \\{\"\\$dateDay\":\"2012-07-14\"\\}\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testPushDownSubField8() throws Exception {
        this.setColumnWidths(new int[]{25, 40, 25, 45});
        String sql = this.format("SELECT\n  _id, name, start_date, last_update\nFROM\n  %s.`%s` business\nWHERE\n business.`last_update` = TIMESTAMP '2012-10-20 07:42:46'");
        this.runSQLAndVerifyCount(sql, 1);
        String[] expectedPlan = new String[]{"condition=\\(last_update = \\{\"\\$date\":\"2012-10-20T07:42:46.000Z\"\\}\\)"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    @Test
    public void testLimit() throws Exception {
        String sql = this.format("SELECT\n  _id, name, start_date, last_update\nFROM\n  %s.`%s` business\nlimit 1");
        String[] expectedPlan = new String[]{"JsonTableGroupScan.*limit=1"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
        this.runSQLAndVerifyCount(sql, 1);
    }
}

