/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.index;

import com.mapr.drill.maprdb.tests.index.TestComplexTypeIndex;
import com.mapr.tests.annotations.ClusterTest;
import org.apache.drill.PlanTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClusterTest.class})
public class TestComplexTypeFullTableAndIndex
extends TestComplexTypeIndex {
    @BeforeClass
    public static void setupTestComplexTypeFullTableAndIndex() throws Exception {
        TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
    }

    @AfterClass
    public static void cleanupTestComplexTypeFullTableAndIndex() throws Exception {
        TestComplexTypeFullTableAndIndex.test((String)"alter session reset `planner.enable_complex_type_fts`");
    }

    @Test
    public void SemiJoinNonCoveringWithRangeCondition_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "SELECT _id from hbase.`index_test_complex1` where _id in  (select _id from (select _id, flatten(weight) as f from hbase.`index_test_complex1`) as t  where t.f.low > 120 and t.f.high < 200) ";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*>.*120.*"}, (String[])new String[]{"Join", ".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void SemiJoinWithEqualityConditionOnOuterTable_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t where t.f.low <= 200)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*<=.*20.*"}, (String[])new String[]{"Join", ".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void SemiJoinWithSubqueryConditionOnITEMField_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = " select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 where t1.`salary`.`max` > 10) as t where t.f.high <= 200)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*<=.*200.*"}, (String[])new String[]{"Join", ".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void testCoveringIndexWithPredOnIncludedField_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id from hbase.`index_test_complex1`where _id in (select _id from (select _id from (select _id, county, flatten(weight) as f from hbase.`index_test_complex1` as t1 where t1.`county` = 'Santa Clara') as t where t.f.high > 10))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*>.*10.*"}, (String[])new String[]{"Join", ".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void testCoveringIndexWithPredOnITEMIncludedField_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id from hbase.`index_test_complex1`where _id in (select _id from (select _id from (select _id, county, flatten(weight) as f from hbase.`index_test_complex1` as t1 where t1.`salary`.`max` > 100) as t where t.f.high > 10))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*>.*10.*"}, (String[])new String[]{"Join", ".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void SemiJoinWithInnerTableConditionOnArrayAndNonArrayField_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f, t1.`salary`.`min` as minimum_salary from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200 and t2.minimum_salary >= 0) and t.`county` = 'Santa Clara'";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*20.*"}, (String[])new String[]{".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void SemiJoinWithStarOnOuterTable_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select * from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f, t1.`salary`.`min` as minimum_salary from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 20 and t2.minimum_salary >= 0)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*20.*"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*columns=.*`\\*\\*`.*", ".*indexname.*"});
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void SemiJoinCoveringIndexPlan_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 20 )";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*20.*"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*columns=.*`\\*\\*`.*", ".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void SemiJoinWithStarAndid_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select * from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200 ) and t.`county` = 'Santa Clara'";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*20.*"}, (String[])new String[]{"Join", "RowKeyJoin", ".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Ignore
    @Test
    public void SemiJoinWithFlattenOnLeftSide_2_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id, flatten(t.weight) f from hbase.`index_test_complex1` as t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*200.*"}, (String[])new String[]{".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void SemiJoinWithTwoDifferentTables_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id, flatten(t.weight) f from hbase.`index_test_complex_without_index` as t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex_without_index,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex_without_index,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*200.*", ".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void SemiJoinCoveringIndexScalarArray_1_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.cars) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f like 'Toyota%' )";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*cars.*MATCHES.*Toyota.*"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*columns=.*`\\*\\*`.*", ".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void TestEqualityForMap_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = " select t.salary from hbase.`index_test_complex1` as t where t.salary = cast('{\"min\":1000.0, \"max\":2000.0}' as VARBINARY)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*salary.*min.*1000.*max.*2000.*"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", ".*indexname.*"});
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void TestEqualityForList_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = " select t.weight from hbase.`index_test_complex1` as t where t.weight = cast('[{\"low\":120, \"high\":150},{\"low\":110, \"high\":145}]' as VARBINARY)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*120.*high.*150.*low.*110.*high.*145.*"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", ".*indexname.*"});
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void TestEqualityForMapWithConjunction_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = " select t.salary from hbase.`index_test_complex1` as t where t.salary = cast('{\"min\":1000.0, \"max\":2000.0}' as VARBINARY) and t.county='Santa Clara'";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*salary.*min.*1000.*max.*2000.*"}, (String[])new String[]{".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void TestEqualityForListWithConjunction_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select t.weight from hbase.`index_test_complex1` as t where t.weight = cast('[{\"low\":120, \"high\":150},{\"low\":110, \"high\":145}]' as VARBINARY) and t.`_id`='user001' ";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*120.*high.*150.*low.*110.*high.*145.*"}, (String[])new String[]{".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void TestNestedFlattenWithConjunction_fts() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id from hbase.`index_test_complex1` as t  where _id in (select _id from (select _id, flatten(t1.`f1`.`products`) as f2 from (select _id, flatten(orders) as f1  from hbase.`index_test_complex1`) as t1) as t2  where t2.`f2`.`price` > 50 and t2.`f2`.`prodname` like '%bike%')";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*elementAnd.*orders\\[\\]\\.products\\[\\].*price.*prodname"}, (String[])new String[]{".*indexname.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void testNestedFlattenWithElementAnd_fts() throws Exception {
        try {
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from  (select _id, flatten(t1.`f1`.`products`) as f2 from (select _id, flatten(orders) as f1 from hbase.`index_test_complex1`) as t1) as t2  where t2.`f2`.`price` > 50 and t2.`f2`.`prodname` like '%bike%')";
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*elementAnd.*orders.*products.*price.*50.*and.*prodname.*bike"}, (String[])new String[]{"RowKeyJoin"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void testNestedFlattenElementAnd_fts1() throws Exception {
        try {
            String query = "select _id, county from hbase.`index_test_complex1` where _id in (select _id from  (select _id, flatten(t1.`f1`.`products`) as f2 from (select _id, flatten(orders) as f1 from hbase.`index_test_complex1`) as t1) as t2  where t2.`f2`.`price` > 50 and t2.`f2`.`prodname` like '%bike%')";
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*elementAnd.*orders.*products.*price.*50.*and.*prodname.*bike"}, (String[])new String[0]);
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void TestAndWithFullTableScan() throws Exception {
        try {
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1 , flatten(weight) as f2 from  hbase.`index_test_complex1` as t1) as t where t.f1.low = 120  and t.f2.high = 145)";
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=(.*weight.*low.*120.*|.*weight.*high.*145)"}, (String[])new String[]{".*elementAnd"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void TestSimpleOr() throws Exception {
        try {
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1 , t1.`salary`.`max` as maxsal from hbase.`index_test_complex1` as t1 ) as t where t.f1.high = 150 or maxsal = 2000)";
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*150.*or.*salary.*max.*2000"}, (String[])new String[0]);
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Test
    public void TestBooleanIsTrue() throws Exception {
        try {
            String query = "select _id from hbase.`index_test_complex1` as t where t.`online` is true and t.`discount`.`eligible` is true";
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=(.*online.*=.*true.*.*discount.*eligible.*=.*true)"}, (String[])new String[0]);
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
        }
    }

    @Test
    public void TestBooleanIsFalse() throws Exception {
        try {
            String query = "select _id from hbase.`index_test_complex1` as t where t.`online` is false and t.`discount`.`eligible` is false";
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=(.*online.*=.*false.*discount.*eligible.*=.*false)"}, (String[])new String[0]);
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
        }
    }

    @Test
    public void TestOrWithAnd() throws Exception {
        try {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1 , t1.`salary`.`max` as maxsal from hbase.`index_test_complex1` as t1 ) as t where (t.f1.low = 120 or maxsal >= 2000) and (t.f1.low = 140 or t.f1.high = 150))";
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.index.noncovering_selectivity_threshold` = 1.0");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*or.*salary.*max.*2000.*and.*weight.*low.*140.*weight.*high"}, (String[])new String[]{".*elementAnd"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForTestQuery("alter session set `planner.enable_complex_type_fts` = true").optionSettingQueriesForBaseline("alter session set `planner.enable_complex_type_fts` = false").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }

    @Override
    @Test
    public void TestNoFilterPushDownWithNonSemiJoin() throws Exception {
        try {
            String query = "select _id from (select _id, flatten(t1.cars) as f1 from hbase.`index_test_complex1` as t1 ) as t2 where t2.f1 like 'Toyota%'";
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = true");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=null.*"}, (String[])new String[]{".*indexName=.*"});
            TestComplexTypeFullTableAndIndex.testBuilder().optionSettingQueriesForTestQuery("alter session set `planner.enable_index_planning` = true").optionSettingQueriesForBaseline("alter session set `planner.enable_index_planning` = false;alter session set `planner.enable_complex_type_fts` = false").unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_index_planning` = false");
            TestComplexTypeFullTableAndIndex.test((String)"alter session set `planner.enable_complex_type_fts` = true");
        }
    }
}

