/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.index;

import com.mapr.db.Admin;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.drill.maprdb.tests.MaprDBTestsSuite;
import com.mapr.drill.maprdb.tests.index.LargeTableGen;
import com.mapr.drill.maprdb.tests.json.BaseJsonTest;
import java.io.InputStream;
import org.apache.drill.PlanTestBase;
import org.apache.drill.exec.util.EncodedSchemaPathSet;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.json.Json;

public class TestProjectionPassThroughWithComplexTypeIndex
extends BaseJsonTest {
    public static final String noIndexPlan = "alter session set `planner.enable_index_planning` = false";
    public static final String IndexPlanning = "alter session set `planner.enable_index_planning` = true";
    public static final String ComplexFTSTypePlanning = "alter session set `planner.enable_complex_type_fts` = true";
    public static final String DisableComplexFTSTypePlanning = "alter session set `planner.enable_complex_type_fts` = false";
    public static final String ResetComplexFTSTypePlanning = "alter session reset `planner.enable_complex_type_fts`";
    public static final String maxNonCoveringSelectivityThreshold = "alter session set `planner.index.noncovering_selectivity_threshold` = 1.0";
    private static final String TABLE_NAME = "/tmp/index_test_projection";
    private static final String JSON_FILE_URL = "/com/mapr/drill/json/complex_sample1.json";
    private static boolean tableCreated = false;
    private static String tablePath;

    @BeforeClass
    public static void setupTestProjectionPassThroughWithComplexTypeIndex() throws Exception {
        tablePath = TestProjectionPassThroughWithComplexTypeIndex.createTableAndIndex(TABLE_NAME, true, JSON_FILE_URL);
        System.out.println("waiting for indexes to sync....");
        Thread.sleep(60000L);
    }

    private static String createTableAndIndex(String tableName, boolean createIndex, String fileName) throws Exception {
        String tablePath;
        String[] indexList = new String[]{"weightIdx1", "weight[].low, weight[].high, weight[].average", "name,cars", "salaryIdx", "salary", "", "weightListIdx", "weight", ""};
        try (Table table = TestProjectionPassThroughWithComplexTypeIndex.createOrReplaceTable(tableName);
             InputStream in = MaprDBTestsSuite.getJsonStream(fileName);
             DocumentStream stream = Json.newDocumentStream((InputStream)in);){
            tableCreated = true;
            tablePath = table.getPath().toUri().getPath();
            System.out.println(String.format("Created table %s", tablePath));
            if (createIndex) {
                TestProjectionPassThroughWithComplexTypeIndex.createIndexes(table, indexList);
                DBTests.setTableStatsSendInterval((long)1L);
            }
            for (Document document : stream) {
                table.insert(document, "user_id");
            }
            table.flush();
            System.out.println("Inserted documents. Waiting for indexes to be updated..");
            if (createIndex) {
                DBTests.waitForIndexFlush((Path)table.getPath(), (long)60000L);
            }
            System.out.println("Finished waiting for index updates.");
        }
        return tablePath;
    }

    private static Table createOrReplaceTable(String tableName) {
        Admin admin = MaprDBTestsSuite.getAdmin();
        if (admin != null && admin.tableExists(tableName)) {
            admin.deleteTable(tableName);
        }
        TableDescriptorImpl desc = new TableDescriptorImpl(new Path(tableName));
        return admin.createTable((TableDescriptor)desc);
    }

    private static void createIndexes(Table table, String[] indexList) throws Exception {
        LargeTableGen gen = new LargeTableGen(MaprDBTestsSuite.getAdmin());
        System.out.println("Creating indexes..");
        gen.createIndex(table, indexList);
    }

    @AfterClass
    public static void cleanupTestProjectionPassThroughWithComplexTypeIndex() throws Exception {
        Admin admin;
        if (tableCreated && (admin = MaprDBTestsSuite.getAdmin()) != null && admin.tableExists(TABLE_NAME)) {
            admin.deleteTable(TABLE_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_encoded_fields_list_equality() throws Exception {
        try {
            TestProjectionPassThroughWithComplexTypeIndex.test((String)IndexPlanning);
            String sql = String.format("SELECT\n t.`%s`, t.`$$document`\n from hbase.`index_test_projection` as t where t.weight = cast('[{\"average\":135, \"high\":150, \"low\":120}, {\"average\":130, \"high\":145, \"low\":110}]' as VARBINARY)", EncodedSchemaPathSet.encode((String[])new String[]{"weight"})[0]);
            this.setColumnWidths(new int[]{40, 80});
            this.runSQLAndVerifyCount(sql, 3);
            String[] expectedPlan = new String[]{"JsonTableGroupScan.*condition=.*weight.*average.*135.*high.*150.*low.*120.*average.*130.*high.*145.*low.*110.*indexName=weightListIdx", "columns=\\[`weight`, `\\$\\$ENC00O5SWSZ3IOQ`, `\\$\\$document`\\]"};
            String[] excludedPlan = new String[]{};
            PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
        }
        finally {
            TestProjectionPassThroughWithComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void test_encoded_fields_map_equality() throws Exception {
        TestProjectionPassThroughWithComplexTypeIndex.test((String)IndexPlanning);
        String sql = String.format("SELECT\n t.`%s`, t.`$$document`\n from hbase.`index_test_projection` as t where t.salary = cast('{\"max\":5000.0, \"min\":1500.0}' as VARBINARY)", EncodedSchemaPathSet.encode((String[])new String[]{"salary"})[0]);
        this.setColumnWidths(new int[]{40, 80});
        this.runSQLAndVerifyCount(sql, 2);
        String[] expectedPlan = new String[]{"JsonTableGroupScan.*condition=.*salary.*max.*5000.*min.*1500.*indexName=.*salaryIdx", "columns=\\[`salary`, `\\$\\$ENC00ONQWYYLSPE`, `\\$\\$document`\\]"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_encoded_fields_with_non_covering_index() throws Exception {
        try {
            TestProjectionPassThroughWithComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestProjectionPassThroughWithComplexTypeIndex.test((String)IndexPlanning);
            TestProjectionPassThroughWithComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String sql = String.format("SELECT\n  `%s`,t.`$$document`\n FROM\n hbase.`index_test_projection` t\n WHERE _id in\n (select _id from ( select _id, flatten(t1.weight) as f1 from hbase.`index_test_projection` as t1) as t where t.f1.low = 140 and t.f1.high = 190)", EncodedSchemaPathSet.encode((String[])new String[]{"_id", "county", "cars"})[0]);
            String[] expectedPlan = new String[]{"JsonTableGroupScan.*condition.*weight.*low.*140.*and.*weight.*high.*190.*indexName=.*weightIdx1", "RestrictedJsonTableGroupScan.*columns=\\[`_id`, `\\$\\$ENC00L5UWIADDN52W45DZABRWC4TT`, `\\$\\$document`\\]"};
            String[] excludedPlan = new String[]{};
            PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
            this.setColumnWidths(new int[]{40, 80});
            this.runSQLAndVerifyCount(sql, 2);
        }
        finally {
            TestProjectionPassThroughWithComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_encoded_fields_with_covering_index() throws Exception {
        try {
            TestProjectionPassThroughWithComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestProjectionPassThroughWithComplexTypeIndex.test((String)IndexPlanning);
            String sql = String.format("SELECT\n `%s`,t.`$$document`\n FROM\n hbase.`index_test_projection` t\n WHERE _id in\n (select _id from ( select _id, flatten(t1.weight) as f1 from hbase.`index_test_projection` as t1) as t where t.f1.low = 120 and t.f1.high = 150)", EncodedSchemaPathSet.encode((String[])new String[]{"_id", "name", "cars"})[0]);
            this.setColumnWidths(new int[]{40, 80});
            this.runSQLAndVerifyCount(sql, 3);
            String[] expectedPlan = new String[]{"JsonTableGroupScan.*condition.*weight.*low.*120.*and.*weight.*high.*150.*indexName=.*weightIdx1.*columns=\\[`_id`, `\\$\\$ENC00L5UWIADOMFWWKADDMFZHG`, `\\$\\$document`\\]"};
            String[] excludedPlan = new String[]{"RowKeyJoin"};
            PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
        }
        finally {
            TestProjectionPassThroughWithComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_encoded_fields_with_complex_FTS() throws Exception {
        try {
            TestProjectionPassThroughWithComplexTypeIndex.test((String)ComplexFTSTypePlanning);
            TestProjectionPassThroughWithComplexTypeIndex.test((String)noIndexPlan);
            String sql = String.format("SELECT\n `%s`,t.`$$document`\n FROM\n hbase.`index_test_projection` t\n WHERE _id in\n (select _id from ( select _id, flatten(t1.weight) as f1 from  hbase.`index_test_projection` as t1) as t where t.f1.low = 120 and t.f1.high = 150)", EncodedSchemaPathSet.encode((String[])new String[]{"_id", "name", "cars"})[0]);
            this.setColumnWidths(new int[]{40, 80});
            this.runSQLAndVerifyCount(sql, 3);
            String[] expectedPlan = new String[]{"JsonTableGroupScan.*condition.*elementAnd.*low.*120.*high.*150.*columns=\\[`_id`, `\\$\\$ENC00L5UWIADOMFWWKADDMFZHG`, `\\$\\$document`, `_id`, `weight`\\]"};
            String[] excludedPlan = new String[]{};
            PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
        }
        finally {
            TestProjectionPassThroughWithComplexTypeIndex.test((String)IndexPlanning);
            TestProjectionPassThroughWithComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
        }
    }

    @Test
    public void test_encoded_fields_with_boolean() throws Exception {
        String sql = String.format("SELECT\n t.`$$document`\n FROM\n hbase.`index_test_projection` t\n WHERE _id in\n (select _id from  hbase.`index_test_projection` as t where t.`online` is true and ojai_typeof(t.`discount`.`eligible`, 2))", new Object[0]);
        this.setColumnWidths(new int[]{40, 80});
        this.runSQLAndVerifyCount(sql, 7);
        String[] expectedPlan = new String[]{"JsonTableGroupScan.*condition.*online.*=.*true.*TYPE_OF.*discount.*eligible.*BOOLEAN.*columns=\\[`_id`, `online`, `discount`.`eligible`\\]"};
        String[] excludedPlan = new String[]{};
        PlanTestBase.testPlanMatchingPatterns((String)sql, (String[])expectedPlan, (String[])excludedPlan);
    }
}

