/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.index;

import com.mapr.db.Admin;
import com.mapr.drill.maprdb.tests.MaprDBTestsSuite;
import com.mapr.drill.maprdb.tests.index.LargeTableGen;
import com.mapr.drill.maprdb.tests.json.BaseJsonTest;
import com.mapr.tests.annotations.ClusterTest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.config.DrillConfig;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@Category(value={ClusterTest.class})
public class IndexPlanTest
extends BaseJsonTest {
    static final String PRIMARY_TABLE_NAME = "/tmp/index_test_primary";
    static final int PRIMARY_TABLE_SIZE = 10000;
    private static final String sliceTargetSmall = "alter session set `planner.slice_target` = 1";
    private static final String sliceTargetDefault = "alter session reset `planner.slice_target`";
    private static final String noIndexPlan = "alter session set `planner.enable_index_planning` = false";
    private static final String defaultHavingIndexPlan = "alter session reset `planner.enable_index_planning`";
    private static final String disableHashAgg = "alter session set `planner.enable_hashagg` = false";
    private static final String enableHashAgg = "alter session set `planner.enable_hashagg` = true";
    private static final String lowNonCoveringSelectivityThreshold = "alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001";
    private static final String defaultnonCoveringSelectivityThreshold = "alter session set `planner.index.noncovering_selectivity_threshold` = 0.025";
    private static final String incrnonCoveringSelectivityThreshold = "alter session set `planner.index.noncovering_selectivity_threshold` = 0.25";
    private static final String disableFTS = "alter session set `planner.disable_full_table_scan` = true";
    private static final String enableFTS = "alter session reset `planner.disable_full_table_scan`";
    private static final String preferIntersectPlans = "alter session set `planner.index.prefer_intersect_plans` = true";
    private static final String defaultIntersectPlans = "alter session reset `planner.index.prefer_intersect_plans`";
    private static final String lowRowKeyJoinBackIOFactor = "alter session set `planner.index.rowkeyjoin_cost_factor` = 0.01";
    private static final String defaultRowKeyJoinBackIOFactor = "alter session reset `planner.index.rowkeyjoin_cost_factor`";
    private static final String incrRowKeyJoinConvSelThreshold = "alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0";
    private static final String defaultRowKeyConvSelThreshold = "alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`";
    private static final String forceRowKeyJoinConversionUsingHashJoin = "alter session set `planner.rowkeyjoin_conversion_using_hashjoin` = true";
    private static final String defaultRowKeyJoinConversionUsingHashJoin = "alter session reset `planner.rowkeyjoin_conversion_using_hashjoin`";
    private static final String semiColon = ";";

    @BeforeClass
    public static void setupTableIndexes() throws Exception {
        Properties overrideProps = new Properties();
        overrideProps.setProperty("format-maprdb.json.useNumRegionsForDistribution", "true");
        IndexPlanTest.updateTestCluster((int)1, (DrillConfig)DrillConfig.create((Properties)overrideProps));
        MaprDBTestsSuite.setupTests();
        MaprDBTestsSuite.createPluginAndGetConf(IndexPlanTest.getDrillbitContext());
        IndexPlanTest.test((String)incrnonCoveringSelectivityThreshold);
        System.out.print("setupTableIndexes begins");
        Admin admin = MaprDBTestsSuite.getAdmin();
        if (admin != null && admin.tableExists(PRIMARY_TABLE_NAME)) {
            admin.deleteTable(PRIMARY_TABLE_NAME);
        }
        LargeTableGen gen = new LargeTableGen(MaprDBTestsSuite.getAdmin());
        String[] indexDef = new String[]{"i_ssn", "id.ssn", "contact.phone", "i_state_city", "address.state,address.city", "name.fname,name.lname", "i_age", "personal.age", "", "i_age_desc", "personal.age:desc", "", "i_income", "personal.income", "", "i_lic", "driverlicense", "reverseid", "i_state_city_dl", "address.state,address.city", "driverlicense", "i_cast_int_ssn", "$CAST(id.ssn@INT)", "contact.phone", "i_cast_vchar_lic", "$CAST(driverlicense@STRING)", "contact.email", "i_state_age_phone", "address.state,personal.age,contact.phone", "name.fname", "i_cast_age_income_phone", "$CAST(personal.age@INT),$CAST(personal.income@INT),contact.phone", "name.fname", "i_age_with_fname", "personal.age", "name.fname", "i_rowid_cast_date_birthdate", "rowid", "$CAST(personal.birthdate@DATE)", "hash_i_reverseid", "reverseid", "", "hash_i_cast_timestamp_firstlogin", "$CAST(activity.irs.firstlogin@TIMESTAMP)", "id.ssn"};
        gen.generateTableWithIndex(PRIMARY_TABLE_NAME, 10000, indexDef);
    }

    @AfterClass
    public static void cleanupTableIndexes() throws Exception {
        Admin admin = MaprDBTestsSuite.getAdmin();
        if (admin == null || admin.tableExists(PRIMARY_TABLE_NAME)) {
            // empty if block
        }
        IndexPlanTest.test((String)defaultnonCoveringSelectivityThreshold);
    }

    @Test
    public void CTASTestTable() throws Exception {
        String ctasQuery = "CREATE TABLE hbase.tmp.`backup_index_test_primary` AS SELECT * FROM hbase.`index_test_primary` as t ";
        IndexPlanTest.test((String)ctasQuery);
        IndexPlanTest.test((String)"DROP TABLE IF EXISTS hbase.tmp.`backup_index_test_primary`");
    }

    @Test
    public void CoveringPlanWithNonIndexedField() throws Exception {
        String query = "SELECT t.`contact`.`phone` AS `phone` FROM hbase.`index_test_primary` as t  where t.id.ssn = '100007423'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_ssn"}, (String[])new String[]{"RowKeyJoin"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500005471"}).go();
    }

    @Test
    public void CoveringPlanWithOnlyIndexedField() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn` FROM hbase.`index_test_primary` as t  where t.id.ssn = '100007423'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_ssn"}, (String[])new String[]{"RowKeyJoin"});
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).go();
    }

    @Test
    public void NoIndexPlanForNonIndexField() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn` FROM hbase.`index_test_primary` as t  where t.contact.phone = '6500005471'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary"}, (String[])new String[]{"RowKeyJoin", "indexName="});
        IndexPlanTest.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007632"}).go();
    }

    @Test
    public void NonCoveringPlan() throws Exception {
        String query = "SELECT t.`name`.`fname` AS `fname` FROM hbase.`index_test_primary` as t  where t.id.ssn = '100007423'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_primary,", ".*JsonTableGroupScan.*tableName=.*index_test_primary,.*indexName=i_ssn"}, (String[])new String[0]);
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"KfFzK"}).go();
    }

    @Test
    public void RangeConditionIndexPlan() throws Exception {
        String query = "SELECT t.`name`.`lname` AS `lname` FROM hbase.`index_test_primary` as t  where t.personal.age > 52 AND t.name.fname='KfFzK'";
        try {
            IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.index.rowkeyjoin_cost_factor` = 0.01;");
            String optionsForTestQuery = "alter session reset `planner.enable_index_planning`;alter session set `planner.index.rowkeyjoin_cost_factor` = 0.01";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_primary,", ".*JsonTableGroupScan.*tableName=.*index_test_primary,.*indexName=(i_age|i_age_with_fname)"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(optionsForTestQuery).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
            IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(sliceTargetSmall).optionSettingQueriesForBaseline(sliceTargetDefault).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            IndexPlanTest.test((String)defaultRowKeyJoinBackIOFactor);
        }
    }

    @Test
    public void CoveringWithSimpleFieldsOnly() throws Exception {
        String query = "SELECT t._id AS `tid` FROM hbase.`index_test_primary` as t  where t.driverlicense = 100007423";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"JsonTableGroupScan.*tableName=.*index_test_primary,.*indexName=i_lic"}, (String[])new String[]{"RowKeyJoin"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"tid"}).baselineValues(new Object[]{"1012"}).go();
    }

    @Test
    public void NonCoveringWithSimpleFieldsOnly() throws Exception {
        String query = "SELECT t.rowid AS `rowid` FROM hbase.`index_test_primary` as t  where t.driverlicense = 100007423";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan.*tableName=.*index_test_primary(.*[\n\r])+.*JsonTableGroupScan.*tableName=.*index_test_primary,.*indexName=i_lic"}, (String[])new String[0]);
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"rowid"}).baselineValues(new Object[]{"1012"}).go();
    }

    @Test
    public void NonCoveringWithExtraConditonOnPrimary() throws Exception {
        String query = "SELECT t.`name`.`fname` AS `fname` FROM hbase.`index_test_primary` as t  where t.personal.age = 53 AND t.name.lname='UZwNk'";
        try {
            IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.index.rowkeyjoin_cost_factor` = 0.01;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan", ".*JsonTableGroupScan.*indexName=i_age"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"KfFzK"}).go();
        }
        finally {
            IndexPlanTest.test((String)defaultRowKeyJoinBackIOFactor);
        }
    }

    @Test
    public void Intersect2indexesPlan() throws Exception {
        String query = "SELECT t.`name`.`lname` AS `lname` FROM hbase.`index_test_primary` as t  where t.personal.age = 53 AND t.personal.income=45";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)"alter session set `planner.index.prefer_intersect_plans` = true;alter session set `planner.disable_full_table_scan` = true");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*HashJoin(.*[\n\r])+.*JsonTableGroupScan.*indexName=(i_age|i_income)(.*[\n\r])+.*JsonTableGroupScan.*indexName=(i_age|i_income)"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"UZwNk"}).baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"foNwtze"}).baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"qGZVfY"}).go();
            IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(sliceTargetSmall).optionSettingQueriesForBaseline(sliceTargetDefault).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.index.prefer_intersect_plans`;alter session reset `planner.disable_full_table_scan`");
        }
    }

    @Test
    public void CompositeIndexNonCoveringPlan() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn` FROM hbase.`index_test_primary` as t  where t.address.state = 'pc' AND t.address.city='pfrrs'";
        try {
            IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.index.rowkeyjoin_cost_factor` = 0.01;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName=i_state_"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
            IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(sliceTargetSmall).optionSettingQueriesForBaseline(sliceTargetDefault).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            IndexPlanTest.test((String)defaultRowKeyJoinBackIOFactor);
        }
    }

    @Test
    public void CompositeIndexNonCoveringFilterWithAllFieldsPlan() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn` FROM hbase.`index_test_primary` as t  where t.address.state = 'pc' AND t.address.city='pfrrs' AND t.driverlicense IN (100007423, 100007424)";
        IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.index.rowkeyjoin_cost_factor` = 0.01;");
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan.*condition=.*state.*city.*driverlicense.*or.*driverlicense.*(.*[\n\r])+.*JsonTableGroupScan.*indexName="}, (String[])new String[0]);
        IndexPlanTest.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).go();
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(sliceTargetSmall).optionSettingQueriesForBaseline(sliceTargetDefault).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
    }

    @Test
    public void CompositeIndexCoveringPlan() throws Exception {
        String query = "SELECT t.`address`.`city` AS `city` FROM hbase.`index_test_primary` as t  where t.address.state = 'pc' AND t.address.city='pfrrs'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*indexName=i_state_city"}, (String[])new String[]{"RowKeyJoin", "Filter"});
        IndexPlanTest.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"city"}).baselineValues(new Object[]{"pfrrs"}).baselineColumns(new String[]{"city"}).baselineValues(new Object[]{"pfrrs"}).go();
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(sliceTargetSmall).optionSettingQueriesForBaseline(sliceTargetDefault).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
    }

    @Test
    public void TestNonCoveringRangePartition_1() throws Exception {
        String query = "SELECT t.`name`.`lname` AS `lname` FROM hbase.`index_test_primary` as t  where t.personal.age = 53";
        String[] expectedPlan = new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan.*tableName=.*index_test_primary(.*[\n\r])+.*RangePartitionExchange(.*[\n\r])+.*JsonTableGroupScan.*tableName=.*index_test_primary,.*indexName=(i_age|i_age_with_fname)"};
        IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.slice_target` = 1;");
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])expectedPlan, (String[])new String[0]);
        try {
            IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)sliceTargetDefault);
        }
    }

    @Test
    public void TestCastVarCharCoveringPlan() throws Exception {
        String query = "SELECT t._id as tid, cast(t.driverlicense as varchar(255)) as driverlicense FROM hbase.`index_test_primary` as t  where cast(t.driverlicense as varchar(255))='100007423'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_cast_vchar_lic"}, (String[])new String[]{"RowKeyJoin"});
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).sqlQuery(query).ordered().baselineColumns(new String[]{"tid", "driverlicense"}).baselineValues(new Object[]{"1012", "100007423"}).go();
    }

    @Test
    public void TestCastINTCoveringPlan() throws Exception {
        String query = "SELECT t._id as tid, CAST(t.id.ssn as INT) as ssn, t.contact.phone AS `phone` FROM hbase.`index_test_primary` as t  where CAST(t.id.ssn as INT) = 100007423";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_cast_int_ssn"}, (String[])new String[]{"RowKeyJoin"});
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).sqlQuery(query).ordered().baselineColumns(new String[]{"tid", "ssn", "phone"}).baselineValues(new Object[]{"1012", 0x5F5FDFF, "6500005471"}).go();
    }

    @Test
    public void TestCastNonCoveringPlan() throws Exception {
        String query = "SELECT t.id.ssn AS `ssn` FROM hbase.`index_test_primary` as t  where CAST(t.id.ssn as INT) = 100007423";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName=i_cast_int_ssn"}, (String[])new String[0]);
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).go();
    }

    @Test
    public void TestCastVarchar_ConvertToRangePlan() throws Exception {
        String query = "SELECT t.id.ssn AS `ssn` FROM hbase.`index_test_primary` as t  where CAST(driverlicense as VARCHAR(10)) = '100007423'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*MATCHES \"\\^.*100007423.*E.*\\$\".*indexName=i_cast_vchar_lic"}, (String[])new String[0]);
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).go();
    }

    @Test
    public void TestCastNoIndexPlan() throws Exception {
        String query = "select t.id.ssn from hbase.`index_test_primary` t where cast(t.id.ssn as varchar(10)) = '100007423'";
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[0], (String[])new String[]{"indexName"});
    }

    @Test
    public void TestLongerCastVarCharNoIndex() throws Exception {
        String query = "SELECT t._id as tid, cast(t.driverlicense as varchar(500)) as driverlicense FROM hbase.`index_test_primary` as t  where cast(t.driverlicense as varchar(500))='100007423'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[0], (String[])new String[]{"RowKeyJoin", "indexName="});
    }

    @Test
    public void TestCoveringPlanSortRemoved() throws Exception {
        String query = "SELECT t.`contact`.`phone` as phone FROM hbase.`index_test_primary` as t  where t.id.ssn <'100000003' order by t.id.ssn";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_ssn"}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500008069"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001411"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001595"}).go();
    }

    @Test
    public void TestCoveringPlanSortNotRemoved() throws Exception {
        String query = "SELECT t.`contact`.`phone` as phone FROM hbase.`index_test_primary` as t  where t.id.ssn <'100000003' order by t.contact.phone";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort", ".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_ssn"}, (String[])new String[]{"RowkeyJoin"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001411"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001595"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500008069"}).go();
    }

    @Test
    public void TestCoveringPlanSortRemovedWithSimpleFields() throws Exception {
        String query = "SELECT t.driverlicense as l FROM hbase.`index_test_primary` as t  where t.driverlicense < 100000003 order by t.driverlicense";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_lic"}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"l"}).baselineValues(new Object[]{100000000L}).baselineColumns(new String[]{"l"}).baselineValues(new Object[]{100000001L}).baselineColumns(new String[]{"l"}).baselineValues(new Object[]{100000002L}).go();
    }

    @Test
    public void TestNonCoveringPlanSortRemoved() throws Exception {
        String query = "SELECT t.contact.phone as phone FROM hbase.`index_test_primary` as t  where t.driverlicense < 100000003 order by t.driverlicense";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName=i_lic"}, (String[])new String[]{"Sort"});
        String query2 = "SELECT t.name.fname as fname FROM hbase.`index_test_primary` as t  where t.id.ssn < '100000003' order by t.id.ssn";
        PlanTestBase.testPlanMatchingPatterns((String)query2, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName="}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500008069"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001411"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001595"}).go();
        IndexPlanTest.testBuilder().sqlQuery(query2).ordered().baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"VcFahj"}).baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"WbKVK"}).baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"vSAEsyFN"}).go();
        IndexPlanTest.test((String)sliceTargetSmall);
        try {
            PlanTestBase.testPlanMatchingPatterns((String)query2, (String[])new String[]{"SingleMergeExchange(.*[\n\r])+.*RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName=i_ssn"}, (String[])new String[]{"Sort"});
        }
        finally {
            IndexPlanTest.test((String)sliceTargetDefault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestNonCoveringPlanWithNoRemoveSortOption() throws Exception {
        try {
            IndexPlanTest.test((String)"alter session set `planner.index.force_sort_noncovering`=true");
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            String query = "SELECT t.contact.phone as phone FROM hbase.`index_test_primary` as t  where t.driverlicense < 100000003 order by t.driverlicense";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort", "RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName=i_lic"}, (String[])new String[0]);
            String query2 = "SELECT t.name.fname as fname FROM hbase.`index_test_primary` as t  where t.id.ssn < '100000003' order by t.id.ssn";
            PlanTestBase.testPlanMatchingPatterns((String)query2, (String[])new String[]{"Sort", "RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName="}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500008069"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001411"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001595"}).go();
            IndexPlanTest.testBuilder().sqlQuery(query2).ordered().baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"VcFahj"}).baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"WbKVK"}).baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"vSAEsyFN"}).go();
            IndexPlanTest.test((String)sliceTargetSmall);
            try {
                PlanTestBase.testPlanMatchingPatterns((String)query2, (String[])new String[]{"Sort", "SingleMergeExchange(.*[\n\r])+.*RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName=i_ssn"}, (String[])new String[0]);
            }
            finally {
                IndexPlanTest.test((String)sliceTargetDefault);
            }
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.index.force_sort_noncovering`");
        }
    }

    @Test
    public void TestCoveringPlanJoin_1() throws Exception {
        String query = "SELECT count(*) as cnt FROM hbase.`index_test_primary` as t1  inner join hbase.`index_test_primary` as t2 on t1.driverlicense = t2.driverlicense  where t1.driverlicense < 100000003 and t2.driverlicense < 100000003";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=", ".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName="}, (String[])new String[0]);
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"cnt"}).baselineValues(new Object[]{3L}).go();
    }

    @Test
    public void TestCoveringPlanJoin_2() throws Exception {
        String query = "SELECT count(*) as cnt FROM hbase.`index_test_primary` as t1  inner join hbase.`index_test_primary` as t2 on t1.contact.phone = t2.contact.phone  where t1.id.ssn < '100000003' and t2.id.ssn < '100000003' ";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=", ".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName="}, (String[])new String[0]);
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"cnt"}).baselineValues(new Object[]{3L}).go();
    }

    @Test
    public void TestCoveringPlanSortPrefix_1() throws Exception {
        String query = "SELECT t.contact.phone FROM hbase.`index_test_primary` as t  where t.address.state = 'wo' and t.personal.age = 35 and t.contact.phone < '6500003000' order by t.contact.phone";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_state_age_phone"}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
    }

    @Test
    public void TestCoveringPlanSortPrefix_2() throws Exception {
        String query = "SELECT t.contact.phone FROM hbase.`index_test_primary` as t  where t.address.state = 'wo' and t.personal.age < 35 and t.contact.phone < '6500003000' order by t.contact.phone";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort", ".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_state_age_phone"}, (String[])new String[0]);
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
    }

    @Test
    public void TestCoveringPlanSortPrefix_3() throws Exception {
        String query = "SELECT CAST(t.personal.age as VARCHAR) as age, t.contact.phone FROM hbase.`index_test_primary` as t  where t.address.state = 'wo' and t.personal.age < 35 and t.contact.phone < '6500003000' order by t.contact.phone, t.personal.age";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort", ".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_state_age_phone"}, (String[])new String[0]);
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
    }

    @Test
    public void TestCoveringPlanSortPrefix_4() throws Exception {
        String query = "SELECT t._id as tid, t.contact.phone, CAST(t.personal.age as VARCHAR) as age FROM hbase.`index_test_primary` as t  where t.address.state = 'wo' and t.personal.age < 35 and t.contact.phone < '6500003000' order by t.personal.age, t.contact.phone";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_state_age_phone"}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
    }

    @Test
    public void TestCoveringPlanSortPrefix_5() throws Exception {
        String query = "SELECT t._id as tid, t.contact.phone, CAST(t.personal.age as VARCHAR) as age FROM hbase.`index_test_primary` as t  where t.address.state = 'wo' and t.personal.age IN (31, 32, 33, 34) and t.contact.phone < '6500003000' order by t.contact.phone";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort", ".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_state_age_phone"}, (String[])new String[0]);
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
    }

    @Test
    public void TestCoveringPlanSortPrefix_6() throws Exception {
        String query = "SELECT t._id as tid, t.contact.phone, CAST(t.personal.age as VARCHAR) as age FROM hbase.`index_test_primary` as t  where t.address.state = 'wo' and t.personal.age < 35 and t.contact.phone < '6500003000' order by t.personal.age, t.contact.phone NULLS FIRST";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort", ".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_state_age_phone"}, (String[])new String[0]);
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
    }

    @Test
    public void TestCoveringPlanSortPrefix_7() throws Exception {
        String query = "SELECT t._id as tid, t.contact.phone, CAST(t.personal.age as VARCHAR) as age FROM hbase.`index_test_primary` as t  where t.address.state = 'wo' and t.personal.age < 35 and t.contact.phone < '6500003000' order by t.personal.age, t.contact.phone NULLS LAST";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_state_age_phone"}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().optionSettingQueriesForTestQuery(defaultHavingIndexPlan).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
    }

    @Test
    public void orderByCastCoveringPlan() throws Exception {
        String query = "SELECT t.contact.phone as phone FROM hbase.`index_test_primary` as t  where CAST(t.id.ssn as INT) < 100000003 order by CAST(t.id.ssn as INT)";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName="}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500008069"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001411"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001595"}).go();
    }

    @Test
    public void orderByNonCoveringPlan() throws Exception {
        String query = "SELECT t.name.lname as lname FROM hbase.`index_test_primary` as t  where t.id.ssn < '100000003' order by t.id.ssn";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName="}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"iuMG"}).baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"KpFq"}).baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"bkkAvz"}).go();
    }

    @Test
    public void orderByCastNonCoveringPlan() throws Exception {
        String query = "SELECT t.name.lname as lname FROM hbase.`index_test_primary` as t  where CAST(t.id.ssn as INT) < 100000003 order by CAST(t.id.ssn as INT)";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName="}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"iuMG"}).baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"KpFq"}).baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"bkkAvz"}).go();
    }

    @Ignore
    @Test
    public void NonCoveringPlan_SortPrefix_1() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn` FROM hbase.`index_test_primary` as t  where t.address.state > 'pc' AND t.address.city>'pfrrr' AND t.address.city<'pfrrt' order by t.adddress.city";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort", "RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName=i_state_city"}, (String[])new String[0]);
    }

    @Test
    public void NonCoveringPlan_SortPrefix_2() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn` FROM hbase.`index_test_primary` as t  where t.address.state = 'pc' AND t.address.city>'pfrrr' AND t.address.city<'pfrrt' order by t.address.city";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*JsonTableGroupScan.*indexName=i_state_city"}, (String[])new String[]{"Sort"});
    }

    @Ignore(value="Should be modified to get an index plan; not very useful since most covering plan filters get pushed")
    @Test
    public void nonIndexedColumnFilterCoveringPlan() throws Exception {
        String query = "SELECT t.name.fname as fname FROM hbase.`index_test_primary` as t  where t.personal.age > 68 and t.name.fname IN ('CnGobfR', 'THOHP')";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*Filter.*CnGobfR.*THOHP.*", ".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName="}, (String[])new String[]{".*Filter.*ITEM*CnGobfR.*THOHP.*"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"CnGobfR"}).baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"THOHP"}).baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"CnGobfR"}).go();
    }

    @Test
    @Ignore
    public void orderByLimitNonCoveringPlan() throws Exception {
        String query = "SELECT t.name.lname as lname FROM hbase.`index_test_primary` as t  where t.id.ssn < '100000003' order by t.id.ssn limit 2";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)sliceTargetSmall);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Limit(.*[\n\r])+.*SingleMergeExchange(.*[\n\r])+.*Limit(.*[\n\r])+.*indexName="}, (String[])new String[]{"Sort"});
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"iuMG"}).baselineColumns(new String[]{"lname"}).baselineValues(new Object[]{"KpFq"}).go();
        }
        finally {
            IndexPlanTest.test((String)sliceTargetDefault);
        }
    }

    @Test
    public void orderByLimitCoveringPlan() throws Exception {
        String query = "SELECT t.contact.phone as phone FROM hbase.`index_test_primary` as t  where t.id.ssn < '100000003' order by t.id.ssn limit 2";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Limit(.*[\n\r])+.*indexName=.*limit=2"}, (String[])new String[]{"Sort"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500008069"}).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500001411"}).go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pickAnyIndexWithFTSDisabledPlan() throws Exception {
        String lowCoveringSel = "alter session set `planner.index.covering_selectivity_threshold` = 0.025";
        String defaultCoveringSel = "alter session reset `planner.index.covering_selectivity_threshold`";
        String query = "SELECT t.`contact`.`phone` AS `phone` FROM hbase.`index_test_primary` as t  where t.id.ssn = '100007423'";
        try {
            IndexPlanTest.test((String)("alter session reset `planner.enable_index_planning`;" + lowCoveringSel + semiColon));
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary"}, (String[])new String[]{".*indexName=i_ssn"});
            IndexPlanTest.test((String)("alter session reset `planner.enable_index_planning`;" + lowCoveringSel + semiColon + disableFTS + semiColon));
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_ssn"}, (String[])new String[]{"RowKeyJoin"});
        }
        finally {
            IndexPlanTest.test((String)(defaultCoveringSel + semiColon + enableFTS + semiColon));
        }
    }

    @Test
    public void testCaseSensitive() throws Exception {
        String query = "SELECT t.contact.phone as phone FROM hbase.`index_test_primary` as t  where t.id.SSN = '100000003' ";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{""}, (String[])new String[]{"indexName"});
    }

    @Test
    public void testCaseSensitiveIncludedField() throws Exception {
        String query = "SELECT t.`CONTACT`.`phone` AS `phone` FROM hbase.`index_test_primary` as t  where t.id.ssn = '100007423'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*JsonTableGroupScan.*tableName=.*index_test_primary.*indexName=i_ssn"}, (String[])new String[0]);
    }

    @Test
    public void testHashIndexNoRemovingSort() throws Exception {
        String query = "SELECT t.`contact`.`phone` as phone FROM hbase.`index_test_primary` as t  where t.reverseid <'10' order by t.reverseid";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort", "indexName=hash_i_reverseid", "RowKeyJoin"}, (String[])new String[0]);
    }

    @Ignore
    @Test
    public void testCastTimestampPlan() throws Exception {
        String query = "SELECT  t.id.ssn as ssn FROM hbase.`index_test_primary` as t  where cast(t.activity.irs.firstlogin as timestamp)=to_timestamp('2013-02-04 22:34:38.0', 'YYYY-MM-dd HH:mm:ss.S')";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=hash_i_cast_timestamp_firstlogin"}, (String[])new String[]{"RowKeyJoin"});
        IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).go();
    }

    @Test
    public void testNotConditionNoIndexPlan() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn` FROM hbase.`index_test_primary` as t  where NOT t.id.ssn = '100007423'";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[0], (String[])new String[]{"indexName="});
        String notInQuery = "SELECT t.`id`.`ssn` AS `ssn` FROM hbase.`index_test_primary` as t  where t.id.ssn NOT IN ('100007423', '100007424')";
        PlanTestBase.testPlanMatchingPatterns((String)notInQuery, (String[])new String[0], (String[])new String[]{"indexName="});
        String notLikeQuery = "SELECT t.`id`.`ssn` AS `ssn` FROM hbase.`index_test_primary` as t  where t.id.ssn NOT LIKE '100007423'";
        PlanTestBase.testPlanMatchingPatterns((String)notLikeQuery, (String[])new String[0], (String[])new String[]{"indexName="});
    }

    @Test
    public void testNoFilterOrderByCoveringPlan() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn`, t.contact.phone as phone FROM hbase.`index_test_primary` as t order by t.id.ssn limit 2";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_ssn"}, (String[])new String[]{"Sort", "TopN", "RowKeyJoin"});
        IndexPlanTest.testBuilder().ordered().sqlQuery(query).baselineColumns(new String[]{"ssn", "phone"}).baselineValues(new Object[]{"100000000", "6500008069"}).baselineColumns(new String[]{"ssn", "phone"}).baselineValues(new Object[]{"100000001", "6500001411"}).build().run();
    }

    @Test
    public void testNoFilterAndLimitOrderByCoveringPlan() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn`, t.contact.phone as phone FROM hbase.`index_test_primary` as t order by t.id.ssn";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort"}, (String[])new String[]{"indexName=*", "RowKeyJoin", "TopN"});
    }

    @Test
    public void testNoFilterOrderByCast() throws Exception {
        String query = "SELECT CAST(t.id.ssn as INT) AS `ssn`, t.contact.phone as phone FROM hbase.`index_test_primary` as t order by CAST(t.id.ssn as INT) limit 2";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_cast_int_ssn"}, (String[])new String[]{"TopN", "Sort", "RowKeyJoin"});
        IndexPlanTest.testBuilder().ordered().sqlQuery(query).baselineColumns(new String[]{"ssn", "phone"}).baselineValues(new Object[]{100000000, "6500008069"}).baselineColumns(new String[]{"ssn", "phone"}).baselineValues(new Object[]{100000001, "6500001411"}).build().run();
    }

    @Test
    public void testNoFilterAndLimitOrderByCast() throws Exception {
        String query = "SELECT CAST(t.id.ssn as INT) AS `ssn`, t.contact.phone as phone FROM hbase.`index_test_primary` as t order by CAST(t.id.ssn as INT)";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"Sort"}, (String[])new String[]{"indexName=*", "TopN", "RowKeyJoin"});
    }

    @Test
    public void testNoFilterOrderByHashIndex() throws Exception {
        String query = "SELECT cast(t.activity.irs.firstlogin as timestamp) AS `firstlogin`, t.id.ssn as ssn FROM hbase.`index_test_primary` as t order by cast(t.activity.irs.firstlogin as timestamp), t.id.ssn limit 2";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"(Sort|TopN)"}, (String[])new String[]{"indexName="});
        LocalDateTime date = LocalDateTime.parse("2010-01-21T00:12:24", DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        IndexPlanTest.testBuilder().ordered().sqlQuery(query).baselineColumns(new String[]{"firstlogin", "ssn"}).baselineValues(new Object[]{date, "100005592"}).baselineColumns(new String[]{"firstlogin", "ssn"}).baselineValues(new Object[]{date, "100005844"}).build().run();
    }

    @Test
    public void testNoFilterOrderBySimpleField() throws Exception {
        String query = "SELECT t.reverseid as rid, t.driverlicense as lic FROM hbase.`index_test_primary` as t order by t.driverlicense limit 2";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_lic"}, (String[])new String[]{"Sort", "TopN"});
        IndexPlanTest.testBuilder().ordered().sqlQuery(query).baselineColumns(new String[]{"rid", "lic"}).baselineValues(new Object[]{"4539", 100000000L}).baselineColumns(new String[]{"rid", "lic"}).baselineValues(new Object[]{"943", 100000001L}).build().run();
    }

    @Test
    public void testNoFilterOrderByNoIndexMatch() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn`, t.contact.phone as phone FROM hbase.`index_test_primary` as t order by t.name.fname limit 2";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"(Sort|TopN)"}, (String[])new String[]{"indexName="});
    }

    @Test
    @Ignore
    public void IntersectPlanWithOneSideNoRows() throws Exception {
        try {
            String query = "SELECT t.`name`.`lname` AS `lname` FROM hbase.`index_test_primary` as t  where t.personal.age = 53 AND t.personal.income=111145";
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)"alter session set `planner.index.prefer_intersect_plans` = true;alter session set `planner.disable_full_table_scan` = true");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*HashJoin(.*[\n\r])+.*JsonTableGroupScan.*indexName=(i_age|i_income)(.*[\n\r])+.*JsonTableGroupScan.*indexName=(i_age|i_income)"}, (String[])new String[0]);
            IndexPlanTest.testNoResult((String)query, (Object[])new Object[0]);
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.index.prefer_intersect_plans`;alter session reset `planner.disable_full_table_scan`");
        }
    }

    @Test
    public void testTrailingFieldIndexCovering() throws Exception {
        String query = "SELECT t.`name`.`fname` AS `fname` FROM hbase.`index_test_primary` as t  where cast(t.personal.age as INT)=53 AND t.contact.phone='6500005471' ";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_cast_age_income_phone"}, (String[])new String[]{"RowKeyJoin"});
        IndexPlanTest.testBuilder().ordered().sqlQuery(query).baselineColumns(new String[]{"fname"}).baselineValues(new Object[]{"KfFzK"}).build().run();
    }

    @Test
    public void testIncludedFieldCovering() throws Exception {
        String query = "SELECT t.`contact`.`phone` AS `phone` FROM hbase.`index_test_primary` as t  where cast(t.personal.age as INT)=53 AND t.name.fname='KfFzK' ";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_cast_age_income_phone"}, (String[])new String[]{"RowKeyJoin"});
        IndexPlanTest.testBuilder().ordered().sqlQuery(query).baselineColumns(new String[]{"phone"}).baselineValues(new Object[]{"6500005471"}).build().run();
    }

    @Test
    public void testWithFilterGroupBy() throws Exception {
        String query = " select t1.driverlicense from hbase.`index_test_primary` t1 where t1.driverlicense > 100000001 group by t1.driverlicense limit 2";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)disableHashAgg);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_lic", "StreamAgg"}, (String[])new String[]{"(Sort|TopN)"});
            IndexPlanTest.testBuilder().ordered().sqlQuery(query).optionSettingQueriesForTestQuery(disableHashAgg).baselineColumns(new String[]{"driverlicense"}).baselineValues(new Object[]{100000002L}).baselineColumns(new String[]{"driverlicense"}).baselineValues(new Object[]{100000003L}).build().run();
        }
        finally {
            IndexPlanTest.test((String)enableHashAgg);
        }
    }

    @Test
    public void testNoFilterOrderByDesc() throws Exception {
        String query = " select t1.driverlicense from hbase.`index_test_primary` t1 order by t1.driverlicense desc limit 2";
        IndexPlanTest.test((String)defaultHavingIndexPlan);
        PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"(Sort|TopN)"}, (String[])new String[]{"indexName="});
        IndexPlanTest.testBuilder().unOrdered().sqlQuery(query).baselineColumns(new String[]{"driverlicense"}).baselineValues(new Object[]{100009999L}).baselineColumns(new String[]{"driverlicense"}).baselineValues(new Object[]{100009998L}).build().run();
    }

    @Test
    public void testNoFilterGroupBy() throws Exception {
        String query = " select t1.driverlicense from hbase.`index_test_primary` t1 group by t1.driverlicense limit 2";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)disableHashAgg);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_lic", "StreamAgg"}, (String[])new String[]{"(Sort|TopN)"});
            IndexPlanTest.testBuilder().ordered().sqlQuery(query).optionSettingQueriesForTestQuery(disableHashAgg).baselineColumns(new String[]{"driverlicense"}).baselineValues(new Object[]{100000000L}).baselineColumns(new String[]{"driverlicense"}).baselineValues(new Object[]{100000001L}).build().run();
        }
        finally {
            IndexPlanTest.test((String)enableHashAgg);
        }
    }

    @Test
    public void testNoFilterGroupByCoveringPlan() throws Exception {
        String query = "SELECT t.`id`.`ssn` AS `ssn`, max(t.contact.phone) as phone FROM hbase.`index_test_primary` as t group by t.id.ssn limit 2";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)disableHashAgg);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_ssn", "StreamAgg"}, (String[])new String[]{"Sort", "TopN", "RowKeyJoin"});
            IndexPlanTest.testBuilder().ordered().sqlQuery(query).optionSettingQueriesForTestQuery(disableHashAgg).baselineColumns(new String[]{"ssn", "phone"}).baselineValues(new Object[]{"100000000", "6500008069"}).baselineColumns(new String[]{"ssn", "phone"}).baselineValues(new Object[]{"100000001", "6500001411"}).build().run();
        }
        finally {
            IndexPlanTest.test((String)enableHashAgg);
        }
    }

    @Test
    public void testNoFilterGroupByCast() throws Exception {
        String query = "SELECT CAST(t.id.ssn as INT) AS `ssn`, max(t.contact.phone) as phone FROM hbase.`index_test_primary` as t group by CAST(t.id.ssn as INT) limit 2";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)disableHashAgg);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_cast_int_ssn", "StreamAgg"}, (String[])new String[]{"TopN", "Sort", "RowKeyJoin"});
            IndexPlanTest.testBuilder().ordered().sqlQuery(query).optionSettingQueriesForTestQuery(disableHashAgg).baselineColumns(new String[]{"ssn", "phone"}).baselineValues(new Object[]{100000000, "6500008069"}).baselineColumns(new String[]{"ssn", "phone"}).baselineValues(new Object[]{100000001, "6500001411"}).build().run();
        }
        finally {
            IndexPlanTest.test((String)enableHashAgg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoFilterGroupByHashIndex() throws Exception {
        String query = "SELECT cast(t.activity.irs.firstlogin as timestamp) AS `firstlogin`, max(t.id.ssn) as ssn FROM hbase.`index_test_primary` as t group by cast(t.activity.irs.firstlogin as timestamp) limit 2";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)disableHashAgg);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"(Sort|TopN)", "StreamAgg"}, (String[])new String[]{"indexName="});
            LocalDateTime date1 = LocalDateTime.parse("2010-01-21T00:12:24", DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            LocalDateTime date2 = LocalDateTime.parse("2010-01-21T00:24:48", DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            IndexPlanTest.testBuilder().unOrdered().sqlQuery(query).optionSettingQueriesForTestQuery(disableHashAgg).baselineColumns(new String[]{"firstlogin", "ssn"}).baselineValues(new Object[]{date1, "100006852"}).baselineColumns(new String[]{"firstlogin", "ssn"}).baselineValues(new Object[]{date2, "100003660"}).build().run();
        }
        finally {
            IndexPlanTest.test((String)enableHashAgg);
        }
    }

    @Test
    public void testNoFilterGroupBySimpleField() throws Exception {
        String query = "SELECT max(t.reverseid) as rid, t.driverlicense as lic FROM hbase.`index_test_primary` as t group by t.driverlicense limit 2";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)disableHashAgg);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_lic", "StreamAgg"}, (String[])new String[]{"Sort", "TopN"});
            IndexPlanTest.testBuilder().ordered().sqlQuery(query).optionSettingQueriesForTestQuery(disableHashAgg).baselineColumns(new String[]{"rid", "lic"}).baselineValues(new Object[]{"4539", 100000000L}).baselineColumns(new String[]{"rid", "lic"}).baselineValues(new Object[]{"943", 100000001L}).build().run();
        }
        finally {
            IndexPlanTest.test((String)enableHashAgg);
        }
    }

    @Test
    public void testNoFilterGroupByNoIndexMatch() throws Exception {
        String query = "SELECT max(t.`id`.`ssn`) AS `ssn`, max(t.contact.phone) as phone FROM hbase.`index_test_primary` as t group by t.name.fname limit 2";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)disableHashAgg);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"(Sort|TopN)", "StreamAgg"}, (String[])new String[]{"indexName="});
        }
        finally {
            IndexPlanTest.test((String)enableHashAgg);
        }
    }

    @Test
    public void testNoFilterGroupBySimpleFieldParallel() throws Exception {
        String query = "SELECT max(t.reverseid) as rid, t.driverlicense as lic FROM hbase.`index_test_primary` as t group by t.driverlicense order by t.driverlicense limit 2";
        String optionsForTestQuery = "alter session reset `planner.enable_index_planning`;alter session set `planner.enable_hashagg` = false;alter session set `planner.slice_target` = 1";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)disableHashAgg);
            IndexPlanTest.test((String)sliceTargetSmall);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_lic", "StreamAgg", "HashToMergeExchange"}, (String[])new String[]{"Sort", "TopN"});
            IndexPlanTest.testBuilder().unOrdered().sqlQuery(query).optionSettingQueriesForTestQuery(optionsForTestQuery).baselineColumns(new String[]{"rid", "lic"}).baselineValues(new Object[]{"4539", 100000000L}).baselineColumns(new String[]{"rid", "lic"}).baselineValues(new Object[]{"943", 100000001L}).build().run();
        }
        finally {
            IndexPlanTest.test((String)enableHashAgg);
            IndexPlanTest.test((String)sliceTargetDefault);
        }
    }

    @Test
    public void testLimitPushdownCoveringPlan() throws Exception {
        String query = "SELECT t.`name`.`fname` AS `fname` FROM hbase.`index_test_primary` as t  where t.personal.age = 53 limit 3";
        try {
            IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.disable_full_table_scan` = true;");
            PlanTestBase.testPlanWithAttributesMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*indexName=i_age_with_fname.*rowcount = 3.0"}, (String[])new String[0]);
        }
        finally {
            IndexPlanTest.test((String)enableFTS);
        }
    }

    @Test
    public void testLimitPushdownOrderByCoveringPlan() throws Exception {
        String query = "SELECT t.`name`.`fname` AS `fname` FROM hbase.`index_test_primary` as t  where t.personal.age = 53 order by t.personal.age limit 3";
        try {
            IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.disable_full_table_scan` = true;");
            PlanTestBase.testPlanWithAttributesMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*indexName=i_age_with_fname.*rowcount = 3.0"}, (String[])new String[0]);
        }
        finally {
            IndexPlanTest.test((String)enableFTS);
        }
    }

    @Test
    public void testLimitPushdownNonCoveringPlan() throws Exception {
        String query = "SELECT t.`name`.`lname` AS `lname` FROM hbase.`index_test_primary` as t  where t.personal.age = 53 limit 7";
        try {
            IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.disable_full_table_scan` = true;");
            PlanTestBase.testPlanWithAttributesMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_primary.*rowcount = 7.0"}, (String[])new String[0]);
        }
        finally {
            IndexPlanTest.test((String)enableFTS);
        }
    }

    @Test
    public void testLimitPushdownOrderByNonCoveringPlan() throws Exception {
        String query = "SELECT t.`name`.`lname` AS `lname` FROM hbase.`index_test_primary` as t  where t.personal.age = 53 order by t.personal.age limit 7";
        try {
            IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.disable_full_table_scan` = true;alter session set `planner.slice_target` = 1;");
            PlanTestBase.testPlanWithAttributesMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*"}, (String[])new String[]{".*tableName=.*index_test_primary.*rowcount = 7.*"});
        }
        finally {
            IndexPlanTest.test((String)enableFTS);
        }
    }

    @Test
    public void testLimit0Pushdown() throws Exception {
        String query = "select convert_from(convert_to(t.`name`.`lname`, 'JSON'), 'JSON') from hbase.`index_test_primary` as t limit 0";
        IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;");
        PlanTestBase.testPlanWithAttributesMatchingPatterns((String)query, (String[])new String[]{"Limit(.*[\n\r])+.*Project.*CONVERT_FROMJSON(.*[\n\r])+.*Scan"}, (String[])new String[0]);
    }

    @Test
    public void testRemovalOfReduntantHashToMergeExchange() throws Exception {
        String query = "SELECT t.driverlicense as lic FROM hbase.`index_test_primary` as t order by t.driverlicense limit 2";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)sliceTargetSmall);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_lic"}, (String[])new String[]{"HashToMergeExchange", "Sort", "TopN"});
            IndexPlanTest.testBuilder().ordered().sqlQuery(query).baselineColumns(new String[]{"lic"}).baselineValues(new Object[]{100000000L}).baselineColumns(new String[]{"lic"}).baselineValues(new Object[]{100000001L}).build().run();
        }
        finally {
            IndexPlanTest.test((String)sliceTargetDefault);
        }
    }

    @Test
    public void testMultiPhaseAgg() throws Exception {
        String query = "select count(t.reverseid) from hbase.`index_test_primary` as t group by t.driverlicense order by t.driverlicense";
        try {
            IndexPlanTest.test((String)defaultHavingIndexPlan);
            IndexPlanTest.test((String)sliceTargetSmall);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"indexName=i_lic", "HashToMergeExchange", "StreamAgg", "StreamAgg"}, (String[])new String[]{"Sort", "TopN"});
        }
        finally {
            IndexPlanTest.test((String)sliceTargetDefault);
        }
    }

    @Test
    public void testHangForSimpleDistinct() throws Exception {
        String query = "select distinct t.driverlicense from hbase.`index_test_primary` as t order by t.driverlicense limit 1";
        try {
            IndexPlanTest.test((String)sliceTargetSmall);
            IndexPlanTest.testBuilder().ordered().sqlQuery(query).baselineColumns(new String[]{"driverlicense"}).baselineValues(new Object[]{100000000L}).build().run();
        }
        finally {
            IndexPlanTest.test((String)sliceTargetDefault);
        }
    }

    @Test
    public void testRowkeyJoinPushdown_1() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1 where _id in (select t2._id  from hbase.`index_test_primary` t2 where t2.address.city = 'pfrrs' and t2.address.state = 'pc')";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Test
    public void testRowkeyJoinPushdown_2() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1, hbase.`index_test_primary` t2  where t1._id = t2._id and t2.address.city = 'pfrrs' and t2.address.state = 'pc'";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Test
    public void testRowkeyJoinPushdown_3() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1, hbase.`index_test_primary` t2  where t1._id = t2._id and t1.address.city = 'pfrrs' and t2.address.city = 'pfrrs'";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Test
    public void testRowkeyJoinPushdown_4() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1, hbase.`index_test_primary` t2  where t1._id = cast(t2.rowid as int) and t2.address.city = 'pfrrs'";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Test
    public void testRowkeyJoinPushdown_5() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1, hbase.`index_test_primary` t2  where t1._id = cast(cast(t2.rowid as int) as varchar(10)) and t2.address.city = 'pfrrs'";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Test
    public void testRowkeyJoinPushdown_6() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1 where _id in (select cast(cast(t2.rowid as int) as varchar(10)) from hbase.`index_test_primary` t2, hbase.`index_test_primary` t3 where t2.address.city = t3.address.city and t2.name.fname = 'ubar')";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100001382"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Test
    public void testRowkeyJoinPushdown_7() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1, hbase.`index_test_primary` t2 where t1._id = t2.rowid and t2.address.city = 'pfrrs'";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.25;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", "RestrictedJsonTableGroupScan", "RowKeyJoin", "Scan.*condition=\\(address.city = \"pfrrs\"\\)"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Test
    public void testRowkeyJoinPushdown_8() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1, hbase.`index_test_primary` t2 where t1._id = t2.rowid and t2.rowid = '1012'";
        try {
            IndexPlanTest.test((String)incrRowKeyJoinConvSelThreshold);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", "indexName=i_rowid_cast_date_birthdate"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).go();
        }
        finally {
            IndexPlanTest.test((String)defaultRowKeyConvSelThreshold);
        }
    }

    @Test
    public void testRowkeyJoinPushdown_9() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1 where cast(_id as varchar(10)) in (select t2._id from hbase.`index_test_primary` t2 where t2.address.city = 'pfrrs')";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[0], (String[])new String[]{"RowKeyJoin"});
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Test
    public void testRowkeyJoinPushdown_10() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1, hbase.`index_test_primary` t2  where cast(t1._id as varchar(10)) = cast(t2._id as varchar(10)) and t2.address.city = 'pfrrs'";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[0], (String[])new String[]{"RowKeyJoin"});
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Test
    public void testRowkeyJoinPushdown_11() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1 where cast(_id as varchar(10)) in (select t2._id from hbase.`index_test_primary` t2, hbase.`index_test_primary` t3 where t2.address.city = t3.address.city and t2.address.city = 'pfrrs')";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[0], (String[])new String[]{"RowKeyJoin"});
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Ignore
    @Test
    public void testRowkeyJoinPushdown_12() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1, hbase.`index_test_primary` t4 where t1.address.city = t4.address.city and t1._id in (select cast(cast(t2.rowid as int) as varchar(10)) from hbase.`index_test_primary` t2, hbase.`index_test_primary` t3 where t2.address.city = t3.address.city and t2.address.state = 'pc') and t4.address.state = 'pc'";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"HashJoin(.*[\n\r])+.*Scan.*indexName=i_state_city_dl(.*[\n\r])+.*RowKeyJoin(.*[\n\r])+.*RestrictedJsonTableGroupScan(.*[\n\r])+.*HashAgg\\(group=\\[\\{0\\}\\]\\)(.*[\n\r])+.*HashJoin"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;");
        }
    }

    @Ignore(value="Disable until DRILL-6453 is fixed")
    @Test
    public void testRowkeyJoinPushdown_13() throws Exception {
        String query = "select t1.id.ssn as ssn from hbase.`index_test_primary` t1 where _id in (select t2._id  from hbase.`index_test_primary` t2 where t2.address.city = 'pfrrs')";
        try {
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin"}, (String[])new String[0]);
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
            IndexPlanTest.test((String)"alter session set `planner.rowkeyjoin_conversion_selectivity_threshold` = 1.0;alter session set `planner.index.noncovering_selectivity_threshold` = 0.00001;alter session set `planner.rowkeyjoin_conversion_using_hashjoin` = true;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"HashJoin"}, (String[])new String[]{"RowKeyJoin"});
            IndexPlanTest.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100007423"}).baselineColumns(new String[]{"ssn"}).baselineValues(new Object[]{"100008861"}).go();
        }
        finally {
            IndexPlanTest.test((String)"alter session reset `planner.rowkeyjoin_conversion_selectivity_threshold`;alter session set `planner.index.noncovering_selectivity_threshold` = 0.025;alter session reset `planner.rowkeyjoin_conversion_using_hashjoin`");
        }
    }

    @Test
    public void TestIndexScanWithDescOrderByNullsFirst() throws Exception {
        String query = "select t.personal.age from hbase.`index_test_primary` t order by t.personal.age desc nulls first limit 1";
        try {
            IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.index.rowkeyjoin_cost_factor` = 0.01;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*indexName=i_age_desc.*"}, (String[])new String[0]);
        }
        finally {
            IndexPlanTest.test((String)defaultRowKeyJoinBackIOFactor);
        }
    }

    @Test
    public void TestIndexScanWithDescOrderByNullsLast() throws Exception {
        String query = "select t.personal.age from hbase.`index_test_primary` t order by t.personal.age desc nulls last limit 1";
        try {
            IndexPlanTest.test((String)"alter session reset `planner.enable_index_planning`;alter session set `planner.index.rowkeyjoin_cost_factor` = 0.01;");
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[0], (String[])new String[]{".*indexName=i_age_desc.*"});
        }
        finally {
            IndexPlanTest.test((String)defaultRowKeyJoinBackIOFactor);
        }
    }
}

