/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests;

import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.drill.maprdb.tests.binary.TestMapRDBFilterPushDown;
import com.mapr.drill.maprdb.tests.binary.TestMapRDBSimple;
import com.mapr.drill.maprdb.tests.json.TestScanRanges;
import com.mapr.drill.maprdb.tests.json.TestSimpleJson;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.hbase.HBaseTestsSuite;
import org.apache.drill.test.BaseTest;
import org.apache.hadoop.conf.Configuration;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={TestMapRDBSimple.class, TestMapRDBFilterPushDown.class, TestSimpleJson.class, TestScanRanges.class})
public class MaprDBTestsSuite
extends BaseTest {
    public static final int INDEX_FLUSH_TIMEOUT = 60000;
    private static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    private static volatile AtomicInteger initCount = new AtomicInteger(0);
    private static volatile Configuration conf;
    private static Admin admin;
    private static volatile boolean pluginsUpdated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @BeforeClass
    public static void setupTests() throws Exception {
        if (initCount.get() == 0) {
            Class<MaprDBTestsSuite> clazz = MaprDBTestsSuite.class;
            // MONITORENTER : com.mapr.drill.maprdb.tests.MaprDBTestsSuite.class
            if (initCount.get() == 0) {
                HBaseTestsSuite.configure((boolean)false, (boolean)true);
                HBaseTestsSuite.initCluster();
                Thread.sleep(5000L);
                admin = MapRDB.newAdmin();
                conf = HBaseTestsSuite.getConf();
                initCount.incrementAndGet();
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        initCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void cleanupTests() throws Exception {
        Class<MaprDBTestsSuite> clazz = MaprDBTestsSuite.class;
        synchronized (MaprDBTestsSuite.class) {
            if (initCount.decrementAndGet() == 0) {
                HBaseTestsSuite.tearDownCluster();
                admin.close();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration createPluginAndGetConf(DrillbitContext ctx) throws Exception {
        if (pluginsUpdated) return conf;
        Class<MaprDBTestsSuite> clazz = MaprDBTestsSuite.class;
        synchronized (MaprDBTestsSuite.class) {
            if (pluginsUpdated) return conf;
            StoragePluginRegistry pluginRegistry = ctx.getStorage();
            String pluginConfStr = "{  \"type\": \"file\",  \"enabled\": true,  \"connection\": \"maprfs:///\",  \"workspaces\": {    \"default\": {      \"location\": \"/tmp\",      \"writable\": false,      \"defaultInputFormat\": \"maprdb\"    },    \"tmp\": {      \"location\": \"/tmp\",      \"writable\": true,      \"defaultInputFormat\": \"parquet\"    },    \"root\": {      \"location\": \"/\",      \"writable\": false,      \"defaultInputFormat\": \"maprdb\"    }  },  \"formats\": {   \"maprdb\": {      \"type\": \"maprdb\",      \"allTextMode\": false,      \"readAllNumbersAsDouble\": false,      \"enablePushdown\": true    },   \"parquet\": {      \"type\": \"parquet\"    },   \"streams\": {      \"type\": \"streams\"    }  }}";
            FileSystemConfig pluginConfig = (FileSystemConfig)ctx.getLpPersistence().getMapper().readValue(pluginConfStr, FileSystemConfig.class);
            pluginRegistry.put("hbase", (StoragePluginConfig)pluginConfig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return conf;
        }
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static Admin getAdmin() {
        return admin;
    }

    public static InputStream getJsonStream(String resourceName) {
        return MaprDBTestsSuite.class.getResourceAsStream(resourceName);
    }
}

