/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.json;

import com.mapr.drill.maprdb.tests.MaprDBTestsSuite;
import java.util.List;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.test.BaseTestQuery;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class BaseJsonTest
extends BaseTestQuery {
    protected static final String SCHEMA = "hbase.root";

    protected String format(String sql) {
        return String.format(sql, SCHEMA, this.getTablePath());
    }

    protected String getTablePath() {
        throw new RuntimeException("unimplemented");
    }

    public static String format(String sql, String tablePath) {
        return String.format(sql, SCHEMA, tablePath);
    }

    @BeforeClass
    public static void setupDefaultTestCluster() throws Exception {
        BaseTestQuery.setupDefaultTestCluster();
        MaprDBTestsSuite.setupTests();
        MaprDBTestsSuite.createPluginAndGetConf(BaseJsonTest.getDrillbitContext());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        MaprDBTestsSuite.cleanupTests();
    }

    protected List<QueryDataBatch> runHBaseSQLlWithResults(String sql) throws Exception {
        return BaseJsonTest.testSqlWithResults((String)sql);
    }

    protected void runSQLAndVerifyCount(String sql, int expectedRowCount) throws Exception {
        List<QueryDataBatch> results = this.runHBaseSQLlWithResults(sql);
        this.logResultAndVerifyRowCount(results, expectedRowCount);
    }

    private void logResultAndVerifyRowCount(List<QueryDataBatch> results, int expectedRowCount) throws SchemaChangeException {
        int rowCount = this.logResult(results);
        if (expectedRowCount != -1) {
            Assert.assertEquals((long)expectedRowCount, (long)rowCount);
        }
    }
}

