/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;

public class LargeTableGenBase {
    private boolean dict_ready = false;
    protected List<String> firstnames;
    protected List<String> lastnames;
    protected List<String[]> cities;
    protected int[] randomized;

    protected synchronized void initDictionary() {
        this.initDictionaryWithRand();
    }

    protected void initDictionaryWithRand() {
        this.firstnames = new ArrayList<String>();
        this.lastnames = new ArrayList<String>();
        this.cities = new ArrayList<String[]>();
        ArrayList states = new ArrayList();
        int fnNum = 2000;
        int lnNum = 200000;
        int cityNum = 10000;
        int stateNum = 50;
        Random rand = new Random(2017L);
        try {
            int len;
            LinkedHashSet<String> strSet = new LinkedHashSet<String>();
            while (strSet.size() < stateNum) {
                strSet.add(RandomStringUtils.random((int)2, (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)rand));
            }
            states.addAll(strSet);
            strSet = new LinkedHashSet();
            while (strSet.size() < cityNum) {
                int len2 = 3 + strSet.size() % 6;
                strSet.add(RandomStringUtils.random((int)len2, (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)rand));
            }
            Iterator it = strSet.iterator();
            for (int i = 0; i < cityNum; ++i) {
                this.cities.add(new String[]{"10000", (String)states.get(i % stateNum), (String)it.next()});
            }
            strSet = new LinkedHashSet();
            while (strSet.size() < fnNum) {
                len = 3 + strSet.size() % 6;
                strSet.add(RandomStringUtils.random((int)len, (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)rand));
            }
            this.firstnames.addAll(strSet);
            strSet = new LinkedHashSet();
            while (strSet.size() < lnNum) {
                len = 3 + strSet.size() % 6;
                strSet.add(RandomStringUtils.random((int)len, (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)rand));
            }
            this.lastnames.addAll(strSet);
        }
        catch (Exception e) {
            System.out.println("init data got exception");
            e.printStackTrace();
        }
        this.dict_ready = true;
    }

    protected String getFirstName(int i) {
        return this.firstnames.get((this.randomized[i % this.randomized.length] + i) % this.firstnames.size());
    }

    protected String getLastName(int i) {
        return this.lastnames.get(this.randomized[(2 * i + this.randomized[i % this.randomized.length]) % this.randomized.length] % this.lastnames.size());
    }

    protected String[] getAddress(int i) {
        return this.cities.get(this.randomized[(i + this.randomized[i % this.randomized.length]) % this.randomized.length] % this.cities.size());
    }

    protected String getSSN(int i) {
        return String.format("%d", 100000000 + this.randomized[i % this.randomized.length]);
    }

    protected String getPhone(int i) {
        return String.format("%d", 6500000000L + (long)this.randomized[(this.randomized.length - i) % (int)((double)this.randomized.length * 0.8)]);
    }

    protected String getEmail(int i) {
        return this.getFirstName(i) + this.getLastName(i) + "@gmail.com";
    }

    protected String getAge(int i) {
        return String.format("%d", this.randomized[i % this.randomized.length] % 60 + 10);
    }

    protected String getIncome(int i) {
        return String.format("%d", this.randomized[i % this.randomized.length] % 47 + 1);
    }

    protected String getBirthdate(int i) {
        int thisseed = this.randomized[i % this.randomized.length];
        return String.format("%d-%02d-%02d", 2016 - (thisseed % 60 + 10), thisseed % 12 + 1, thisseed * 31 % 28 + 1);
    }

    protected String getFirstLogin(int i) {
        int thisseed = this.randomized[i % this.randomized.length];
        int nextseed = this.randomized[(i + 1) % this.randomized.length];
        return String.format("%d-%02d-%02d %02d:%02d:%02d.0", 2016 - thisseed % 7, thisseed * 31 % 12 + 1, thisseed % 28 + 1, nextseed % 24, nextseed % 60, nextseed * 47 % 60);
    }

    protected String getField(String field, int i) {
        if (field.equals("ssn")) {
            return this.getSSN(i);
        }
        if (field.equals("phone")) {
            return this.getPhone(i);
        }
        if (field.equals("email")) {
            return this.getEmail(i);
        }
        if (field.equals("city")) {
            return this.getAddress(i)[1];
        }
        if (field.equals("state")) {
            return this.getAddress(i)[0];
        }
        if (field.equals("fname")) {
            return this.getFirstName(i);
        }
        if (field.equals("lname")) {
            return this.getLastName(i);
        }
        return "";
    }

    protected void initRandVector(int recordNumber) {
        int i;
        Random rand = new Random(2016L);
        this.randomized = new int[recordNumber];
        for (i = 0; i < recordNumber; ++i) {
            this.randomized[i] = i;
        }
        for (i = 0; i < recordNumber; ++i) {
            int idx1 = rand.nextInt(recordNumber);
            int idx2 = rand.nextInt(recordNumber);
            int temp = this.randomized[idx1];
            this.randomized[idx1] = this.randomized[idx2];
            this.randomized[idx2] = temp;
        }
    }
}

