/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.json;

import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.drill.maprdb.tests.MaprDBTestsSuite;
import com.mapr.drill.maprdb.tests.json.BaseJsonTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.user.AwaitableUserResultsListener;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.test.BaseTestQuery;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestScanRanges
extends BaseJsonTest {
    private static final Logger logger = LoggerFactory.getLogger(TestScanRanges.class);
    private static final int TOTAL_ROW_COUNT = 1000000;
    private static final String TABLE_NAME = "large_table_TestScanRanges";
    private static final String JSON_FILE_URL = "/com/mapr/drill/json/business.json";
    private static boolean tableCreated = false;
    private static String tablePath;

    @Override
    protected String getTablePath() {
        return tablePath;
    }

    @BeforeClass
    public static void setup_TestSimpleJson() throws Exception {
        try (Table table = DBTests.createOrReplaceTable((String)TABLE_NAME, (boolean)false);
             InputStream in = MaprDBTestsSuite.getJsonStream(JSON_FILE_URL);
             DocumentStream stream = Json.newDocumentStream((InputStream)in);){
            tableCreated = true;
            tablePath = table.getPath().toUri().getPath();
            ArrayList docs = Lists.newArrayList((Iterable)stream);
            for (char ch = 'A'; ch <= 'T'; ch = (char)((char)(ch + 1))) {
                for (int rowIndex = 0; rowIndex < 5000; ++rowIndex) {
                    for (int i = 0; i < docs.size(); ++i) {
                        Document document = (Document)docs.get(i);
                        String id = String.format("%c%010d%03d", Character.valueOf(ch), rowIndex, i);
                        document.set("documentId", rowIndex);
                        table.insertOrReplace(id, document);
                    }
                }
            }
            table.flush();
            DBTests.waitForRowCount((Path)table.getPath(), (long)1000000L);
            TestScanRanges.setSessionOption((String)"planner.width.max_per_node", (long)5L);
        }
    }

    @AfterClass
    public static void cleanup_TestEncodedFieldPaths() throws Exception {
        if (tableCreated) {
            DBTests.deleteTables((String[])new String[]{TABLE_NAME});
        }
    }

    @Test
    public void test_scan_ranges() throws Exception {
        PersistentStore completed = TestScanRanges.getDrillbitContext().getProfileStoreContext().getCompletedProfileStore();
        this.setColumnWidths(new int[]{25, 40, 25, 45});
        String sql = this.format("SELECT\n  *\nFROM\n  %s.`%s` business");
        BaseTestQuery.SilentListener resultListener = new BaseTestQuery.SilentListener();
        AwaitableUserResultsListener listener = new AwaitableUserResultsListener((UserResultsListener)resultListener);
        TestScanRanges.testWithListener((UserBitShared.QueryType)UserBitShared.QueryType.SQL, (String)sql, (UserResultsListener)listener);
        listener.await();
        Assert.assertEquals((long)1000000L, (long)resultListener.getRowCount());
        String queryId = QueryIdHelper.getQueryId((UserBitShared.QueryId)resultListener.getQueryId());
        UserBitShared.QueryProfile profile = (UserBitShared.QueryProfile)completed.get(queryId);
        String profileString = String.valueOf(profile);
        logger.debug(profileString);
        Assert.assertNotNull((Object)profile);
        Assert.assertTrue((profile.getTotalFragments() >= 5 ? 1 : 0) != 0);
    }

    @Test
    public void test_scan_ranges_with_filter_on_id() throws Exception {
        this.setColumnWidths(new int[]{25, 25, 25});
        String sql = this.format("SELECT\n  _id, business_id, city\nFROM\n  %s.`%s` business\nWHERE\n _id > 'M' AND _id < 'Q'");
        BaseTestQuery.SilentListener resultListener = new BaseTestQuery.SilentListener();
        AwaitableUserResultsListener listener = new AwaitableUserResultsListener((UserResultsListener)resultListener);
        TestScanRanges.testWithListener((UserBitShared.QueryType)UserBitShared.QueryType.SQL, (String)sql, (UserResultsListener)listener);
        listener.await();
        Assert.assertEquals((long)200000L, (long)resultListener.getRowCount());
    }

    @Test
    public void test_scan_ranges_with_filter_on_non_id_field() throws Exception {
        this.setColumnWidths(new int[]{25, 25, 25});
        String sql = this.format("SELECT\n  _id, business_id, documentId\nFROM\n  %s.`%s` business\nWHERE\n documentId >= 100 AND documentId < 150");
        BaseTestQuery.SilentListener resultListener = new BaseTestQuery.SilentListener();
        AwaitableUserResultsListener listener = new AwaitableUserResultsListener((UserResultsListener)resultListener);
        TestScanRanges.testWithListener((UserBitShared.QueryType)UserBitShared.QueryType.SQL, (String)sql, (UserResultsListener)listener);
        listener.await();
        Assert.assertEquals((long)10000L, (long)resultListener.getRowCount());
    }
}

