/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.index;

import com.mapr.db.Admin;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.drill.maprdb.tests.MaprDBTestsSuite;
import com.mapr.drill.maprdb.tests.index.LargeTableGen;
import com.mapr.drill.maprdb.tests.json.BaseJsonTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.InputStream;
import java.util.Properties;
import org.apache.drill.PlanTestBase;
import org.apache.drill.common.config.DrillConfig;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.json.Json;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@Category(value={ClusterTest.class})
public class TestComplexTypeIndex
extends BaseJsonTest {
    private static final String TABLE_NAME = "/tmp/index_test_complex1";
    private static final String TABLE_NAME_1 = "/tmp/index_test_complex_without_index";
    private static final String JSON_FILE_URL = "/com/mapr/drill/json/complex_sample1.json";
    private static final String semiColon = ";";
    private static boolean tableCreated = false;
    private static String tablePath;
    private static final String sliceTargetSmall = "alter session set `planner.slice_target` = 1";
    private static final String disableRowKeyJoinConversion = "alter session set planner.`enable_rowkeyjoin_conversion` = false";
    public static final String maxNonCoveringSelectivityThreshold = "alter session set `planner.index.noncovering_selectivity_threshold` = 1.0";
    public static final String resetmaxNonCoveringSelectivityThreshold = "alter session reset `planner.index.noncovering_selectivity_threshold`";
    public static final String noIndexPlan = "alter session set `planner.enable_index_planning` = false";
    public static final String IndexPlanning = "alter session set `planner.enable_index_planning` = true";
    public static final String ComplexFTSTypePlanning = "alter session set `planner.enable_complex_type_fts` = true";
    public static final String DisableComplexFTSTypePlanning = "alter session set `planner.enable_complex_type_fts` = false";
    public static final String ResetComplexFTSTypePlanning = "alter session reset `planner.enable_complex_type_fts`";
    public static final String disableHashAgg = "alter session set `planner.enable_hashagg` = false";
    public static final String disableStreamAgg = "alter session set `planner.enable_streamagg` = false";
    public static final String enableHashAgg = "alter session set `planner.enable_hashagg` = true";
    public static final String enableStreamAgg = "alter session set `planner.enable_streamagg` = true";
    public static final String optionsForBaseLine = "alter session set `planner.enable_index_planning` = false;alter session set `planner.enable_complex_type_fts` = false";
    public static final String maxNonCoveringIndexPlan = "alter session set `planner.index.noncovering_selectivity_threshold` = 1.0;alter session set `planner.enable_index_planning` = true";

    @Override
    protected String getTablePath() {
        return tablePath;
    }

    @BeforeClass
    public static void setupTestComplexTypeIndex() throws Exception {
        Properties overrideProps = new Properties();
        overrideProps.setProperty("format-maprdb.json.useNumRegionsForDistribution", "true");
        TestComplexTypeIndex.updateTestCluster((int)1, (DrillConfig)DrillConfig.create((Properties)overrideProps));
        MaprDBTestsSuite.setupTests();
        MaprDBTestsSuite.createPluginAndGetConf(TestComplexTypeIndex.getDrillbitContext());
        tablePath = TestComplexTypeIndex.createTableAndIndex(TABLE_NAME, true, JSON_FILE_URL);
        TestComplexTypeIndex.createTableAndIndex(TABLE_NAME_1, false, JSON_FILE_URL);
        System.out.println("waiting for indexes to sync....");
        Thread.sleep(60000L);
        TestComplexTypeIndex.test((String)sliceTargetSmall);
        TestComplexTypeIndex.test((String)disableRowKeyJoinConversion);
    }

    private static String createTableAndIndex(String tableName, boolean createIndex, String fileName) throws Exception {
        String tablePath;
        String[] indexList = new String[]{"weightIdx1", "weight[].low, weight[].high, weight[].average", "", "weightCountyIdx1", "weight[].high", "county,salary.max", "salaryWeightIdx1", "salary.max,weight[].high", "salary.min,weight[].low,weight[].high", "carsIdx1", "cars[]", "name", "carsWeightIdx1", "cars[]", "weight[].low", "salaryIdx", "salary", "", "weightListIdx", "weight", "", "weightComplexIdx1", "weight[].low", "salary,friends,cars,zipcodes", "ordersProductsIdx1", "orders[].products[].price, orders[].products[].prodname", "", "carsWeightIdx2", "cars[]", "weight[].high,weight[].average"};
        try (Table table = TestComplexTypeIndex.createOrReplaceTable(tableName);
             InputStream in = MaprDBTestsSuite.getJsonStream(fileName);
             DocumentStream stream = Json.newDocumentStream((InputStream)in);){
            tableCreated = true;
            tablePath = table.getPath().toUri().getPath();
            System.out.println(String.format("Created table %s", tablePath));
            if (createIndex) {
                TestComplexTypeIndex.createIndexes(table, indexList);
                DBTests.setTableStatsSendInterval((long)1L);
            }
            for (Document document : stream) {
                table.insert(document, "user_id");
            }
            table.flush();
            System.out.println("Inserted documents. Waiting for indexes to be updated..");
            if (createIndex) {
                DBTests.waitForIndexFlush((Path)table.getPath(), (long)60000L);
            }
            System.out.println("Finished waiting for index updates.");
        }
        return tablePath;
    }

    private static Table createOrReplaceTable(String tableName) {
        Admin admin = MaprDBTestsSuite.getAdmin();
        if (admin != null && admin.tableExists(tableName)) {
            admin.deleteTable(tableName);
        }
        TableDescriptorImpl desc = new TableDescriptorImpl(new Path(tableName));
        return admin.createTable((TableDescriptor)desc);
    }

    private static void createIndexes(Table table, String[] indexList) throws Exception {
        LargeTableGen gen = new LargeTableGen(MaprDBTestsSuite.getAdmin());
        System.out.println("Creating indexes..");
        gen.createIndex(table, indexList);
    }

    @AfterClass
    public static void cleanupTestComplexTypeIndex() throws Exception {
        Admin admin;
        if (tableCreated && (admin = MaprDBTestsSuite.getAdmin()) != null) {
            if (admin.tableExists(TABLE_NAME)) {
                admin.deleteTable(TABLE_NAME);
            }
            if (admin.tableExists(TABLE_NAME_1)) {
                admin.deleteTable(TABLE_NAME_1);
            }
        }
    }

    @Test
    public void SemiJoinNonCoveringWithRangeCondition() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "SELECT _id from hbase.`index_test_complex1` where _id in  (select _id from (select _id, flatten(weight) as f from hbase.`index_test_complex1`) as t  where t.f.low > 120 and t.f.high < 200) ";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*>.*120.*indexName=weightIdx1"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void SemiJoinWithEqualityConditionOnOuterTable() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t where t.f.low <= 200)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*<=.*200.*indexName=(weightIdx1|weightCountyIdx1)"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void SemiJoinWithSubqueryConditionOnITEMField() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = " select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 where t1.`salary`.`max` > 10) as t where t.f.high <= 200)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*<=.*200.*indexName=(salaryWeightIdx1|weightCountyIdx1)"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void testCoveringIndexWithPredOnIncludedField() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            String query = "select _id from hbase.`index_test_complex1`where _id in (select _id from (select _id from (select _id, county, flatten(weight) as f from hbase.`index_test_complex1` as t1 where t1.`county` = 'Santa Clara') as t where t.f.high > 10))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*>.*10.*indexName=weightCountyIdx1"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void testCoveringIndexWithPredOnITEMIncludedField() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1`where _id in (select _id from (select _id from (select _id, county, flatten(weight) as f from hbase.`index_test_complex1` as t1 where t1.`salary`.`max` > 100) as t where t.f.high > 10))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*>.*10.*indexName=weightCountyIdx1"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void SemiJoinWithInnerTableConditionOnArrayAndNonArrayField() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = "select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f, t1.`salary`.`min` as minimum_salary from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200 and t2.minimum_salary >= 0) and t.`county` = 'Santa Clara'";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*200.*indexName=(weightIdx1|weightComplexIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void SemiJoinWithStarOnOuterTable() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = "select * from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f, t1.`salary`.`min` as minimum_salary from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200 and t2.minimum_salary >= 0)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*columns=.*`\\*\\*`.*", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*200.*indexName=(weightIdx1|weightComplexIdx1)"}, (String[])new String[0]);
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void SemiJoinCoveringIndexPlan() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200 )";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*200.*indexName=(weightIdx1|weightComplexIdx1)"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*columns=.*`\\*\\*`.*"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void SemiJoinWithStarAndid() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = "select * from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200 ) and t.`county` = 'Santa Clara'";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*columns=.*`\\*\\*`.*", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*200.*indexName=(weightIdx1|weightComplexIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void SemiJoinWithFlattenOnLeftSide_1() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = "select _id, t1.`f`.`low` from (select _id, flatten(t.weight) f from hbase.`index_test_complex1` t) as t1 where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*200.*indexName=(weightIdx1|weightComplexIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Ignore
    @Test
    public void SemiJoinWithFlattenOnLeftSide_2() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = "select _id, flatten(t.weight) f from hbase.`index_test_complex1` as t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*200.*indexName=weightIdx1"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Ignore(value="Temporarily ignored")
    @Test
    public void SemiJoinWithTwoDifferentTables() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = "select _id, flatten(t.weight) f from hbase.`index_test_complex_without_index` as t where _id in (select _id from (select _id, flatten(t1.weight) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f.low <= 200)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex_without_index,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex_without_index,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.low.*<=.*200.*indexName=weightIdx1"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void SemiJoinCoveringIndexScalarArray_1() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.cars) as f from hbase.`index_test_complex1` as t1 ) as t2 where t2.f like 'Toyota%' )";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*cars.*MATCHES.*Toyota.*indexName=carsIdx1"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*columns=.*`\\*\\*`.*"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestEqualityForMap() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = " select t.salary from hbase.`index_test_complex1` as t where t.salary = cast('{\"min\":1000.0, \"max\":2000.0}' as VARBINARY)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*salary.*min.*1000.*max.*2000.*indexName=salaryIdx"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,"});
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestEqualityForList() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = " select t.weight from hbase.`index_test_complex1` as t where t.weight = cast('[{\"average\":135, \"high\":150, \"low\":120},{\"average\":130, \"high\":145, \"low\":110}]' as VARBINARY)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*average.*135.*high.*150.*low.*120.*average.*130.*high.*145.*low.*110.*indexName=weightListIdx"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,"});
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestEqualityForMapWithConjunction() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = " select t.salary from hbase.`index_test_complex1` as t where t.salary = cast('{\"min\":1000.0, \"max\":2000.0}' as VARBINARY) and t.county='Santa Clara'";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*salary.*min.*1000.*max.*2000.*indexName=salaryIdx"}, (String[])new String[0]);
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestEqualityForListWithConjunction() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = "select t.weight from hbase.`index_test_complex1` as t where t.weight = cast('[{\"average\":135, \"high\":150, \"low\":120},{\"average\":130, \"high\":145, \"low\":110}]' as VARBINARY) and t.`_id`='user001' ";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*average.*135.*high.*150.*low.*120.*average.*130.*high.*145.*low.*110.*indexName=weightListIdx"}, (String[])new String[0]);
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestMultiFlattens_1() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = "select t._id from hbase.`index_test_complex1` as t  where _id in (select _id from (select _id, flatten(t1.weight) as f1, flatten(t1.weight) as f2 from hbase.`index_test_complex1` as t1) as t2   where t2.f1.low = 150 and t2.f2.high = 165) ";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*.high.*=.*165", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=(.*weight.*.low.*=.*150.*|.*weight.*.high.*=.*165.*)indexName=(weightIdx1|weightCountyIdx1)"}, (String[])new String[]{".*condition=.*weight.*.low.*=.*150.*weight.*.high.*=.*165.*indexName=weightIdx1"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
        }
    }

    @Test
    public void testCoveringIndexWithStreamAgg() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)disableHashAgg);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1`where _id in (select _id from (select _id from (select _id, county, flatten(weight) as f from hbase.`index_test_complex1` as t1 where t1.`county` = 'Santa Clara') as t where t.f.high > 10))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*>.*10.*indexName=weightCountyIdx1"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", "HashAgg"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)enableHashAgg);
        }
    }

    @Ignore(value="Ignore until MD-3762 is fixed")
    @Test
    public void testCoveringIndexWithHashAgg() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)disableStreamAgg);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1`where _id in (select _id from (select _id from (select _id, county, flatten(weight) as f from hbase.`index_test_complex1` as t1 where t1.`county` = 'Santa Clara') as t where t.f.high > 10))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*>.*10.*indexName=weightCountyIdx1"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", "StreamAgg"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)enableStreamAgg);
        }
    }

    @Test
    public void testCoveringIndexWithComplexIncludedField() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)disableHashAgg);
            TestComplexTypeIndex.test((String)enableStreamAgg);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id, salary, friends, cars, zipcodes from hbase.`index_test_complex1` where _id in (select _id from (select _id, flatten(weight) as f from hbase.`index_test_complex1`) as t1 where t1.f.low < 140)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*StreamAgg.*ANY_VALUE-SEMI-JOIN0.*ANY_VALUE-SEMI-JOIN1.*ANY_VALUE-SEMI-JOIN2.*", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*<.*140.*indexName=weightComplexIdx1"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)enableHashAgg);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestElementAnd() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(weight) as f1 from  hbase.`index_test_complex1`) as t where t.f1.low = 150 and t.f1.high = 180)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*150.*high.*180.*indexName=weightIdx1"}, (String[])new String[]{".*elementAnd"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestMultipleElementAnd() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(weight) as f1 from  hbase.`index_test_complex1`) as t where t.f1.low = 150 and t.f1.high = 180 and t.f1.`average` = 170)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*150.*high.*180.*average.*170.*indexName=weightIdx1"}, (String[])new String[]{".*elementAnd"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestElementAndWithScalar() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1, t1.`salary`.`max` as maxsal from  hbase.`index_test_complex1` as t1) as t where  t.f1.low = 150  and maxsal = 5000 and t.f1.average = 170 and t.f1.high = 180 )";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*RestrictedJsonTableGroupScan.*condition=.*elementAnd.*weight.*low.*150.*average.*170.*high.*180", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*150.*high.*180.*average.*170.*indexName=weightIdx1"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestElementAndWithIn() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1 from  hbase.`index_test_complex1` as t1) as t where t.f1.low in \n          (120,150,170) and t.f1.high in (170,180,190))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*120.*low.*150.*low.*170.*and.*high.*170.*high.*180.*high.*190.*indexName=weightIdx1"}, (String[])new String[]{".*elementAnd"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestElementAndWithOr() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1, t1.`salary`.`max` as maxsal from  hbase.`index_test_complex1` as t1) as t where (t.f1.low = 120 or maxsal = 2000) and t.f1.average = 135 and t.f1.high = 150)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*elementAnd.*weight.*average.*135.*high.*150.*weight.*low.*120"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Ignore
    @Test
    public void TestComplexNestedConditions() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1 , t1.`salary`.`max` as maxsal from hbase.`index_test_complex1` as t1 ) as t where t.f1.low = 150 and ((t.f1.high = 150 and t.f1.low = 120 ) or (t.f1.low = 150 and t.f1.high = 180)))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*high.*150.*low.*120.*weight.*low.*150.*high.*180"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestInWithAnd() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.cars) as f1, t1.`salary`.`max` as maxsal from hbase.`index_test_complex1` as t1 ) as t where t.f1 IN ('Toyota Camry', 'BMW') and t.maxsal > 2000)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*cars.*Toyota Camry.*cars.*BMW.*indexName.*carsIdx1"}, (String[])new String[]{"UnionExchange"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
        }
    }

    @Test
    public void TestInWithElementAnd() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.cars) as f1 from hbase.`index_test_complex1`as t1 ) as t where t.f1 IN ('Toyota Camry', 'BMW') and t.f1 IN ('Honda Accord', 'Toyota Camry'))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*cars.*Toyota Camry.*or.*BMW.*and.*Honda Accord.*or.*Toyota Camry.*indexName.*(carsIdx1|carsWeightIdx1|carsWeightIdx2)"}, (String[])new String[]{".*elementAnd"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
        }
    }

    @Test
    public void TestAndWithElementAnd() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1, flatten(t1.weight) as f2 from  hbase.`index_test_complex1` as t1) as t where  t.f1.low = 120  and t.f2.high = 145 and t.f1.high = 150)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*RestrictedJsonTableGroupScan.*condition=.*elementAnd.*weight.*low.*120.*high.*150", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=(.*weight.*low.*120.*high.*150.*|.*weight.*high.*145).*indexName=(weightIdx|weightCountyIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
        }
    }

    @Test
    public void TestMultipleFlattens_2() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1, flatten(t1.weight) as f2, flatten(t1.weight) as f3 from  hbase.`index_test_complex1` as t1) as t where  t.f1.low = 120  and t.f2.high = 145 and t.f3.average = 135)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=(.*weight.*low.*120.*|.*weight.*high.*145.*|.*weight.*average.*135).*indexName=(weightIdx|weightCountyIdx1)"}, (String[])new String[]{".*condition=.*elementAnd"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
        }
    }

    @Test
    public void TestAndWithIn() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(t1.weight) as f1 , flatten(weight) as f2 from  hbase.`index_test_complex1` as t1) as t where t.f1.low in \n          (120,150,170) and t.f2.high in (170,180,190))";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=(.*weight.*low.*120.*weight.*low.*150.*weight.*low.*170.*|.*weight.*high.*170.*weight.*high.*180.*weight.*high.*190).*indexName=(weightIdx1|weightCountyIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
        }
    }

    @Test
    public void testNestedFlattenCovering_1() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from  (select _id, flatten(t1.`f1`.`products`) as f2 from (select _id, flatten(orders) as f1 from hbase.`index_test_complex1`) as t1) as t2  where t2.`f2`.`price` > 50)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*orders.*products.*price.*50.*indexName=(ordersProductsIdx1)"}, (String[])new String[]{"RowKeyJoin"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(IndexPlanning).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void testNestedFlattenNonCovering_1() throws Exception {
        try {
            String query = "select _id, name, county from hbase.`index_test_complex1` where _id in (select _id from  (select _id, flatten(t1.`f1`.`products`) as f2 from (select _id, flatten(orders) as f1 from hbase.`index_test_complex1`) as t1) as t2  where t2.`f2`.`price` > 50)";
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*orders.*.products.*price.*50.*indexName=(ordersProductsIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringIndexPlan).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void testNestedFlattenWithElementAnd() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from  (select _id, flatten(t1.`f1`.`products`) as f2 from (select _id, flatten(orders) as f1 from hbase.`index_test_complex1`) as t1) as t2  where t2.`f2`.`price` > 50 and t2.`f2`.`prodname` like '%bike%')";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*orders.*products.*price.*50.*and.*orders.*products.*prodname.*bike.*indexName=(ordersProductsIdx1)"}, (String[])new String[]{"RowKeyJoin"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(IndexPlanning).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void testNestedFlattenElementAndWithNonCovering() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id, county from hbase.`index_test_complex1` where _id in (select _id from  (select _id, flatten(t1.`f1`.`products`) as f2 from (select _id, flatten(orders) as f1 from hbase.`index_test_complex1`) as t1) as t2  where t2.`f2`.`price` > 50 and t2.`f2`.`prodname` like '%bike%')";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*orders.*products.*price.*50.*and.*orders.*products.*prodname.*bike.*indexName=(ordersProductsIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringIndexPlan).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
        }
    }

    @Test
    public void testNestedFlattenNonCovering_2() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select * from hbase.`index_test_complex1` where _id in (select _id from  (select _id, flatten(t1.`f1`.`products`) as f2 from (select _id, flatten(orders) as f1 from hbase.`index_test_complex1`) as t1) as t2  where t2.`f2`.`price` > 50)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*orders.*.products.*price.*50.*indexName=(ordersProductsIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringIndexPlan).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestElementAndwithNoResults() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id, county from hbase.`index_test_complex1` where _id in (select _id from ( select _id, flatten(weight) as f1 from  hbase.`index_test_complex1`) as t where t.f1.low = 175 and t.f1.high = 180)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*175.*high.*180.*indexName=weightIdx1"}, (String[])new String[]{".*elementAnd"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringSelectivityThreshold).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestExpressionSimplificationOnMergeRKJ() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "SELECT T2.name, T2.W_O.low FROM ( SELECT name, FLATTEN(weight) W_O FROM hbase.`index_test_complex1` WHERE _id IN ( SELECT _id FROM ( SELECT C._id, FLATTEN(weight) W_O, C.`salary.max` as max_salary FROM hbase.`index_test_complex1` C WHERE max_salary > 5 AND max_salary < 1000 ) T WHERE T.W_O.low = 200 ) ) T2 WHERE T2.W_O.low = 200";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight.*low.*=.*200.*"}, (String[])new String[]{".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*weight0.*low.*=.*200.*"});
        }
        finally {
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestCoveringMultiFlattenDifferentArrays() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` t where _id in  (select _id from (select _id, flatten(t1.cars) as f1, flatten(weight) as f2 from hbase.`index_test_complex1` as t1 ) as t2    where t2.f1 like 'Toyota%' and t2.f2.low = 200) ";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*cars.*MATCHES.*Toyota.*weight.*low.*=.*200.*indexName=carsWeightIdx1"}, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestElementAndwithIncludedFields() throws Exception {
        try {
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from (select _id, flatten(t1.cars) as f1, flatten(weight) as f2 from hbase.`index_test_complex1` as t1 ) as t2 where t2.f1 like 'Toyota%' and t2.f2.high = 150 and t2.f2.average = 135)";
            TestComplexTypeIndex.test((String)IndexPlanning);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*elementAnd.*weight.*high.*150.*average.*135.*cars.*MATCHES.*Toyota.*indexName=carsWeightIdx2"}, (String[])new String[]{"RowKeyJoin"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(IndexPlanning).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void TestNonCoveringMultiFlattenSameArray() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            String query = "select _id from hbase.`index_test_complex1` t where _id in (select _id from (select _id, flatten(t1.cars) as f1, flatten(weight) as f2 ,flatten(weight) as f3 from hbase.`index_test_complex1` as t1 ) as t2 where t2.f1 like 'Toyota%' and t2.f2.average = 120 and t2.f3.high = 150)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{"RowKeyJoin", ".*RestrictedJsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*cars.*MATCHES.*Toyota.*weight.*average.*120.*weight.*high.*150", ".*JsonTableGroupScan.*tableName=.*index_test_complex1,(.*condition=.*weight.*high.*150.*indexName=weightCountyIdx1|.*condition=.*cars.*MATCHES.*Toyota.*indexName=carsIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForBaseline(noIndexPlan).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }

    @Test
    public void testNestedFlattenAndWithCovering() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from  (select _id, flatten(t1.`f1`.`products`) as f3, flatten(t1.`f2`.products) as f4 from (select _id, flatten(orders) as f1, flatten(orders) as f2 from hbase.`index_test_complex1`) as t1) as t2  where t2.`f3`.`price` = 50 and t2.`f4`.`prodname` like '%chair%')";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*orders.*products.*price.*50.*indexName=(ordersProductsIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringIndexPlan).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
        }
    }

    @Test
    public void testNestedFlattenAndWithNonCovering() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id, county from hbase.`index_test_complex1` where _id in (select _id from  (select _id, flatten(t1.`f1`.`products`) as f3, flatten(t1.`f2`.products) as f4 from (select _id, flatten(orders) as f1, flatten(orders) as f2 from hbase.`index_test_complex1`) as t1) as t2  where t2.`f3`.`price` = 50 and t2.`f4`.`prodname` like '%chair%')";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=.*orders.*products.*price.*50.*indexName=(ordersProductsIdx1)"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringIndexPlan).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
        }
    }

    @Test
    public void testNestedFlattenAndWithNonCovering_1() throws Exception {
        try {
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)maxNonCoveringSelectivityThreshold);
            TestComplexTypeIndex.test((String)DisableComplexFTSTypePlanning);
            String query = "select _id from hbase.`index_test_complex1` where _id in (select _id from (select _id, flatten(t1.`f1`.`products`) as f2, t1.`f3` as f4 from (select _id, flatten(orders) as f1, flatten(weight) as f3 from hbase.`index_test_complex1`) as t1) as t2 where t2.`f2`.`price` = 50 and t2.`f2`.`prodname`= 'chair' and t2.`f4`.`low` = 120 and t2.`f4`.high = 150)";
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*indexName=(ordersProductsIdx1|weightIdx1)", "RowKeyJoin"}, (String[])new String[0]);
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(maxNonCoveringIndexPlan).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)ResetComplexFTSTypePlanning);
            TestComplexTypeIndex.test((String)IndexPlanning);
            TestComplexTypeIndex.test((String)resetmaxNonCoveringSelectivityThreshold);
        }
    }

    @Test
    public void TestNoFilterPushDownWithNonSemiJoin() throws Exception {
        try {
            String query = "select _id from (select _id, flatten(t1.cars) as f1 from hbase.`index_test_complex1` as t1 ) as t2 where t2.f1 like 'Toyota%'";
            TestComplexTypeIndex.test((String)IndexPlanning);
            PlanTestBase.testPlanMatchingPatterns((String)query, (String[])new String[]{".*JsonTableGroupScan.*tableName=.*index_test_complex1,.*condition=null.*"}, (String[])new String[]{".*indexName=.*"});
            TestComplexTypeIndex.testBuilder().optionSettingQueriesForTestQuery(IndexPlanning).optionSettingQueriesForBaseline(optionsForBaseLine).unOrdered().sqlQuery(query).sqlBaselineQuery((Object)query).build().run();
        }
        finally {
            TestComplexTypeIndex.test((String)IndexPlanning);
        }
    }
}

