/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.drill.maprdb.tests.index;

import com.mapr.db.Admin;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.drill.maprdb.tests.index.LargeTableGenBase;
import com.mapr.fs.utils.ssh.TestCluster;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.apache.hadoop.fs.Path;
import org.ojai.DocumentStream;
import org.ojai.json.Json;

public class LargeTableGen
extends LargeTableGenBase {
    static final int SPLIT_SIZE = 5000;
    private Admin admin;

    public LargeTableGen(Admin dbadmin) {
        this.admin = dbadmin;
    }

    Table createOrGetTable(String tableName, int recordNum) {
        if (this.admin.tableExists(tableName)) {
            return MapRDBImpl.getTable((String)tableName);
        }
        TableDescriptorImpl desc = new TableDescriptorImpl(new Path(tableName));
        int splits = recordNum / 5000 - (recordNum % 5000 > 1 ? 0 : 1);
        String[] splitsStr = new String[splits];
        StringBuilder strBuilder = new StringBuilder("Splits:");
        for (int i = 0; i < splits; ++i) {
            splitsStr[i] = String.format("%d", (i + 1) * 5000);
            strBuilder.append(splitsStr[i] + ", ");
        }
        System.out.print(strBuilder.toString());
        return this.admin.createTable((TableDescriptor)desc, splitsStr);
    }

    public void createIndex(Table table, String[] indexDef) throws Exception {
        if (indexDef == null) {
            return;
        }
        for (int i = 0; i < indexDef.length / 3; ++i) {
            String indexCmd = String.format("maprcli table index add -path " + table.getPath() + " -index %s -indexedfields '%s'" + (indexDef[3 * i + 2].length() == 0 ? "" : " -includedfields '%s'") + (indexDef[3 * i].startsWith("hash") ? " -hashed true" : ""), this.indexDefInCommand(indexDef[3 * i]), this.indexDefInCommand(indexDef[3 * i + 1]), this.indexDefInCommand(indexDef[3 * i + 2]));
            System.out.println(indexCmd);
            TestCluster.runCommand((String)indexCmd);
            DBTests.admin().getTableIndexes(table.getPath(), true);
        }
    }

    private String indexDefInCommand(String def) {
        String[] splitted = def.split(",");
        StringBuffer ret = new StringBuffer();
        for (String field : splitted) {
            if (ret.length() == 0) {
                ret.append(field);
                continue;
            }
            ret.append(",").append(field);
        }
        return ret.toString();
    }

    public void generateTableWithIndex(String tablePath, int recordNumber, String[] indexDef) throws Exception {
        this.initRandVector(recordNumber);
        this.initDictionary();
        DBTests.setTableStatsSendInterval((long)1L);
        if (this.admin.tableExists(tablePath)) {
            // empty if block
        }
        int BATCH_SIZE = 2000;
        try (Table table = this.createOrGetTable(tablePath, recordNumber);){
            this.createIndex(table, indexDef);
            for (int batch = 0; batch < recordNumber; batch += BATCH_SIZE) {
                int batchStop = Math.min(recordNumber, batch + BATCH_SIZE);
                StringBuffer strBuf = new StringBuffer();
                for (int i = batch; i < batchStop; ++i) {
                    strBuf.append(String.format("{\"rowid\": \"%d\", \"reverseid\": \"%d\", \"id\": {\"ssn\": \"%s\"}, \"contact\": {\"phone\": \"%s\", \"email\": \"%s\"},\"address\": {\"city\": \"%s\", \"state\": \"%s\"}, \"name\": { \"fname\": \"%s\", \"lname\": \"%s\" },\"personal\": {\"age\" : %s, \"income\": %s, \"birthdate\": {\"$dateDay\": \"%s\"} },\"activity\": {\"irs\" : { \"firstlogin\":  \"%s\" } },\"driverlicense\":{\"$numberLong\": %s} } \n", i + 1, recordNumber - i, this.getSSN(i), this.getPhone(i), this.getEmail(i), this.getAddress(i)[2], this.getAddress(i)[1], this.getFirstName(i), this.getLastName(i), this.getAge(i), this.getIncome(i), this.getBirthdate(i), this.getFirstLogin(i), this.getSSN(i)));
                }
                try (StringBufferInputStream in = new StringBufferInputStream(strBuf.toString());
                     DocumentStream stream = Json.newDocumentStream((InputStream)in);){
                    try {
                        table.insert(stream, "rowid");
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(stream.toString());
                        throw e;
                    }
                }
            }
            table.flush();
            DBTests.waitForIndexFlush((Path)table.getPath(), (long)60000L);
            Thread.sleep(200000L);
        }
    }
}

