/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ltsv;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLTSVQueries
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        TestLTSVQueries.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
    }

    @Test
    public void testWildcard() throws Exception {
        String sql = "SELECT * FROM cp.`simple.ltsv`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("referer", TypeProtos.MinorType.VARCHAR).addNullable("vhost", TypeProtos.MinorType.VARCHAR).addNullable("size", TypeProtos.MinorType.VARCHAR).addNullable("forwardedfor", TypeProtos.MinorType.VARCHAR).addNullable("reqtime", TypeProtos.MinorType.VARCHAR).addNullable("apptime", TypeProtos.MinorType.VARCHAR).addNullable("host", TypeProtos.MinorType.VARCHAR).addNullable("ua", TypeProtos.MinorType.VARCHAR).addNullable("req", TypeProtos.MinorType.VARCHAR).addNullable("status", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"-", "api.example.com", "4968", "-", "2.532", "2.532", "xxx.xxx.xxx.xxx", "Java/1.8.0_131", "GET /v1/xxx HTTP/1.1", "200"}).addRow(new Object[]{"-", "api.example.com", "412", "-", "3.580", "3.580", "xxx.xxx.xxx.xxx", "Java/1.8.0_201", "GET /v1/yyy HTTP/1.1", "200"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSelectColumns() throws Exception {
        String sql = "SELECT ua, reqtime FROM cp.`simple.ltsv`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("ua", TypeProtos.MinorType.VARCHAR).addNullable("reqtime", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"Java/1.8.0_131", "2.532"}).addRow(new Object[]{"Java/1.8.0_201", "3.580"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testQueryWithConditions() throws Exception {
        String sql = "SELECT * FROM cp.`simple.ltsv` WHERE reqtime > 3.0";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("referer", TypeProtos.MinorType.VARCHAR).addNullable("vhost", TypeProtos.MinorType.VARCHAR).addNullable("size", TypeProtos.MinorType.VARCHAR).addNullable("forwardedfor", TypeProtos.MinorType.VARCHAR).addNullable("reqtime", TypeProtos.MinorType.VARCHAR).addNullable("apptime", TypeProtos.MinorType.VARCHAR).addNullable("host", TypeProtos.MinorType.VARCHAR).addNullable("ua", TypeProtos.MinorType.VARCHAR).addNullable("req", TypeProtos.MinorType.VARCHAR).addNullable("status", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"-", "api.example.com", "412", "-", "3.580", "3.580", "xxx.xxx.xxx.xxx", "Java/1.8.0_201", "GET /v1/yyy HTTP/1.1", "200"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "SELECT COUNT(*) as cnt FROM cp.`simple.ltsv` ";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)2L, (long)cnt);
    }

    @Test
    public void testSkipEmptyLines() throws Exception {
        Assert.assertEquals((long)2L, (long)this.queryBuilder().sql("SELECT * FROM cp.`emptylines.ltsv`").run().recordCount());
    }

    @Test
    public void testReadException() throws Exception {
        try {
            TestLTSVQueries.run((String)"SELECT * FROM table(cp.`invalid.ltsv` (type => 'ltsv', parseMode => 'strict'))", (Object[])new Object[0]);
            Assert.fail();
        }
        catch (UserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("DATA_READ ERROR: Empty key detected at line [0] position [49]"));
        }
    }

    @Test
    public void testProvidedSchema() throws Exception {
        String sql = "SELECT * FROM table(cp.`simple.ltsv` (type=> 'ltsv', schema => 'inline=(`referer` VARCHAR, `vhost` VARCHAR, `size` INT, `forwardedfor` VARCHAR, `reqtime` DOUBLE, `apptime` DOUBLE, `status` INT)'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("referer", TypeProtos.MinorType.VARCHAR).addNullable("vhost", TypeProtos.MinorType.VARCHAR).addNullable("size", TypeProtos.MinorType.INT).addNullable("forwardedfor", TypeProtos.MinorType.VARCHAR).addNullable("reqtime", TypeProtos.MinorType.FLOAT8).addNullable("apptime", TypeProtos.MinorType.FLOAT8).addNullable("status", TypeProtos.MinorType.INT).addNullable("host", TypeProtos.MinorType.VARCHAR).addNullable("ua", TypeProtos.MinorType.VARCHAR).addNullable("req", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"-", "api.example.com", 4968, "-", 2.532, 2.532, 200, "xxx.xxx.xxx.xxx", "Java/1.8.0_131", "GET /v1/xxx HTTP/1.1"}).addRow(new Object[]{"-", "api.example.com", 412, "-", 3.58, 3.58, 200, "xxx.xxx.xxx.xxx", "Java/1.8.0_201", "GET /v1/yyy HTTP/1.1"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }
}

