/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ltsv;

import java.util.HashMap;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.ltsv.LTSVFormatPluginConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLTSVRecordReader
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        TestLTSVRecordReader.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        DrillbitContext context = cluster.drillbit().getContext();
        FileSystemConfig original = (FileSystemConfig)context.getStorage().getPlugin("cp").getConfig();
        HashMap<String, LTSVFormatPluginConfig> newFormats = new HashMap<String, LTSVFormatPluginConfig>(original.getFormats());
        newFormats.put("ltsv", new LTSVFormatPluginConfig());
        FileSystemConfig pluginConfig = new FileSystemConfig(original.getConnection(), original.getConfig(), original.getWorkspaces(), newFormats);
        pluginConfig.setEnabled(Boolean.valueOf(true));
        context.getStorage().createOrUpdate("cp", (StoragePluginConfig)pluginConfig, true);
    }

    @Test
    public void testWildcard() throws Exception {
        this.testBuilder().sqlQuery("SELECT * FROM cp.`simple.ltsv`").unOrdered().baselineColumns(new String[]{"host", "forwardedfor", "req", "status", "size", "referer", "ua", "reqtime", "apptime", "vhost"}).baselineValues(new Object[]{"xxx.xxx.xxx.xxx", "-", "GET /v1/xxx HTTP/1.1", "200", "4968", "-", "Java/1.8.0_131", "2.532", "2.532", "api.example.com"}).baselineValues(new Object[]{"xxx.xxx.xxx.xxx", "-", "GET /v1/yyy HTTP/1.1", "200", "412", "-", "Java/1.8.0_201", "3.580", "3.580", "api.example.com"}).go();
    }

    @Test
    public void testSelectColumns() throws Exception {
        this.testBuilder().sqlQuery("SELECT ua, reqtime FROM cp.`simple.ltsv`").unOrdered().baselineColumns(new String[]{"ua", "reqtime"}).baselineValues(new Object[]{"Java/1.8.0_131", "2.532"}).baselineValues(new Object[]{"Java/1.8.0_201", "3.580"}).go();
    }

    @Test
    public void testQueryWithConditions() throws Exception {
        this.testBuilder().sqlQuery("SELECT * FROM cp.`simple.ltsv` WHERE reqtime > 3.0").unOrdered().baselineColumns(new String[]{"host", "forwardedfor", "req", "status", "size", "referer", "ua", "reqtime", "apptime", "vhost"}).baselineValues(new Object[]{"xxx.xxx.xxx.xxx", "-", "GET /v1/yyy HTTP/1.1", "200", "412", "-", "Java/1.8.0_201", "3.580", "3.580", "api.example.com"}).go();
    }

    @Test
    public void testSkipEmptyLines() throws Exception {
        Assert.assertEquals((long)2L, (long)this.queryBuilder().sql("SELECT * FROM cp.`emptylines.ltsv`").run().recordCount());
    }

    @Test
    public void testReadException() throws Exception {
        try {
            TestLTSVRecordReader.run((String)"SELECT * FROM cp.`invalid.ltsv`", (Object[])new Object[0]);
            Assert.fail();
        }
        catch (UserException e) {
            Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.DATA_READ, (Object)e.getErrorType());
            Assert.assertTrue((boolean)e.getMessage().contains("Failure while reading messages from /invalid.ltsv. Record reader was at record: 1"));
        }
    }
}

