/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.drill.categories.RowSetTest;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.store.log.LogFormatConfig;
import org.apache.drill.exec.store.log.LogFormatField;
import org.apache.drill.exec.store.log.LogFormatPlugin;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryRowSetIterator;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTest.class})
public class TestLogReader
extends ClusterTest {
    public static final String DATE_ONLY_PATTERN = "(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d) .*";
    @ClassRule
    public static final BaseDirTestWatcher dirTestWatcher = new BaseDirTestWatcher();
    protected static File schemaAndConfigDir;
    protected static File schemaOnlyDir;
    private static File tableFuncDir;

    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        TestLogReader.defineRegexPlugin();
    }

    private static void defineRegexPlugin() throws ExecutionSetupException {
        HashMap<String, LogFormatConfig> formats = new HashMap<String, LogFormatConfig>();
        formats.put("sample", TestLogReader.dateOnlyConfig());
        formats.put("drill-log", TestLogReader.drillLogConfig());
        formats.put("date-log", TestLogReader.dateTimeConfig());
        formats.put("mysql-log", TestLogReader.mySqlConfig());
        formats.put("ssdlog", TestLogReader.firewallConfig());
        cluster.defineFormats("cp", formats);
        schemaAndConfigDir = cluster.makeDataDir("sAndC", "logu", (FormatPluginConfig)TestLogReader.untypedDateOnlyConfig());
        LogFormatConfig emptyConfig = new LogFormatConfig(null, "loge", null, null);
        schemaOnlyDir = cluster.makeDataDir("SOnly", "loge", (FormatPluginConfig)emptyConfig);
        tableFuncDir = cluster.makeDataDir("tf", "logf", (FormatPluginConfig)emptyConfig);
    }

    private static LogFormatConfig dateOnlyConfig() {
        ArrayList schema = Lists.newArrayList((Object[])new LogFormatField[]{new LogFormatField("year", "INT"), new LogFormatField("month", "INT"), new LogFormatField("day", "INT")});
        return new LogFormatConfig(DATE_ONLY_PATTERN, "log1", null, (List)schema);
    }

    private static LogFormatConfig untypedDateOnlyConfig() {
        ArrayList schema = Lists.newArrayList((Object[])new LogFormatField[]{new LogFormatField("year"), new LogFormatField("month"), new LogFormatField("day")});
        return new LogFormatConfig(DATE_ONLY_PATTERN, "logu", null, (List)schema);
    }

    private static LogFormatConfig drillLogConfig() {
        String regex = "(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d),\\d+ \\[([^]]*)] (\\w+)\\s+(\\S+) - (.*)";
        ArrayList schema = Lists.newArrayList((Object[])new LogFormatField[]{new LogFormatField("year", "INT"), new LogFormatField("month", "INT"), new LogFormatField("day", "INT"), new LogFormatField("hour", "INT"), new LogFormatField("minute", "INT"), new LogFormatField("second", "INT"), new LogFormatField("thread"), new LogFormatField("level"), new LogFormatField("module"), new LogFormatField("message")});
        return new LogFormatConfig(regex, "log1", null, (List)schema);
    }

    private static LogFormatConfig dateTimeConfig() {
        String regex = "(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}),(\\d+)\\s\\[(\\w+)\\]\\s([A-Z]+)\\s(.+)";
        ArrayList schema = Lists.newArrayList((Object[])new LogFormatField[]{new LogFormatField("entry_date", "TIMESTAMP", "yyyy-MM-dd HH:mm:ss"), new LogFormatField("pid", "INT"), new LogFormatField("location"), new LogFormatField("message_type"), new LogFormatField("message")});
        return new LogFormatConfig(regex, "log2", Integer.valueOf(3), (List)schema);
    }

    private static LogFormatConfig mySqlConfig() {
        String regex = "(\\d{6})\\s(\\d{2}:\\d{2}:\\d{2})\\s+(\\d+)\\s(\\w+)\\s+(.+)";
        return new LogFormatConfig(regex, "sqllog", null, null);
    }

    private static LogFormatConfig firewallConfig() {
        String regex = "(\\w{3}\\s\\d{1,2}\\s\\d{4}\\s\\d{2}:\\d{2}:\\d{2})\\s+(\\w+)\\[(\\d+)\\]:\\s(.*?(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}).*?)";
        ArrayList schema = Lists.newArrayList((Object[])new LogFormatField[]{new LogFormatField("eventDate", "TIMESTAMP", "MMM dd yyyy HH:mm:ss"), new LogFormatField("process_name"), new LogFormatField("pid", "INT"), new LogFormatField("message"), new LogFormatField("src_ip")});
        return new LogFormatConfig(regex, "ssdlog", null, (List)schema);
    }

    @Test
    public void testWildcard() throws RpcException {
        String sql = "SELECT * FROM cp.`regex/simple.log1`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("year", TypeProtos.MinorType.INT).addNullable("month", TypeProtos.MinorType.INT).addNullable("day", TypeProtos.MinorType.INT).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{2017, 12, 17}).addRow(new Object[]{2017, 12, 18}).addRow(new Object[]{2017, 12, 19}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testWildcardLargeFile() throws RpcException {
        String sql = "SELECT * FROM cp.`regex/large.log1`";
        QueryRowSetIterator iter = client.queryBuilder().sql(sql).rowSetIterator();
        for (RowSet rowSet : iter) {
            rowSet.clear();
        }
    }

    @Test
    public void testExplicitProject() throws RpcException {
        String sql = "SELECT `day`, `month` FROM cp.`regex/simple.log1`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("day", TypeProtos.MinorType.INT).addNullable("month", TypeProtos.MinorType.INT).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{17, 12}).addRow(new Object[]{18, 12}).addRow(new Object[]{19, 12}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testMissingColumns() throws RpcException {
        String sql = "SELECT `day`, `missing`, `month` FROM cp.`regex/simple.log1`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("day", TypeProtos.MinorType.INT).addNullable("missing", TypeProtos.MinorType.VARCHAR).addNullable("month", TypeProtos.MinorType.INT).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{17, null, 12}).addRow(new Object[]{18, null, 12}).addRow(new Object[]{19, null, 12}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testRaw() throws RpcException {
        String sql = "SELECT `_raw` FROM cp.`regex/simple.log1`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("_raw", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"2017-12-17 10:52:41,820 [main] INFO  o.a.d.e.e.f.FunctionImplementationRegistry - Function registry loaded.  459 functions loaded in 1396 ms."}).addRow(new Object[]{"2017-12-18 10:52:37,652 [main] INFO  o.a.drill.common.config.DrillConfig - Configuration and plugin file(s) identified in 115ms."}).addRow(new Object[]{"2017-12-19 11:12:27,278 [main] ERROR o.apache.drill.exec.server.Drillbit - Failure during initial startup of Drillbit."}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testDate() throws RpcException {
        String sql = "SELECT TYPEOF(`entry_date`) AS entry_date FROM cp.`regex/simple.log2` LIMIT 1";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("entry_date", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"TIMESTAMP"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testCount() throws RpcException {
        String sql = "SELECT COUNT(*) FROM cp.`regex/simple.log1`";
        long result = client.queryBuilder().sql(sql).singletonLong();
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void testFull() throws RpcException {
        String sql = "SELECT * FROM cp.`regex/simple.log1`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("year", TypeProtos.MinorType.INT).addNullable("month", TypeProtos.MinorType.INT).addNullable("day", TypeProtos.MinorType.INT).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{2017, 12, 17}).addRow(new Object[]{2017, 12, 18}).addRow(new Object[]{2017, 12, 19}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testStarQueryNoSchema() throws RpcException {
        String sql = "SELECT * FROM cp.`regex/mysql.sqllog`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addArray("columns", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"070823", "21:00:32", "1", "Connect", "root@localhost on test1"})).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"070823", "21:00:48", "1", "Query", "show tables"})).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"070823", "21:00:56", "1", "Query", "select * from category"})).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"070917", "16:29:01", "21", "Query", "select * from location"})).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"070917", "16:29:12", "21", "Query", "select * from location where id = 1 LIMIT 1"})).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testSomeFieldsQueryNoSchema() throws RpcException {
        String sql = "SELECT columns[0], columns[4] FROM cp.`regex/mysql.sqllog`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("EXPR$0", TypeProtos.MinorType.VARCHAR).addNullable("EXPR$1", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"070823", "root@localhost on test1"}).addRow(new Object[]{"070823", "show tables"}).addRow(new Object[]{"070823", "select * from category"}).addRow(new Object[]{"070917", "select * from location"}).addRow(new Object[]{"070917", "select * from location where id = 1 LIMIT 1"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testRawNoSchema() throws RpcException {
        String sql = "SELECT _raw FROM cp.`regex/mysql.sqllog`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("_raw", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"070823 21:00:32       1 Connect     root@localhost on test1"}).addRow(new Object[]{"070823 21:00:48       1 Query       show tables"}).addRow(new Object[]{"070823 21:00:56       1 Query       select * from category"}).addRow(new Object[]{"070917 16:29:01      21 Query       select * from location"}).addRow(new Object[]{"070917 16:29:12      21 Query       select * from location where id = 1 LIMIT 1"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testUMNoSchema() throws RpcException {
        String sql = "SELECT _unmatched_rows FROM cp.`regex/mysql.sqllog`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("_unmatched_rows", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"dfadkfjaldkjafsdfjlksdjflksjdlkfjsldkfjslkjl"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testRawUMNoSchema() throws RpcException {
        String sql = "SELECT _raw, _unmatched_rows FROM cp.`regex/mysql.sqllog`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("_raw", TypeProtos.MinorType.VARCHAR).addNullable("_unmatched_rows", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"070823 21:00:32       1 Connect     root@localhost on test1", null}).addRow(new Object[]{"070823 21:00:48       1 Query       show tables", null}).addRow(new Object[]{"070823 21:00:56       1 Query       select * from category", null}).addRow(new Object[]{"070917 16:29:01      21 Query       select * from location", null}).addRow(new Object[]{"070917 16:29:12      21 Query       select * from location where id = 1 LIMIT 1", null}).addRow(new Object[]{null, "dfadkfjaldkjafsdfjlksdjflksjdlkfjsldkfjslkjl"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    private String buildTable(File dir, String ws, String tableName, String fileName, String resource) throws IOException {
        File tableDir = new File(dir, tableName);
        tableDir.mkdirs();
        File dest = new File(tableDir, fileName);
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        FileUtils.copyURLToFile((URL)url, (File)dest);
        return "dfs." + ws + "." + tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProvidedSchema() throws Exception {
        String tablePath = this.buildTable(schemaAndConfigDir, "sAndC", "schema", "sample.logu", "/regex/simple.log1");
        try {
            client.alterSession("store.table.use_schema_file", (Object)true);
            String schemaSql = "create schema (`year` int not null, `month` int not null, `day` int not null) for table " + tablePath;
            TestLogReader.run((String)schemaSql, (Object[])new Object[0]);
            String sql = "SELECT * FROM %s";
            DirectRowSet results = client.queryBuilder().sql(sql, new Object[]{tablePath}).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("year", TypeProtos.MinorType.INT).add("month", TypeProtos.MinorType.INT).add("day", TypeProtos.MinorType.INT).buildSchema();
            RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{2017, 12, 17}).addRow(new Object[]{2017, 12, 18}).addRow(new Object[]{2017, 12, 19}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            client.resetSession("store.table.use_schema_file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaOnlyNoCols() throws Exception {
        String tablePath = this.buildTable(schemaOnlyDir, "sOnly", "noCols", "sample.loge", "/regex/simple.log1");
        try {
            client.alterSession("store.table.use_schema_file", (Object)true);
            String schemaSql = "create schema () for table %s properties ('%s'='%s')";
            TestLogReader.run((String)schemaSql, (Object[])new Object[]{tablePath, LogFormatPlugin.REGEX_PROP, DATE_ONLY_PATTERN});
            String sql = "SELECT * FROM %s";
            DirectRowSet results = client.queryBuilder().sql(sql, new Object[]{tablePath}).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addArray("columns", TypeProtos.MinorType.VARCHAR).buildSchema();
            RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"2017", "12", "17"})).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"2017", "12", "18"})).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"2017", "12", "19"})).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            client.resetSession("store.table.use_schema_file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaOnlyWithCols() throws Exception {
        String tablePath = this.buildTable(schemaOnlyDir, "sOnly", "withCols", "sample.loge", "/regex/simple.log1");
        try {
            client.alterSession("store.table.use_schema_file", (Object)true);
            String schemaSql = "create schema (`year` int not null, `month` int not null, `day` int not null)  for table " + tablePath + " properties ('" + LogFormatPlugin.REGEX_PROP + "'='" + DATE_ONLY_PATTERN + "')";
            TestLogReader.run((String)schemaSql, (Object[])new Object[0]);
            String sql = "SELECT * FROM %s";
            DirectRowSet results = client.queryBuilder().sql(sql, new Object[]{tablePath}).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("year", TypeProtos.MinorType.INT).add("month", TypeProtos.MinorType.INT).add("day", TypeProtos.MinorType.INT).buildSchema();
            RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{2017, 12, 17}).addRow(new Object[]{2017, 12, 18}).addRow(new Object[]{2017, 12, 19}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            client.resetSession("store.table.use_schema_file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaOnlyWithMissingCols() throws Exception {
        String tablePath = this.buildTable(schemaOnlyDir, "sOnly", "missingCols", "sample.loge", "/regex/simple.log1");
        try {
            client.alterSession("store.table.use_schema_file", (Object)true);
            String schemaSql = "create schema (`year` int not null, `month` int not null)  for table " + tablePath + " properties ('" + LogFormatPlugin.REGEX_PROP + "'='" + DATE_ONLY_PATTERN + "')";
            TestLogReader.run((String)schemaSql, (Object[])new Object[0]);
            String sql = "SELECT * FROM %s";
            DirectRowSet results = client.queryBuilder().sql(sql, new Object[]{tablePath}).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().add("year", TypeProtos.MinorType.INT).add("month", TypeProtos.MinorType.INT).addNullable("field_2", TypeProtos.MinorType.VARCHAR).buildSchema();
            RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{2017, 12, "17"}).addRow(new Object[]{2017, 12, "18"}).addRow(new Object[]{2017, 12, "19"}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            client.resetSession("store.table.use_schema_file");
        }
    }

    @Test
    public void testEmptyPattern() throws Exception {
        String tablePath = this.buildTable(tableFuncDir, "tf", "emptyRegex", "sample.logf", "/regex/simple.log1");
        try {
            String sql = "SELECT * FROM %s";
            client.queryBuilder().sql(sql, new Object[]{tablePath}).run();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Regex property is required"));
        }
    }

    @Test
    public void testTableFunction() throws Exception {
        String tablePath = this.buildTable(tableFuncDir, "tf", "table1", "sample.logf", "/regex/simple.log1");
        String escaped = DATE_ONLY_PATTERN.replace("\\", "\\\\");
        String sql = "SELECT * FROM table(%s(type => '%s', regex => '%s', maxErrors => 10))";
        DirectRowSet results = client.queryBuilder().sql(sql, new Object[]{tablePath, "logRegex", escaped}).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addArray("columns", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"2017", "12", "17"})).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"2017", "12", "18"})).addSingleCol((Object)RowSetUtilities.strArray((String[])new String[]{"2017", "12", "19"})).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testTableFunctionNoGroups() throws Exception {
        String tablePath = this.buildTable(tableFuncDir, "tf", "noGroups", "sample.logf", "/regex/simple.log1");
        try {
            String sql = "SELECT * FROM table(%s(type => '%s', regex => '''foo'''))";
            client.queryBuilder().sql(sql, new Object[]{tablePath, "logRegex"}).run();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Regex property has no groups"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableFunctionWithSchema() throws Exception {
        String tablePath = this.buildTable(tableFuncDir, "tf", "table2", "sample.logf", "/regex/simple.log1");
        try {
            client.alterSession("store.table.use_schema_file", (Object)true);
            String escaped = DATE_ONLY_PATTERN.replace("\\", "\\\\");
            String sql = "SELECT * FROM table(%s(schema=>'inline=(`year` int, `month` int, `day` int) properties {`%s`=`%s`}'))";
            DirectRowSet results = client.queryBuilder().sql(sql, new Object[]{tablePath, LogFormatPlugin.REGEX_PROP, escaped}).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("year", TypeProtos.MinorType.INT).addNullable("month", TypeProtos.MinorType.INT).addNullable("day", TypeProtos.MinorType.INT).buildSchema();
            RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{2017, 12, 17}).addRow(new Object[]{2017, 12, 18}).addRow(new Object[]{2017, 12, 19}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            client.resetSession("store.table.use_schema_file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="Use of schema conflicts with plugin field")
    public void testTableFunctionWithConfigAndSchema() throws Exception {
        String tablePath = this.buildTable(tableFuncDir, "tf", "table2", "sample.logf", "/regex/simple.log1");
        try {
            client.alterSession("store.table.use_schema_file", (Object)true);
            String escaped = DATE_ONLY_PATTERN.replace("\\", "\\\\");
            String sql = "SELECT * FROM table(%s(type => '%s', regex => '%s', schema=>'inline=(`year` int, `month` int, `day` int)'))";
            DirectRowSet results = client.queryBuilder().sql(sql, new Object[]{tablePath, "logRegex", escaped}).rowSet();
            TupleMetadata expectedSchema = new SchemaBuilder().addNullable("year", TypeProtos.MinorType.INT).addNullable("month", TypeProtos.MinorType.INT).addNullable("day", TypeProtos.MinorType.INT).buildSchema();
            RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{2017, 12, 17}).addRow(new Object[]{2017, 12, 18}).addRow(new Object[]{2017, 12, 19}).build();
            RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        }
        finally {
            client.resetSession("store.table.use_schema_file");
        }
    }

    @Test
    public void testPluginSerialization() throws IOException {
        ObjectMapper mapper = JacksonUtils.createObjectMapper();
        Assert.assertTrue((boolean)mapper.canSerialize(LogFormatPlugin.class));
        LogFormatConfig sampleConfig = TestLogReader.dateOnlyConfig();
        String json = mapper.writeValueAsString((Object)sampleConfig);
        LogFormatConfig result = (LogFormatConfig)mapper.readValue(json, LogFormatConfig.class);
        Assert.assertEquals((Object)sampleConfig.getRegex(), (Object)result.getRegex());
        Assert.assertEquals((long)sampleConfig.getMaxErrors(), (long)result.getMaxErrors());
        Assert.assertEquals((Object)sampleConfig.getSchema(), (Object)result.getSchema());
    }

    @Test
    public void testFirewallSchema() throws RpcException {
        String sql = "SELECT * FROM cp.`regex/firewall.ssdlog` limit 0";
        DirectRowSet result = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("eventDate", TypeProtos.MinorType.TIMESTAMP).addNullable("process_name", TypeProtos.MinorType.VARCHAR).addNullable("pid", TypeProtos.MinorType.INT).addNullable("message", TypeProtos.MinorType.VARCHAR).addNullable("src_ip", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)result);
        result.clear();
    }
}

