/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.log;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.categories.EvfTest;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.store.easy.text.compliant.BaseCsvTest;
import org.apache.drill.exec.store.log.LogFormatConfig;
import org.apache.drill.exec.store.log.LogFormatField;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={EvfTest.class})
public class TestLogReaderIssue
extends BaseCsvTest {
    private static String[] mock_issue7853 = new String[]{"h2 2021-01-23T23:55:00.664544Z app/alb/abc123", "h2 2021-01-23T23:55:00.666170Z app/alb/abc123"};
    private static String regex_issue7853 = "(\\w{2,}) (\\d{4}-\\d{2}-\\w{5}:\\d{2}:\\d{2}.\\d{6}\\w).*?";

    @BeforeClass
    public static void setup() throws Exception {
        BaseCsvTest.setup((boolean)false, (boolean)false);
        File rootDir = new File(testDir, "root");
        rootDir.mkdir();
        TestLogReaderIssue.buildFile((File)new File(rootDir, "issue7853.log"), (String[])mock_issue7853);
        TestLogReaderIssue.buildFile((File)new File(rootDir, "issue7853.log2"), (String[])mock_issue7853);
        HashMap<String, LogFormatConfig> formats = new HashMap<String, LogFormatConfig>();
        formats.put("log", TestLogReaderIssue.issue7853Config());
        formats.put("log2", TestLogReaderIssue.issue7853UseValidDatetimeFormatConfig());
        cluster.defineFormats("dfs", formats);
    }

    private static LogFormatConfig issue7853Config() {
        ArrayList schema = Lists.newArrayList((Object[])new LogFormatField[]{new LogFormatField("type", "VARCHAR"), new LogFormatField("time", "TIMESTAMP", "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")});
        return new LogFormatConfig(regex_issue7853, "log", null, (List)schema);
    }

    private static LogFormatConfig issue7853UseValidDatetimeFormatConfig() {
        ArrayList schema = Lists.newArrayList((Object[])new LogFormatField[]{new LogFormatField("type", "VARCHAR"), new LogFormatField("time", "TIMESTAMP", "yyyy-MM-dd''T''HH:mm:ss.SSSSSSZ")});
        return new LogFormatConfig(regex_issue7853, "log2", null, (List)schema);
    }

    @Test
    public void testIssue7853UseValidDatetimeFormat() throws Exception {
        String sql = "SELECT type, `time` FROM `dfs.data`.`root/issue7853.log`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("type", TypeProtos.MinorType.VARCHAR).addNullable("time", TypeProtos.MinorType.TIMESTAMP).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"h2", 1611446100664L}).addRow(new Object[]{"h2", 1611446100666L}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testIssue7853() throws Exception {
        String sql = "SELECT type, `time` FROM `dfs.data`.`root/issue7853.log2`";
        UserRemoteException userRemoteException = (UserRemoteException)Assert.assertThrows(UserRemoteException.class, () -> client.queryBuilder().sql(sql).run());
        MatcherAssert.assertThat((Object)userRemoteException.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not valid for type TIMESTAMP"));
        try {
            client.testBuilder().sqlQuery(sql).expectsNumRecords(2).go();
        }
        catch (UserRemoteException | RpcException throwable) {
            // empty catch block
        }
    }
}

