/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.image;

import java.util.TimeZone;
import org.apache.drill.test.BaseTestQuery;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestImageTagValue
extends BaseTestQuery {
    private static TimeZone defaultTimeZone;

    @BeforeClass
    public static void setUp() {
        defaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    private void createAndQuery(String tableName, String imageFile) throws Exception {
        String query = String.format("select * from table(cp.`image/%s`(type => 'image', fileSystemMetadata => false))", imageFile);
        TestImageTagValue.runSQL((String)"alter session set `store.format`='json'");
        TestImageTagValue.test((String)"create table dfs.`%s` as %s", (Object[])new Object[]{tableName, query});
        TestImageTagValue.testBuilder().sqlQuery("select * from dfs.`%s`", new Object[]{tableName}).ordered().jsonBaselineFile("image/" + tableName + ".json").go();
        TestImageTagValue.runSQL((String)"alter session set `store.format` = 'parquet'");
    }

    @Test
    public void testBmpImage() throws Exception {
        this.createAndQuery("bmp", "rose-128x174-24bit.bmp");
    }

    @Test
    public void testGifImage() throws Exception {
        this.createAndQuery("gif", "rose-128x174-8bit-alpha.gif");
    }

    @Test
    public void testIcoImage() throws Exception {
        this.createAndQuery("ico", "rose-32x32-32bit-alpha.ico");
    }

    @Test
    public void testJpegImage() throws Exception {
        this.createAndQuery("jpeg", "withExifAndIptc.jpg");
    }

    @Test
    public void testPcxImage() throws Exception {
        this.createAndQuery("pcx", "rose-128x174-24bit.pcx");
    }

    @Test
    public void testPngImage() throws Exception {
        this.createAndQuery("png", "rose-128x174-32bit-alpha.png");
    }

    @Test
    public void testPsdImage() throws Exception {
        this.createAndQuery("psd", "rose-128x174-32bit-alpha.psd");
    }

    @Test
    public void testTiffImage() throws Exception {
        this.createAndQuery("tiff", "rose-128x174-24bit-lzw.tiff");
    }

    @Test
    public void testWavImage() throws Exception {
        this.createAndQuery("wav", "sample.wav");
    }

    @Test
    public void testAviImage() throws Exception {
        this.createAndQuery("avi", "sample.avi");
    }

    @Test
    public void testWebpImage() throws Exception {
        this.createAndQuery("webp", "1_webp_a.webp");
    }

    @Test
    public void testMovImage() throws Exception {
        this.createAndQuery("mov", "sample.mov");
    }

    @Test
    public void testMp4Image() throws Exception {
        this.createAndQuery("mp4", "sample.mp4");
    }

    @Test
    public void testEpsImage() throws Exception {
        this.createAndQuery("eps", "adobeJpeg1.eps");
    }

    @AfterClass
    public static void cleanUp() {
        TimeZone.setDefault(defaultTimeZone);
    }
}

