/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.image;

import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import org.apache.drill.categories.RowSetTests;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.image.ImageFormatConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.QueryTestUtil;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTests.class})
public class TestImageRecordReader
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("image/", new String[0]));
    }

    @Test
    public void testStarQuery() throws Exception {
        cluster.defineFormat("dfs", "image", (FormatPluginConfig)new ImageFormatConfig(Arrays.asList("bmp"), Boolean.valueOf(false), Boolean.valueOf(false), null));
        String sql = "select * from dfs.`image/*.bmp`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)1L, (long)sets.rowCount());
        sets.clear();
    }

    @Test
    public void testExplicitQuery() throws Exception {
        cluster.defineFormat("dfs", "image", (FormatPluginConfig)new ImageFormatConfig(Arrays.asList("jpg"), Boolean.valueOf(false), Boolean.valueOf(false), null));
        String sql = "select Format, PixelWidth, HasAlpha, `XMP` from dfs.`image/withExifAndIptc.jpg`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("Format", TypeProtos.MinorType.VARCHAR).addNullable("PixelWidth", TypeProtos.MinorType.INT).addNullable("HasAlpha", TypeProtos.MinorType.BIT).addMap("XMP").addNullable("XMPValueCount", TypeProtos.MinorType.INT).addMap("Photoshop").addNullable("CaptionWriter", TypeProtos.MinorType.VARCHAR).addNullable("Headline", TypeProtos.MinorType.VARCHAR).addNullable("AuthorsPosition", TypeProtos.MinorType.VARCHAR).addNullable("Credit", TypeProtos.MinorType.VARCHAR).addNullable("Source", TypeProtos.MinorType.VARCHAR).addNullable("City", TypeProtos.MinorType.VARCHAR).addNullable("State", TypeProtos.MinorType.VARCHAR).addNullable("Country", TypeProtos.MinorType.VARCHAR).addNullable("Category", TypeProtos.MinorType.VARCHAR).addNullable("DateCreated", TypeProtos.MinorType.VARCHAR).addNullable("Urgency", TypeProtos.MinorType.VARCHAR).addArray("SupplementalCategories", TypeProtos.MinorType.VARCHAR).resumeMap().addMap("XmpBJ").addMapArray("JobRef").addNullable("Name", TypeProtos.MinorType.VARCHAR).resumeMap().resumeMap().addMap("XmpMM").addNullable("DocumentID", TypeProtos.MinorType.VARCHAR).addNullable("InstanceID", TypeProtos.MinorType.VARCHAR).resumeMap().addMap("XmpRights").addNullable("WebStatement", TypeProtos.MinorType.VARCHAR).addNullable("Marked", TypeProtos.MinorType.VARCHAR).resumeMap().addMap("Dc").addNullable("Description", TypeProtos.MinorType.VARCHAR).addArray("Creator", TypeProtos.MinorType.VARCHAR).addNullable("Title", TypeProtos.MinorType.VARCHAR).addNullable("Rights", TypeProtos.MinorType.VARCHAR).addArray("Subject", TypeProtos.MinorType.VARCHAR).resumeMap().resumeSchema().buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"JPEG", 600, false, RowSetUtilities.mapValue((Object[])new Object[]{25, RowSetUtilities.mapValue((Object[])new Object[]{"Ian Britton", "Communications", "Photographer", "Ian Britton", "FreeFoto.com", " ", " ", "Ubited Kingdom", "BUS", "2002-06-20", "5", RowSetUtilities.strArray((String[])new String[]{"Communications"})}), RowSetUtilities.singleMap((Object)RowSetUtilities.mapArray((Object[][])new Object[][]{RowSetUtilities.mapValue((Object[])new Object[]{"Photographer"})})), RowSetUtilities.mapValue((Object[])new Object[]{"adobe:docid:photoshop:84d4dba8-9b11-11d6-895d-c4d063a70fb0", "uuid:3ff5d382-9b12-11d6-895d-c4d063a70fb0"}), RowSetUtilities.mapValue((Object[])new Object[]{"www.freefoto.com", "True"}), RowSetUtilities.mapValue((Object[])new Object[]{"Communications", RowSetUtilities.strArray((String[])new String[]{"Ian Britton"}), "Communications", "ian Britton - FreeFoto.com", RowSetUtilities.strArray((String[])new String[]{"Communications"})})})}).build();
        Assert.assertEquals((long)1L, (long)sets.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testLimitPushdown() throws Exception {
        cluster.defineFormat("dfs", "image", (FormatPluginConfig)new ImageFormatConfig(Arrays.asList("mp4"), Boolean.valueOf(false), Boolean.valueOf(false), null));
        String sql = "select * from dfs.`image/*.mp4` limit 1";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        Assert.assertEquals((long)1L, (long)sets.rowCount());
        sets.clear();
    }

    @Test
    public void testSerDe() throws Exception {
        cluster.defineFormat("dfs", "image", (FormatPluginConfig)new ImageFormatConfig(Arrays.asList("jpg"), Boolean.valueOf(false), Boolean.valueOf(false), null));
        String sql = "select count(*) from dfs.`image/*.jpg`";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)2L, (long)cnt);
    }

    @Test
    public void testExplicitQueryWithCompressedFile() throws Exception {
        cluster.defineFormat("dfs", "image", (FormatPluginConfig)new ImageFormatConfig(Arrays.asList("jpg"), Boolean.valueOf(false), Boolean.valueOf(false), null));
        QueryTestUtil.generateCompressedFile((String)"image/LearningApacheDrill.jpg", (String)"zip", (String)"store/image/LearningApacheDrill.jpg.zip");
        String sql = "select Format, PixelWidth, PixelHeight, `FileType` from dfs.`store/image/LearningApacheDrill.jpg.zip`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("Format", TypeProtos.MinorType.VARCHAR).addNullable("PixelWidth", TypeProtos.MinorType.INT).addNullable("PixelHeight", TypeProtos.MinorType.INT).addMap("FileType").addNullable("DetectedFileTypeName", TypeProtos.MinorType.VARCHAR).addNullable("DetectedFileTypeLongName", TypeProtos.MinorType.VARCHAR).addNullable("DetectedMIMEType", TypeProtos.MinorType.VARCHAR).addNullable("ExpectedFileNameExtension", TypeProtos.MinorType.VARCHAR).resumeSchema().buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"JPEG", 800, 800, RowSetUtilities.mapValue((Object[])new Object[]{"JPEG", "Joint Photographic Experts Group", "image/jpeg", "jpg"})}).build();
        Assert.assertEquals((long)1L, (long)sets.rowCount());
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testFileSystemMetadataOption() throws Exception {
        cluster.defineFormat("dfs", "image", (FormatPluginConfig)new ImageFormatConfig(Arrays.asList("gif"), Boolean.valueOf(true), Boolean.valueOf(false), null));
        String sql = "select FileSize, Format, PixelWidth, PixelHeight, ColorMode, BitsPerPixel, Orientation, DPIWidth, DPIHeight, HasAlpha, Duration, VideoCodec, FrameRate, AudioCodec, AudioSampleSize, AudioSampleRate from dfs.`image/*.gif`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("FileSize", TypeProtos.MinorType.BIGINT).addNullable("Format", TypeProtos.MinorType.VARCHAR).addNullable("PixelWidth", TypeProtos.MinorType.INT).addNullable("PixelHeight", TypeProtos.MinorType.INT).addNullable("ColorMode", TypeProtos.MinorType.VARCHAR).addNullable("BitsPerPixel", TypeProtos.MinorType.INT).addNullable("Orientation", TypeProtos.MinorType.INT).addNullable("DPIWidth", TypeProtos.MinorType.FLOAT8).addNullable("DPIHeight", TypeProtos.MinorType.FLOAT8).addNullable("HasAlpha", TypeProtos.MinorType.BIT).addNullable("Duration", TypeProtos.MinorType.BIGINT).addNullable("VideoCodec", TypeProtos.MinorType.VARCHAR).addNullable("FrameRate", TypeProtos.MinorType.FLOAT8).addNullable("AudioCodec", TypeProtos.MinorType.VARCHAR).addNullable("AudioSampleSize", TypeProtos.MinorType.INT).addNullable("AudioSampleRate", TypeProtos.MinorType.FLOAT8).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{10463, "GIF", 128, 174, "Indexed", 8, 0, 0.0, 0.0, true, 0, "Unknown", 0.0, "Unknown", 0, 0.0}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testTimeZoneOption() throws Exception {
        cluster.defineFormat("dfs", "image", (FormatPluginConfig)new ImageFormatConfig(Arrays.asList("psd"), Boolean.valueOf(true), Boolean.valueOf(false), "UTC"));
        String sql = "select ExifIFD0 from dfs.`image/*.psd`";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addMap("ExifIFD0").addNullable("Orientation", TypeProtos.MinorType.INT).addNullable("XResolution", TypeProtos.MinorType.FLOAT8).addNullable("YResolution", TypeProtos.MinorType.FLOAT8).addNullable("ResolutionUnit", TypeProtos.MinorType.INT).addNullable("Software", TypeProtos.MinorType.VARCHAR).addNullable("DateTime", TypeProtos.MinorType.TIMESTAMP).resumeSchema().build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(RowSetUtilities.singleMap((Object)RowSetUtilities.mapValue((Object[])new Object[]{1, 72.009, 72.009, 2, "Adobe Photoshop CS2 Windows", Instant.ofEpochMilli(1454717337000L)}))).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }
}

