/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.httpd;

import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.stream.Collectors;
import org.apache.drill.categories.RowSetTests;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryTestUtil;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTests.class})
public class TestHTTPDLogReader
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        dirTestWatcher.copyResourceToRoot(Paths.get("httpd/", new String[0]));
    }

    @Test
    public void testDateField() throws RpcException {
        String sql = "SELECT `request_receive_time` FROM cp.`httpd/hackers-access-small.httpd` LIMIT 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_receive_time", TypeProtos.MinorType.TIMESTAMP).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{1445742685000L}).addRow(new Object[]{1445742686000L}).addRow(new Object[]{1445742687000L}).addRow(new Object[]{1445743471000L}).addRow(new Object[]{1445743472000L}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testDateEpochField() throws RpcException {
        String sql = "SELECT `request_receive_time`, `request_receive_time_epoch` FROM cp.`httpd/hackers-access-small.httpd` LIMIT 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_receive_time", TypeProtos.MinorType.TIMESTAMP).addNullable("request_receive_time_epoch", TypeProtos.MinorType.TIMESTAMP).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{1445742685000L, 1445742685000L}).addRow(new Object[]{1445742686000L, 1445742686000L}).addRow(new Object[]{1445742687000L, 1445742687000L}).addRow(new Object[]{1445743471000L, 1445743471000L}).addRow(new Object[]{1445743472000L, 1445743472000L}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }

    @Test
    public void testCount() throws Exception {
        String sql = "SELECT COUNT(*) FROM cp.`httpd/hackers-access-small.httpd`";
        long result = client.queryBuilder().sql(sql).singletonLong();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "SELECT COUNT(*) AS cnt FROM cp.`httpd/hackers-access-small.httpd`";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)10L, (long)cnt);
    }

    @Test
    public void testFlattenMap() throws Exception {
        String sql = "SELECT request_firstline_original_uri_query_came__from FROM  table(cp.`httpd/hackers-access-small.httpd` (type => 'httpd', logFormat => '%h %l %u %t \\\"%r\\\" %s %b \\\"%{Referer}i\\\" \\\"%{User-agent}i\\\"', flattenWildcards => true)) WHERE `request_firstline_original_uri_query_came__from` IS NOT NULL";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"columns=\\[`request_firstline_original_uri_query_came__from`\\]"}).match();
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_firstline_original_uri_query_came__from", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"http://howto.basjes.nl/join_form"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testLimitPushdown() throws Exception {
        String sql = "SELECT * FROM cp.`httpd/hackers-access-small.httpd` LIMIT 5";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "limit=5"}).match();
    }

    @Test
    public void testMapField() throws Exception {
        String sql = "SELECT data.`request_firstline_original_uri_query_$`.aqb AS aqb, data.`request_firstline_original_uri_query_$`.t AS data_time FROM cp.`httpd/example1.httpd` AS data";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("aqb", TypeProtos.MinorType.VARCHAR).addNullable("data_time", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"1", "19/5/2012 23:51:27 2 -120"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSingleExplicitColumn() throws Exception {
        String sql = "SELECT request_referer FROM cp.`httpd/hackers-access-small.httpd`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_referer", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"http://howto.basjes.nl/"}).addRow(new Object[]{"http://howto.basjes.nl/"}).addRow(new Object[]{"http://howto.basjes.nl/join_form"}).addRow(new Object[]{"http://howto.basjes.nl/"}).addRow(new Object[]{"http://howto.basjes.nl/join_form"}).addRow(new Object[]{"http://howto.basjes.nl/join_form"}).addRow(new Object[]{"http://howto.basjes.nl/"}).addRow(new Object[]{"http://howto.basjes.nl/login_form"}).addRow(new Object[]{"http://howto.basjes.nl/"}).addRow(new Object[]{"http://howto.basjes.nl/"}).build();
        Assert.assertEquals((long)results.rowCount(), (long)10L);
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testImplicitColumn() throws Exception {
        String sql = "SELECT _raw FROM cp.`httpd/hackers-access-small.httpd`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("_raw", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{"195.154.46.135 - - [25/Oct/2015:04:11:25 +0100] \"GET /linux/doing-pxe-without-dhcp-control HTTP/1.1\" 200 24323 \"http://howto.basjes.nl/\" \"Mozilla/5.0 (Windows NT 5.1; rv:35.0) Gecko/20100101 Firefox/35.0\""}).addRow(new Object[]{"23.95.237.180 - - [25/Oct/2015:04:11:26 +0100] \"GET /join_form HTTP/1.0\" 200 11114 \"http://howto.basjes.nl/\" \"Mozilla/5.0 (Windows NT 5.1; rv:35.0) Gecko/20100101 Firefox/35.0\""}).addRow(new Object[]{"23.95.237.180 - - [25/Oct/2015:04:11:27 +0100] \"POST /join_form HTTP/1.1\" 302 9093 \"http://howto.basjes.nl/join_form\" \"Mozilla/5.0 (Windows NT 5.1; rv:35.0) Gecko/20100101 Firefox/35.0\""}).addRow(new Object[]{"158.222.5.157 - - [25/Oct/2015:04:24:31 +0100] \"GET /join_form HTTP/1.0\" 200 11114 \"http://howto.basjes.nl/\" \"Mozilla/5.0 (Windows NT 6.3; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0 AlexaToolbar/alxf-2.21\""}).addRow(new Object[]{"158.222.5.157 - - [25/Oct/2015:04:24:32 +0100] \"POST /join_form HTTP/1.1\" 302 9093 \"http://howto.basjes.nl/join_form\" \"Mozilla/5.0 (Windows NT 6.3; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0 AlexaToolbar/alxf-2.21\""}).addRow(new Object[]{"158.222.5.157 - - [25/Oct/2015:04:24:37 +0100] \"GET /acl_users/credentials_cookie_auth/require_login?came_from=http%3A//howto.basjes.nl/join_form HTTP/1.1\" 200 10716 \"http://howto.basjes.nl/join_form\" \"Mozilla/5.0 (Windows NT 6.3; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0 AlexaToolbar/alxf-2.21\""}).addRow(new Object[]{"158.222.5.157 - - [25/Oct/2015:04:24:39 +0100] \"GET /login_form HTTP/1.1\" 200 10543 \"http://howto.basjes.nl/\" \"Mozilla/5.0 (Windows NT 6.3; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0 AlexaToolbar/alxf-2.21\""}).addRow(new Object[]{"158.222.5.157 - - [25/Oct/2015:04:24:41 +0100] \"POST /login_form HTTP/1.1\" 200 16810 \"http://howto.basjes.nl/login_form\" \"Mozilla/5.0 (Windows NT 6.3; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0 AlexaToolbar/alxf-2.21\""}).addRow(new Object[]{"5.39.5.5 - - [25/Oct/2015:04:32:22 +0100] \"GET /join_form HTTP/1.1\" 200 11114 \"http://howto.basjes.nl/\" \"Mozilla/5.0 (Windows NT 5.1; rv:34.0) Gecko/20100101 Firefox/34.0\""}).addRow(new Object[]{"180.180.64.16 - - [25/Oct/2015:04:34:37 +0100] \"GET /linux/doing-pxe-without-dhcp-control HTTP/1.1\" 200 24323 \"http://howto.basjes.nl/\" \"Mozilla/5.0 (Windows NT 5.1; rv:35.0) Gecko/20100101 Firefox/35.0\""}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitSomeQuery() throws Exception {
        String sql = "SELECT request_referer_ref, request_receive_time_last_time, request_firstline_uri_protocol FROM cp.`httpd/hackers-access-small.httpd`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_referer_ref", TypeProtos.MinorType.VARCHAR).addNullable("request_receive_time_last_time", TypeProtos.MinorType.TIME).addNullable("request_firstline_uri_protocol", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{null, LocalTime.parse("04:11:25"), null}).addRow(new Object[]{null, LocalTime.parse("04:11:26"), null}).addRow(new Object[]{null, LocalTime.parse("04:11:27"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:31"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:32"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:37"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:39"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:41"), null}).addRow(new Object[]{null, LocalTime.parse("04:32:22"), null}).addRow(new Object[]{null, LocalTime.parse("04:34:37"), null}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitSomeQueryWithCompressedFile() throws Exception {
        QueryTestUtil.generateCompressedFile((String)"httpd/hackers-access-small.httpd", (String)"zip", (String)"httpd/hackers-access-small.httpd.zip");
        String sql = "SELECT request_referer_ref, request_receive_time_last_time, request_firstline_uri_protocol FROM dfs.`httpd/hackers-access-small.httpd.zip`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("request_referer_ref", TypeProtos.MinorType.VARCHAR).addNullable("request_receive_time_last_time", TypeProtos.MinorType.TIME).addNullable("request_firstline_uri_protocol", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{null, LocalTime.parse("04:11:25"), null}).addRow(new Object[]{null, LocalTime.parse("04:11:26"), null}).addRow(new Object[]{null, LocalTime.parse("04:11:27"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:31"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:32"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:37"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:39"), null}).addRow(new Object[]{null, LocalTime.parse("04:24:41"), null}).addRow(new Object[]{null, LocalTime.parse("04:32:22"), null}).addRow(new Object[]{null, LocalTime.parse("04:34:37"), null}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    private TupleMetadata expectedAllFieldsSchema() {
        return new SchemaBuilder().addNullable("connection_client_host", TypeProtos.MinorType.VARCHAR).addNullable("connection_client_host_last", TypeProtos.MinorType.VARCHAR).addNullable("connection_client_logname", TypeProtos.MinorType.BIGINT).addNullable("connection_client_logname_last", TypeProtos.MinorType.BIGINT).addNullable("connection_client_user", TypeProtos.MinorType.VARCHAR).addNullable("connection_client_user_last", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_method", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_method", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_protocol", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_protocol_version", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_uri", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_uri_host", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_uri_path", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_uri_port", TypeProtos.MinorType.BIGINT).addNullable("request_firstline_original_uri_protocol", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_uri_query", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_uri_ref", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_original_uri_userinfo", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_protocol", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_protocol_version", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri_host", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri_path", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri_port", TypeProtos.MinorType.BIGINT).addNullable("request_firstline_uri_protocol", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri_query", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri_ref", TypeProtos.MinorType.VARCHAR).addNullable("request_firstline_uri_userinfo", TypeProtos.MinorType.VARCHAR).addNullable("request_receive_time", TypeProtos.MinorType.TIMESTAMP).addNullable("request_receive_time_date", TypeProtos.MinorType.DATE).addNullable("request_receive_time_date__utc", TypeProtos.MinorType.DATE).addNullable("request_receive_time_day", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_day__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_epoch", TypeProtos.MinorType.TIMESTAMP).addNullable("request_receive_time_hour", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_hour__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last", TypeProtos.MinorType.TIMESTAMP).addNullable("request_receive_time_last_date", TypeProtos.MinorType.DATE).addNullable("request_receive_time_last_date__utc", TypeProtos.MinorType.DATE).addNullable("request_receive_time_last_day", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_day__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_epoch", TypeProtos.MinorType.TIMESTAMP).addNullable("request_receive_time_last_hour", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_hour__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_microsecond", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_microsecond__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_millisecond", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_millisecond__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_minute", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_minute__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_month", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_month__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_monthname", TypeProtos.MinorType.VARCHAR).addNullable("request_receive_time_last_monthname__utc", TypeProtos.MinorType.VARCHAR).addNullable("request_receive_time_last_nanosecond", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_nanosecond__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_second", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_second__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_time", TypeProtos.MinorType.TIME).addNullable("request_receive_time_last_time__utc", TypeProtos.MinorType.TIME).addNullable("request_receive_time_last_timezone", TypeProtos.MinorType.VARCHAR).addNullable("request_receive_time_last_weekofweekyear", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_weekofweekyear__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_weekyear", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_weekyear__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_year", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_last_year__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_microsecond", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_microsecond__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_millisecond", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_millisecond__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_minute", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_minute__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_month", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_month__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_monthname", TypeProtos.MinorType.VARCHAR).addNullable("request_receive_time_monthname__utc", TypeProtos.MinorType.VARCHAR).addNullable("request_receive_time_nanosecond", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_nanosecond__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_second", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_second__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_time", TypeProtos.MinorType.TIME).addNullable("request_receive_time_time__utc", TypeProtos.MinorType.TIME).addNullable("request_receive_time_timezone", TypeProtos.MinorType.VARCHAR).addNullable("request_receive_time_weekofweekyear", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_weekofweekyear__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_weekyear", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_weekyear__utc", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_year", TypeProtos.MinorType.BIGINT).addNullable("request_receive_time_year__utc", TypeProtos.MinorType.BIGINT).addNullable("request_referer", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_host", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_last", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_last_host", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_last_path", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_last_port", TypeProtos.MinorType.BIGINT).addNullable("request_referer_last_protocol", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_last_query", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_last_ref", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_last_userinfo", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_path", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_port", TypeProtos.MinorType.BIGINT).addNullable("request_referer_protocol", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_query", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_ref", TypeProtos.MinorType.VARCHAR).addNullable("request_referer_userinfo", TypeProtos.MinorType.VARCHAR).addNullable("request_status_last", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent", TypeProtos.MinorType.VARCHAR).addNullable("request_user-agent_last", TypeProtos.MinorType.VARCHAR).addNullable("response_body_bytes", TypeProtos.MinorType.BIGINT).addNullable("response_body_bytes_last", TypeProtos.MinorType.BIGINT).addNullable("response_body_bytesclf", TypeProtos.MinorType.BIGINT).add("request_firstline_original_uri_query_$", TypeProtos.MinorType.MAP).add("request_firstline_uri_query_$", TypeProtos.MinorType.MAP).add("request_referer_last_query_$", TypeProtos.MinorType.MAP).add("request_referer_query_$", TypeProtos.MinorType.MAP).build();
    }

    private RowSet expectedAllFieldsRowSet(TupleMetadata expectedSchema) {
        return client.rowSetBuilder(expectedSchema).addRow(new Object[]{"195.154.46.135", "195.154.46.135", null, null, null, null, "GET /linux/doing-pxe-without-dhcp-control HTTP/1.1", "GET", "GET /linux/doing-pxe-without-dhcp-control HTTP/1.1", "GET", "HTTP/1.1", "1.1", "/linux/doing-pxe-without-dhcp-control", null, "/linux/doing-pxe-without-dhcp-control", null, null, null, null, null, "HTTP/1.1", "1.1", "/linux/doing-pxe-without-dhcp-control", null, "/linux/doing-pxe-without-dhcp-control", null, null, null, null, null, 1445742685000L, LocalDate.parse("2015-10-25"), LocalDate.parse("2015-10-25"), 25, 25, 1445742685000L, 4, 3, 1445742685000L, LocalDate.parse("2015-10-25"), LocalDate.parse("2015-10-25"), 25, 25, 1445742685000L, 4, 3, 0, 0, 0, 0, 11, 11, 10, 10, "October", "October", 0, 0, 25, 25, LocalTime.parse("04:11:25"), LocalTime.parse("03:11:25"), "+01:00", 43, 43, 2015, 2015, 2015, 2015, 0, 0, 0, 0, 11, 11, 10, 10, "October", "October", 0, 0, 25, 25, LocalTime.parse("04:11:25"), LocalTime.parse("03:11:25"), "+01:00", 43, 43, 2015, 2015, 2015, 2015, "http://howto.basjes.nl/", "howto.basjes.nl", "http://howto.basjes.nl/", "howto.basjes.nl", "/", null, "http", null, null, null, "/", null, "http", null, null, null, "200", "Mozilla/5.0 (Windows NT 5.1; rv:35.0) Gecko/20100101 Firefox/35.0", "Mozilla/5.0 (Windows NT 5.1; rv:35.0) Gecko/20100101 Firefox/35.0", 24323, 24323, 24323, RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.mapArray((Object[][])new Object[0][]), RowSetUtilities.mapArray((Object[][])new Object[0][])}).build();
    }

    @Test
    public void testStarRowSet() throws Exception {
        String sql = "SELECT * FROM cp.`httpd/hackers-access-really-small.httpd`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = this.expectedAllFieldsSchema();
        RowSet expectedRowSet = this.expectedAllFieldsRowSet(expectedSchema);
        new RowSetComparison(expectedRowSet).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitAllFields() throws Exception {
        TupleMetadata expectedSchema = this.expectedAllFieldsSchema();
        String sql = "SELECT `" + expectedSchema.toFieldList().stream().map(MaterializedField::getName).collect(Collectors.joining("`, `")) + "` FROM cp.`httpd/hackers-access-really-small.httpd`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        RowSet expectedRowSet = this.expectedAllFieldsRowSet(expectedSchema);
        new RowSetComparison(expectedRowSet).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testInvalidFormat() throws Exception {
        String sql = "SELECT * FROM cp.`httpd/dfs-bootstrap.httpd`";
        try {
            TestHTTPDLogReader.run((String)sql, (Object[])new Object[0]);
            Assert.fail();
        }
        catch (DrillRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error reading HTTPD file "));
        }
    }
}

