/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hdf5;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.drill.categories.RowSetTests;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryTestUtil;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTests.class})
public class TestHDF5Format
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestHDF5Format.startCluster((ClusterFixtureBuilder)builder);
        dirTestWatcher.copyResourceToRoot(Paths.get("hdf5/", new String[0]));
    }

    @Test
    public void testExplicitQuery() throws Exception {
        String sql = "SELECT path, data_type, file_name FROM dfs.`hdf5/dset.h5`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("path", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("data_type", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("file_name", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"/dset", "DATASET", "dset.h5"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testStarQuery() throws Exception {
        List<Integer> t1 = Arrays.asList(1, 2, 3, 4, 5, 6);
        List<Integer> t2 = Arrays.asList(7, 8, 9, 10, 11, 12);
        List<Integer> t3 = Arrays.asList(13, 14, 15, 16, 17, 18);
        List<Integer> t4 = Arrays.asList(19, 20, 21, 22, 23, 24);
        ArrayList<List<Integer>> finalList = new ArrayList<List<Integer>>();
        finalList.add(t1);
        finalList.add(t2);
        finalList.add(t3);
        finalList.add(t4);
        this.testBuilder().sqlQuery("SELECT * FROM dfs.`hdf5/dset.h5`").unOrdered().baselineColumns(new String[]{"path", "data_type", "file_name", "data_size", "element_count", "dataset_data_type", "dimensions", "int_data", "is_link"}).baselineValues(new Object[]{"/dset", "DATASET", "dset.h5", 96L, 24L, "int", "[4, 6]", finalList, false}).go();
    }

    @Test
    public void testSimpleExplicitQuery() throws Exception {
        List<Integer> t1 = Arrays.asList(1, 2, 3, 4, 5, 6);
        List<Integer> t2 = Arrays.asList(7, 8, 9, 10, 11, 12);
        List<Integer> t3 = Arrays.asList(13, 14, 15, 16, 17, 18);
        List<Integer> t4 = Arrays.asList(19, 20, 21, 22, 23, 24);
        ArrayList<List<Integer>> finalList = new ArrayList<List<Integer>>();
        finalList.add(t1);
        finalList.add(t2);
        finalList.add(t3);
        finalList.add(t4);
        this.testBuilder().sqlQuery("SELECT path, data_type, file_name, int_data FROM dfs.`hdf5/dset.h5`").unOrdered().baselineColumns(new String[]{"path", "data_type", "file_name", "int_data"}).baselineValues(new Object[]{"/dset", "DATASET", "dset.h5", finalList}).go();
    }

    @Test
    public void testStarQueryWithoutPreview() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/dset.h5` (type => 'hdf5', showPreview => false))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("path", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("data_type", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("file_name", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("data_size", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("is_link", TypeProtos.MinorType.BIT, TypeProtos.DataMode.OPTIONAL).add("element_count", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).add("dataset_data_type", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("dimensions", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"/dset", "DATASET", "dset.h5", 96, false, 24, "int", "[4, 6]"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testFlattenColumnQuery() throws RpcException {
        String sql = "SELECT data[0] AS col1,\ndata[1] as col2,\ndata[2] as col3\nFROM \n(\nSELECT FLATTEN(double_data) AS data \nFROM dfs.`hdf5/browsing.h5` WHERE path='/groupB/dmat'\n)";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("col1", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL).add("col2", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL).add("col3", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1.1, 2.2, 3.3}).addRow(new Object[]{4.4, 5.5, 6.6}).addRow(new Object[]{7.7, 8.8, 9.9}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testFilterWithNonProjectedFieldQuery() throws Exception {
        String sql = "SELECT `path` FROM dfs.`hdf5/browsing.h5` WHERE data_type='DATASET'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("path", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"/groupA/date"}).addRow(new Object[]{"/groupA/string"}).addRow(new Object[]{"/groupB/dmat"}).addRow(new Object[]{"/groupB/inarr"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testFloat32ScalarQuery() throws Exception {
        String sql = "SELECT flatten(float32) AS float_col\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/datatype/float32'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("float_col", TypeProtos.MinorType.FLOAT4, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{-3.4028234663852886E38}).addRow(new Object[]{1.0}).addRow(new Object[]{2.0}).addRow(new Object[]{3.0}).addRow(new Object[]{4.0}).addRow(new Object[]{5.0}).addRow(new Object[]{6.0}).addRow(new Object[]{7.0}).addRow(new Object[]{8.0}).addRow(new Object[]{3.4028234663852886E38}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testFlattenFloat32ScalarQuery() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/datatype/float32'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("float32", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{-3.4028234663852886E38}).addRow(new Object[]{1.0}).addRow(new Object[]{2.0}).addRow(new Object[]{3.0}).addRow(new Object[]{4.0}).addRow(new Object[]{5.0}).addRow(new Object[]{6.0}).addRow(new Object[]{7.0}).addRow(new Object[]{8.0}).addRow(new Object[]{3.4028234663852886E38}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testFloat64ScalarQuery() throws Exception {
        String sql = "SELECT flatten(float64) AS float_col\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/datatype/float64'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("float_col", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{-1.7976931348623157E308}).addRow(new Object[]{1.0}).addRow(new Object[]{2.0}).addRow(new Object[]{3.0}).addRow(new Object[]{4.0}).addRow(new Object[]{5.0}).addRow(new Object[]{6.0}).addRow(new Object[]{7.0}).addRow(new Object[]{8.0}).addRow(new Object[]{Double.MAX_VALUE}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testFlattenFloat64ScalarQuery() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/datatype/float64'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("float64", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{-1.7976931348623157E308}).addRow(new Object[]{1.0}).addRow(new Object[]{2.0}).addRow(new Object[]{3.0}).addRow(new Object[]{4.0}).addRow(new Object[]{5.0}).addRow(new Object[]{6.0}).addRow(new Object[]{7.0}).addRow(new Object[]{8.0}).addRow(new Object[]{Double.MAX_VALUE}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testInt32ScalarQuery() throws Exception {
        String sql = "SELECT flatten(int32) AS int_col\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/datatype/int32'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("int_col", TypeProtos.MinorType.INT, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE}).addRow(new Object[]{1}).addRow(new Object[]{2}).addRow(new Object[]{3}).addRow(new Object[]{4}).addRow(new Object[]{5}).addRow(new Object[]{6}).addRow(new Object[]{7}).addRow(new Object[]{8}).addRow(new Object[]{Integer.MAX_VALUE}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testFlattenInt32ScalarQuery() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/datatype/int32'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("int32", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE}).addRow(new Object[]{1}).addRow(new Object[]{2}).addRow(new Object[]{3}).addRow(new Object[]{4}).addRow(new Object[]{5}).addRow(new Object[]{6}).addRow(new Object[]{7}).addRow(new Object[]{8}).addRow(new Object[]{Integer.MAX_VALUE}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testInt64ScalarQuery() throws Exception {
        String sql = "SELECT flatten(int64) AS long_col\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/datatype/int64'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("long_col", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Long.MIN_VALUE}).addRow(new Object[]{1L}).addRow(new Object[]{2L}).addRow(new Object[]{3L}).addRow(new Object[]{4L}).addRow(new Object[]{5L}).addRow(new Object[]{6L}).addRow(new Object[]{7L}).addRow(new Object[]{8L}).addRow(new Object[]{Long.MAX_VALUE}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testFlattenInt64ScalarQuery() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/datatype/int64'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("int64", TypeProtos.MinorType.BIGINT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Long.MIN_VALUE}).addRow(new Object[]{1L}).addRow(new Object[]{2L}).addRow(new Object[]{3L}).addRow(new Object[]{4L}).addRow(new Object[]{5L}).addRow(new Object[]{6L}).addRow(new Object[]{7L}).addRow(new Object[]{8L}).addRow(new Object[]{Long.MAX_VALUE}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testStringScalarQuery() throws Exception {
        String sql = "SELECT flatten(s10) AS string_col\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/datatype/s10'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("string_col", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"a         "}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{"abcdefghij"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testFlattenStringScalarQuery() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/datatype/s10'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("s10", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"a         "}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{"abcdefghij"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testUnicodeScalarQuery() throws Exception {
        String sql = "SELECT flatten(unicode) AS string_col\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/datatype/unicode'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("string_col", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"a"}).addRow(new Object[]{"\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"}).addRow(new Object[]{"\u65e5\u672c\u8a9e"}).addRow(new Object[]{"\u0627\u0644\u0639\u0631\u0628\u064a\u0629"}).addRow(new Object[]{"\u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440"}).addRow(new Object[]{"\u05e1\u05e7\u05e8\u05df"}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{"abcdefghij"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testUnicodeFlattenScalarQuery() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/datatype/unicode'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("unicode", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"a"}).addRow(new Object[]{"\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"}).addRow(new Object[]{"\u65e5\u672c\u8a9e"}).addRow(new Object[]{"\u0627\u0644\u0639\u0631\u0628\u064a\u0629"}).addRow(new Object[]{"\u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440"}).addRow(new Object[]{"\u05e1\u05e7\u05e8\u05df"}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{""}).addRow(new Object[]{"abcdefghij"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void test1DScalarQuery() throws Exception {
        String sql = "SELECT int_col FROM (SELECT FLATTEN(`1D`) AS int_col\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/nd/1D') WHERE int_col < 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("int_col", TypeProtos.MinorType.INT, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE}).addRow(new Object[]{1}).addRow(new Object[]{2}).addRow(new Object[]{3}).addRow(new Object[]{4}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void test1DFlattenScalarQuery() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/nd/1D')) WHERE `1D` < 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("1D", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE}).addRow(new Object[]{1}).addRow(new Object[]{2}).addRow(new Object[]{3}).addRow(new Object[]{4}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void test2DFlattenScalarQuery() throws Exception {
        String sql = "SELECT int_col_0, int_col_1 FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/nd/2D'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("int_col_0", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE, 1}).addRow(new Object[]{10, 11}).addRow(new Object[]{20, 21}).addRow(new Object[]{30, 31}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void test2DScalarQuery() throws Exception {
        String sql = "SELECT int_data[0] AS col1,\nint_data[1] AS col2\nFROM\n(\nSELECT flatten(int_data) AS int_data\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/nd/2D'\n) AS t1";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("col1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("col2", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE, 1}).addRow(new Object[]{10, 11}).addRow(new Object[]{20, 21}).addRow(new Object[]{30, 31}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void test3DScalarQuery() throws Exception {
        String sql = "SELECT int_data[0] AS col1,\nint_data[1] AS col2\nFROM\n(\nSELECT flatten(int_data) AS int_data\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/nd/3D'\n) AS t1";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("col1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("col2", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE, 5}).addRow(new Object[]{1, 6}).addRow(new Object[]{2, 7}).addRow(new Object[]{3, 8}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void test3DFlattenScalarQuery() throws Exception {
        String sql = "SELECT int_col_0, int_col_1 FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/nd/3D'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("int_col_0", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE, 5}).addRow(new Object[]{1, 6}).addRow(new Object[]{2, 7}).addRow(new Object[]{3, 8}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void test4DScalarQuery() throws Exception {
        String sql = "SELECT int_data[0] AS col1,\nint_data[1] AS col2\nFROM\n(\nSELECT flatten(int_data) AS int_data\nFROM dfs.`hdf5/scalar.h5`\nWHERE path='/nd/4D'\n) AS t1";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("col1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("col2", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE, 5}).addRow(new Object[]{1, 6}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void test4DFlattenScalarQuery() throws Exception {
        String sql = "SELECT int_col_0, int_col_1 FROM table(dfs.`hdf5/scalar.h5` (type => 'hdf5', defaultPath => '/nd/4D')) WHERE int_col_0 <= 2";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("int_col_0", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{Integer.MIN_VALUE, 5}).addRow(new Object[]{1, 6}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testNonScalarIntQuery() throws Exception {
        String sql = "SELECT field_1 FROM( SELECT flatten(t1.compound_data.`field 1`) as field_1\nFROM dfs.`hdf5/non-scalar.h5` AS t1) WHERE field_1 < 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("field_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{0}).addRow(new Object[]{1}).addRow(new Object[]{2}).addRow(new Object[]{3}).addRow(new Object[]{4}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testNonScalarFloatQuery() throws Exception {
        String sql = "SELECT field_2 FROM (SELECT flatten(t1.compound_data.`field 2`) as field_2\nFROM dfs.`hdf5/non-scalar.h5` AS t1) WHERE field_2 < 5.0";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("field_2", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{0.0}).addRow(new Object[]{1.0}).addRow(new Object[]{2.0}).addRow(new Object[]{3.0}).addRow(new Object[]{4.0}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testNonScalarStringQuery() throws Exception {
        String sql = "SELECT field_3 FROM (SELECT flatten(t1.compound_data.`field 3`) as field_3\nFROM dfs.`hdf5/non-scalar.h5` AS t1) WHERE CAST(field_3 AS INTEGER) < 5 ";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("field_3", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"0"}).addRow(new Object[]{"1"}).addRow(new Object[]{"2"}).addRow(new Object[]{"3"}).addRow(new Object[]{"4"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testAttributes() throws Exception {
        String sql = "SELECT path, file_name\nFROM dfs.`hdf5/browsing.h5` AS t1 WHERE t1.attributes.`important` = false";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("path", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("file_name", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"/groupB", "browsing.h5"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testStarProjectDatasetQuery() throws Exception {
        String sql = "SELECT * \nFROM \ntable(dfs.`hdf5/dset.h5` (type => 'hdf5', defaultPath => '/dset'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("int_col_0", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_2", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_3", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_4", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_5", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, 2, 3, 4, 5, 6}).addRow(new Object[]{7, 8, 9, 10, 11, 12}).addRow(new Object[]{13, 14, 15, 16, 17, 18}).addRow(new Object[]{19, 20, 21, 22, 23, 24}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testExplicitProjectDatasetQuery() throws Exception {
        String sql = "SELECT int_col_0, int_col_1, int_col_2, int_col_3, int_col_4\nFROM \ntable(dfs.`hdf5/dset.h5` (type => 'hdf5', defaultPath => '/dset'))";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("int_col_0", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_2", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_3", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("int_col_4", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{1, 2, 3, 4, 5}).addRow(new Object[]{7, 8, 9, 10, 11}).addRow(new Object[]{13, 14, 15, 16, 17}).addRow(new Object[]{19, 20, 21, 22, 23}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testCompoundStarQuery() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/non-scalar.h5` (type => 'hdf5', defaultPath => '/compound')) WHERE field_1 < 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("field_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("field_2", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.OPTIONAL).add("field_3", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{0, 0.0, "0"}).addRow(new Object[]{1, 1.0, "1"}).addRow(new Object[]{2, 2.0, "2"}).addRow(new Object[]{3, 3.0, "3"}).addRow(new Object[]{4, 4.0, "4"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testCompoundExplicitQuery() throws Exception {
        String sql = "SELECT `field_1`, `field_3` FROM table(dfs.`hdf5/non-scalar.h5` (type => 'hdf5', defaultPath => '/compound')) WHERE field_1 < 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("field_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).add("field_3", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{0, "0"}).addRow(new Object[]{1, "1"}).addRow(new Object[]{2, "2"}).addRow(new Object[]{3, "3"}).addRow(new Object[]{4, "4"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testCompoundExplicitQuery2() throws Exception {
        String sql = "SELECT `field_1` FROM table(dfs.`hdf5/non-scalar.h5` (type => 'hdf5', defaultPath => '/compound')) WHERE field_1 < 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("field_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{0}).addRow(new Object[]{1}).addRow(new Object[]{2}).addRow(new Object[]{3}).addRow(new Object[]{4}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "SELECT COUNT(*) FROM dfs.`hdf5/dset.h5`";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)1L, (long)cnt);
    }

    @Test
    public void testExplicitQueryWithCompressedFile() throws Exception {
        QueryTestUtil.generateCompressedFile((String)"hdf5/dset.h5", (String)"zip", (String)"hdf5/dset.h5.zip");
        String sql = "SELECT path, data_type, file_name FROM dfs.`hdf5/dset.h5.zip`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("path", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("data_type", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("file_name", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"/dset", "DATASET", "dset.h5.zip"}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }

    @Test
    public void testInlineSchema() throws Exception {
        String sql = "SELECT * FROM table(dfs.`hdf5/non-scalar.h5` (type => 'hdf5', defaultPath => '/compound', schema => 'inline=(field_1 int not null, field_2 double not null, field_3 varchar not null, fixed_field int not null default `20`)')) WHERE field_1 < 5";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("field_1", TypeProtos.MinorType.INT, TypeProtos.DataMode.REQUIRED).add("field_2", TypeProtos.MinorType.FLOAT8, TypeProtos.DataMode.REQUIRED).add("field_3", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.REQUIRED).add("fixed_field", TypeProtos.MinorType.INT, TypeProtos.DataMode.REQUIRED).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{0, 0.0, "0", 20}).addRow(new Object[]{1, 1.0, "1", 20}).addRow(new Object[]{2, 2.0, "2", 20}).addRow(new Object[]{3, 3.0, "3", 20}).addRow(new Object[]{4, 4.0, "4", 20}).build();
        new RowSetComparison((RowSet)expected).unorderedVerifyAndClearAll((RowSet)results);
    }
}

